/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.paramcodec;

import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.ow.server.util.paramcodec.OwAlphabetCoder;
import com.wewebu.ow.server.util.paramcodec.OwCookieStoreCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwTransientCodec
extends OwCookieStoreCodec {
    private static final Logger LOG = OwLogCore.getLogger(OwTransientCodec.class);
    private static Map m_livingCookies = new HashMap();
    private static long m_nextUniqueNameIndex = 0L;

    public static OwTransientCodec createConfiguredCodec(OwMainAppContext context_p) throws OwInvalidOperationException {
        try {
            OwConfiguration configuration = context_p.getConfiguration();
            OwXMLUtil bootstrapConfiguration = configuration.getBootstrapConfiguration();
            OwXMLUtil codecConfiguration_p = bootstrapConfiguration.getSubUtil("URLParameterCodec");
            long urlLifeTime = 157680000000L;
            String cookieParameter = "trcp";
            if (codecConfiguration_p == null) {
                LOG.debug((Object)"OwTransientCodec.createConfiguredCodec(): configuration is missing ! Proceeding with the following default values:");
                LOG.debug((Object)("OwTransientCodec.createConfiguredCodec(): default URL life time\t          \t:" + urlLifeTime + " ms"));
                LOG.debug((Object)("OwTransientCodec.createConfiguredCodec(): default URL parameter name    \t\t:" + cookieParameter));
            } else {
                urlLifeTime = OwTransientCodec.loadUrlLifeTimeConfig(codecConfiguration_p);
                cookieParameter = OwTransientCodec.loadUrlParameterConfig(codecConfiguration_p);
            }
            if (codecConfiguration_p != null) {
                LOG.debug((Object)"OwTransientCodec.createConfiguredCodec(): Creating codec with the following loaded configuration :");
                LOG.debug((Object)("OwTransientCodec.createConfiguredCodec(): URL life time\t          \t:" + urlLifeTime + " ms"));
                LOG.debug((Object)("OwTransientCodec.createConfiguredCodec(): URL parameter name    \t\t:" + cookieParameter));
            }
            return new OwTransientCodec(cookieParameter, urlLifeTime);
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Could not load the configured OwNetworkAttributeBagCodec!", (Throwable)e);
        }
    }

    public OwTransientCodec() {
    }

    public OwTransientCodec(long namesExpirationTime_p) {
        super(namesExpirationTime_p);
    }

    public OwTransientCodec(String cookieParamenterName_p, long namesExpirationTime_p) {
        super(cookieParamenterName_p, namesExpirationTime_p);
    }

    public OwTransientCodec(OwAlphabetCoder alphabetCder_p, long initialNameIndex_p, String cookieParamenterName_p, long namesExpirationTime_p) {
        super(alphabetCder_p, cookieParamenterName_p, namesExpirationTime_p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addCookieValue(OwCookieStoreCodec.OwTimedCookieValue timedCookieValue_p) {
        Class<OwTransientCodec> clazz = OwTransientCodec.class;
        synchronized (OwTransientCodec.class) {
            m_livingCookies.put(timedCookieValue_p.getCookieName(), timedCookieValue_p);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List createTimedCookieCollectList() {
        Class<OwTransientCodec> clazz = OwTransientCodec.class;
        synchronized (OwTransientCodec.class) {
            Collection values = m_livingCookies.values();
            ArrayList<OwCookieStoreCodec.OwTimedCookie> timedCookies = new ArrayList<OwCookieStoreCodec.OwTimedCookie>();
            for (OwCookieStoreCodec.OwTimedCookieValue value : values) {
                timedCookies.add(value.getTimedCookie());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return timedCookies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OwCookieStoreCodec.OwTimedCookieValue getCookieValue(String cookieName_p) {
        Class<OwTransientCodec> clazz = OwTransientCodec.class;
        synchronized (OwTransientCodec.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (OwCookieStoreCodec.OwTimedCookieValue)m_livingCookies.get(cookieName_p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void remove(OwCookieStoreCodec.OwTimedCookie timedCookie_p) {
        Class<OwTransientCodec> clazz = OwTransientCodec.class;
        synchronized (OwTransientCodec.class) {
            m_livingCookies.remove(timedCookie_p.getCookieName());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized String peekAtNextURLParameter() throws OwException {
        Class<OwTransientCodec> clazz = OwTransientCodec.class;
        synchronized (OwTransientCodec.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.createCookie(m_nextUniqueNameIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long getNextUnqiueNameIndex() {
        Class<OwTransientCodec> clazz = OwTransientCodec.class;
        synchronized (OwTransientCodec.class) {
            long nextNameIndex = m_nextUniqueNameIndex++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return nextNameIndex;
        }
    }
}

