/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.service.rendition.impl;

import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.HashMap;
import java.util.List;

public class OwProviderConfiguration {
    private static final String EL_MAPPING = "mapping";
    private static final String EL_NETWORK = "network";
    private static final String AT_DMSPREFIX = "dmsPrefix";
    private static final String EL_FALLBACK_SERVICE = "fallback-service";
    private HashMap<String, OwXMLUtil> providerMapping;
    private OwXMLUtil fallBackCfg;

    private OwProviderConfiguration(HashMap<String, OwXMLUtil> providerMapping, OwXMLUtil fallBackCfg) {
        this.providerMapping = providerMapping;
        this.fallBackCfg = fallBackCfg;
    }

    public static OwProviderConfiguration fromXML(OwXMLUtil rootConf) throws OwConfigurationException {
        HashMap<String, OwXMLUtil> providerMapping = new HashMap<String, OwXMLUtil>();
        List mappings = rootConf.getSafeUtilList(EL_MAPPING, EL_NETWORK);
        for (OwXMLUtil network : mappings) {
            String prefix = network.getSafeStringAttributeValue(AT_DMSPREFIX, null);
            providerMapping.put(prefix, network);
        }
        OwXMLUtil fallBackXML = null;
        try {
            fallBackXML = rootConf.getSubUtil(EL_FALLBACK_SERVICE);
        }
        catch (Exception e) {
            throw new OwConfigurationException("Could not read configuration for the fallback rendition service provider.", (Throwable)e);
        }
        return new OwProviderConfiguration(providerMapping, fallBackXML);
    }

    public OwXMLUtil getProviderCfgFor(String mappingPrefix) {
        return this.providerMapping.get(mappingPrefix);
    }

    public OwXMLUtil getFallBackCfg() {
        return this.fallBackCfg;
    }
}

