/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.service.rendition.impl;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwMimeTypes;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.service.rendition.OwConfigurableRenditionService;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class OwSymbolicRenditionService
implements OwConfigurableRenditionService {
    private static final String IMAGE_ATTRIBUTE = "image";
    private static final String MIME_ATTRIBUTE = "mime";
    private static final String UNKNOWN = "unknown";
    private static final Logger LOG = OwLogCore.getLogger(OwSymbolicRenditionService.class);
    private static final String EL_THUMBNAIL = "thumbnail";
    private static final String EL_THUMBNAILS = "thumbnails";
    private Map<String, String> configuredThumbnails = new HashMap<String, String>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getRenditionStream(OwObject obj, String type) throws IOException, OwException {
        this.readLock.lock();
        try {
            String path;
            try {
                path = this.configuredThumbnails.get(obj.getMIMEType());
            }
            catch (OwException e) {
                throw e;
            }
            catch (Exception e) {
                throw new OwInvalidOperationException("Could not retrieve thumbnail.", (Throwable)e);
            }
            InputStream inputStream = this.getClass().getResourceAsStream(path);
            return inputStream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getRenditionMimeType(OwObject obj, String type) throws OwException {
        try {
            String path;
            this.readLock.lock();
            LinkedList<String> result = new LinkedList<String>();
            try {
                path = this.configuredThumbnails.get(obj.getMIMEType());
            }
            catch (OwException e) {
                throw e;
            }
            catch (Exception e) {
                throw new OwInvalidOperationException("Could not retrieve thumbnail.", (Throwable)e);
            }
            String mime = OwMimeTypes.getMimeTypeFromPath(path);
            if (mime == null) {
                LinkedList<String> linkedList = result;
                return linkedList;
            }
            result.add(mime);
            LinkedList<String> linkedList = result;
            return linkedList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRendition(OwObject obj, String type) {
        this.readLock.lock();
        try {
            if (!obj.hasContent(2)) {
                boolean bl = false;
                return bl;
            }
            String mimeType = obj.getMIMEType();
            boolean bl = this.configuredThumbnails.get(mimeType) != null;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not retrive MIME type.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void createRendition(OwObject obj, String type) throws OwException {
        this.writeLock.lock();
        try {
            if (!obj.hasContent(2)) {
                throw new OwInvalidOperationException("Can not create thumbnail for no-content objects.");
            }
            String mime = obj.getMIMEType();
            if (!this.configuredThumbnails.containsKey(mime)) {
                if (!this.configuredThumbnails.containsKey(UNKNOWN)) throw new OwConfigurationException("Can not create new-unknown MIME thumbs.Please add unknown thumb configuration.");
                this.configuredThumbnails.put(mime, this.configuredThumbnails.get(UNKNOWN));
                return;
            } else {
                if (this.configuredThumbnails.get(mime) != null) return;
                throw new OwConfigurationException("Create error simmulation : for development purposes only. Generated by missing image attribute in thumbnails configuration for MIME " + mime);
            }
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Could not retrieve thumbnail.", (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean canCreateRendition(OwObject obj, String type) throws OwException {
        try {
            return obj.hasContent(2);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Could not check content.", (Throwable)e);
        }
    }

    @Override
    public void init(OwXMLUtil serviceXMLUtil) throws OwException {
        List thumbnails = serviceXMLUtil.getSafeUtilList(EL_THUMBNAILS, EL_THUMBNAIL);
        for (OwXMLUtil thumbnail : thumbnails) {
            String mime = thumbnail.getSafeStringAttributeValue(MIME_ATTRIBUTE, null);
            String image = thumbnail.getSafeStringAttributeValue(IMAGE_ATTRIBUTE, null);
            if (mime != null && image != null) {
                this.configuredThumbnails.put(mime, image);
                continue;
            }
            if (image != null || mime == null) continue;
            this.configuredThumbnails.put(mime, null);
        }
    }
}

