/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wd.ui.conf;

import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.wd.ui.conf.OwPropertySubregion;
import org.alfresco.wd.ui.conf.OwSimplePropertySubregion;
import org.alfresco.wd.ui.conf.prop.OwPropertyGroup;
import org.alfresco.wd.ui.conf.prop.OwPropertyInfo;
import org.alfresco.wd.ui.conf.prop.OwSimplePropertyGroup;
import org.apache.log4j.Logger;

public class OwPropertyListConfiguration {
    private static Logger LOG = OwLogCore.getLogger(OwPropertyListConfiguration.class);
    public static final String ATT_COLLAPSED = "collapsed";
    public static final String ATT_ID = "id";
    public static final String ATT_READONLY = "readonly";
    public static final String ATT_DISPLAY_NAME = "displayname";
    public static final String ELEM_ROOT_NODE = "EditPropertyList";
    public static final String ELEM_PROPERTY_GROUP = "PropertyGroup";
    public static final String ELEM_PROPERTY = "property";
    private List<OwPropertySubregion<OwPropertyInfo>> subregions = new LinkedList<OwPropertySubregion<OwPropertyInfo>>();
    private Map<String, OwPropertySubregion<OwPropertyInfo>> groupSubregionMap = new HashMap<String, OwPropertySubregion<OwPropertyInfo>>();
    private String groupIdPrefix;

    public OwPropertyListConfiguration() {
        this(null);
    }

    public OwPropertyListConfiguration(String groupIdPrefix) {
        this.groupIdPrefix = groupIdPrefix;
    }

    public List<OwPropertySubregion<OwPropertyInfo>> getSubregions() {
        return this.subregions;
    }

    public OwPropertySubregion<OwPropertyInfo> getGroupRegion(String groupId) {
        return this.groupSubregionMap.get(groupId);
    }

    public void addRegion(OwPropertySubregion<OwPropertyInfo> region) {
        if (region == null) {
            throw new NullPointerException("Null region are not allowed to be added.");
        }
        this.subregions.add(region);
        if (region.isGroup()) {
            this.groupSubregionMap.put(region.getPropertyGroup().getGroupId(), region);
        }
    }

    public void build(OwXMLUtil configuration) throws OwConfigurationException {
        List confUtils = configuration.getSafeUtilList(null);
        Iterator it = confUtils.iterator();
        LinkedList<OwPropertyInfo> propLst = null;
        while (it.hasNext()) {
            OwXMLUtil conf = (OwXMLUtil)it.next();
            if (ELEM_PROPERTY.equals(conf.getName())) {
                OwPropertyInfo propInfo = this.buildPropertyInfo(conf);
                if (propInfo == null) continue;
                if (propLst == null) {
                    propLst = new LinkedList<OwPropertyInfo>();
                }
                propLst.add(propInfo);
                continue;
            }
            if (ELEM_PROPERTY_GROUP.equals(conf.getName())) {
                OwPropertySubregion<OwPropertyInfo> region;
                OwPropertyGroup<OwPropertyInfo> propGroup = this.buildPropertyGroup(conf);
                if (propLst != null) {
                    region = this.createSubRegion(propLst);
                    this.addRegion(region);
                    propLst = null;
                }
                region = this.createSubRegion(propGroup);
                this.addRegion(region);
                continue;
            }
            LOG.info((Object)("OwPropertyListConfiguration.build: unknown/unsupported element found [" + conf.getName() + "] will be ignored."));
        }
        if (propLst != null) {
            OwPropertySubregion<OwPropertyInfo> region = this.createSubRegion(propLst);
            this.addRegion(region);
        }
    }

    protected OwPropertyInfo buildPropertyInfo(OwXMLUtil conf) throws OwConfigurationException {
        boolean readOnly = conf.getSafeBooleanAttributeValue(ATT_READONLY, false);
        String propId = conf.getSafeTextValue(null);
        if (propId == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("OwPropertyListConfiguration.build: unknown/unsupported element found [" + conf.getName() + "] will be ignored."));
            }
            return null;
        }
        return new OwPropertyInfo(propId, readOnly);
    }

    protected OwPropertyGroup<OwPropertyInfo> buildPropertyGroup(OwXMLUtil conf) throws OwConfigurationException {
        Iterator itProp = conf.getSafeUtilList(null).iterator();
        LinkedList<OwPropertyInfo> propInfos = new LinkedList<OwPropertyInfo>();
        while (itProp.hasNext()) {
            OwXMLUtil propUtil = (OwXMLUtil)itProp.next();
            OwPropertyInfo propInfo = this.buildPropertyInfo(propUtil);
            if (propInfo == null) continue;
            propInfos.add(propInfo);
        }
        String groupId = conf.getSafeStringAttributeValue(ATT_ID, null);
        String displayName = conf.getSafeStringAttributeValue(ATT_DISPLAY_NAME, null);
        boolean collapsed = conf.getSafeBooleanAttributeValue(ATT_COLLAPSED, false);
        if (this.getGroupIdPrefix() != null) {
            groupId = this.getGroupIdPrefix() + "." + groupId;
        }
        return new OwSimplePropertyGroup<OwPropertyInfo>(groupId, displayName, propInfos, collapsed);
    }

    public String getGroupIdPrefix() {
        return this.groupIdPrefix;
    }

    protected <T extends OwPropertyInfo> OwPropertySubregion<T> createSubRegion(List<T> propInfos) {
        return new OwSimplePropertySubregion<T>(propInfos);
    }

    protected <T extends OwPropertyInfo> OwPropertySubregion<T> createSubRegion(OwPropertyGroup<T> propGroup) {
        return new OwSimplePropertySubregion<T>(propGroup);
    }
}

