/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wd.ui.conf.prop;

import com.wewebu.ow.server.ui.OwAppContext;
import java.util.Collections;
import java.util.List;
import org.alfresco.wd.ui.conf.prop.OwPropertyGroup;
import org.alfresco.wd.ui.conf.prop.OwPropertyInfo;

public class OwSimplePropertyGroup<T extends OwPropertyInfo>
implements OwPropertyGroup<T> {
    private String groupId;
    private String groupDisplayName;
    private boolean isCollapsed;
    private List<T> properties;

    public OwSimplePropertyGroup(String groupId, String groupDisplayName, List<T> propertyInfos) {
        this(groupId, groupDisplayName, propertyInfos, false);
    }

    public OwSimplePropertyGroup(String groupId, String groupDisplayName, List<T> propertyInfos, boolean isCollapsed) {
        this.groupId = groupId;
        this.groupDisplayName = groupDisplayName;
        this.properties = propertyInfos;
        this.isCollapsed = isCollapsed;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public List<T> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    @Override
    public String getDisplayName(OwAppContext context) {
        return context.localize(this.getGroupId(), this.groupDisplayName);
    }

    @Override
    public void setCollapsed(boolean isCollapsed) {
        this.isCollapsed = isCollapsed;
    }

    @Override
    public boolean isCollapsed() {
        return this.isCollapsed;
    }
}

