/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wd.ui.profile;

import com.wewebu.ow.server.app.OwGlobalParametersConfiguration;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.role.OwRoleManagerContext;
import com.wewebu.ow.server.ui.OwView;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.wd.ext.restlet.auth.OwRestletAuthenticationHandler;
import org.alfresco.wd.ui.profile.restlet.AlfrescoRestFactory;
import org.apache.log4j.Logger;

public class OwChangePasswordView
extends OwView {
    private static final Logger LOG = OwLogCore.getLogger(OwChangePasswordView.class);
    public static final String OLD_PWD = "oldPwd";
    public static final String NEW_PWD = "newPwd";
    public static final String CONFIRM_PWD = "confirmPwd";
    private boolean passwordChanged;

    @Override
    protected void onRender(Writer w_p) throws Exception {
        w_p.write("<div class=\"OwPane changePwd\">");
        this.renderPasswordRow(w_p, this.getContext().localize("profile.OwChangePasswordView.lbl.oldPwd", "Old Password"), OLD_PWD, "even");
        this.renderPasswordRow(w_p, this.getContext().localize("profile.OwChangePasswordView.lbl.newPwd", "New Password"), NEW_PWD, "odd");
        this.renderPasswordRow(w_p, this.getContext().localize("profile.OwChangePasswordView.lbl.confirmPwd", "Confirm Password"), CONFIRM_PWD, "even");
        w_p.write("</div><div class=\"menu OwInlineMenu\">");
        String url = this.getEventURL("ChangePwd", null);
        w_p.write("<button type=\"submit\" form=\"");
        w_p.write(this.getFormName());
        w_p.write("\" formaction=\"");
        w_p.write(url);
        w_p.write("\" />");
        w_p.write(this.getContext().localize("profile.OwChangePasswordView.btn.submit", "Change Password"));
        w_p.write("</button></div>");
    }

    protected void renderPasswordRow(Writer w, String label, String inputId, String addRowClass) throws IOException {
        this.renderRow(w, "password", label, inputId, addRowClass);
    }

    protected void renderRow(Writer w, String inputType, String label, String inputId, String addRowClass) throws IOException {
        w.append("<div class=\"row");
        if (addRowClass != null) {
            w.append(" ").append(addRowClass);
        }
        w.append("\"><span class=\"label\">");
        w.append(label);
        w.append("</span><span class=\"value\">");
        w.append("<input type=\"");
        w.append(inputType);
        w.append("\" id=\"");
        w.append(inputId);
        w.append("\" name=\"");
        w.append(inputId);
        w.append("\" class=\"OwInputControl\" />");
        w.append("</span></div>\n");
    }

    @Override
    protected String usesFormWithAttributes() {
        return "";
    }

    public void onChangePwd(HttpServletRequest req) throws Exception {
        String old = req.getParameter(OLD_PWD);
        String newPwd = req.getParameter(NEW_PWD);
        String confirm = req.getParameter(CONFIRM_PWD);
        if (newPwd == null || confirm == null || !newPwd.equals(confirm)) {
            throw new OwInvalidOperationException(this.getContext().localize("profile.OwChangePasswordView.msg.err.confirm", "New Password and confirmation does not match."));
        }
        this.passwordChanged = this.changePassword(old, newPwd);
        if (this.passwordChanged) {
            OwMainAppContext mainCtx = (OwMainAppContext)this.getContext();
            mainCtx.postMessage(mainCtx.localize("profile.OwChangePasswordView.msg.relogin", "Your password was changed successfully. After closing this dialog you need to log in again with your new password. Your current session is now invalid."));
        }
    }

    protected boolean changePassword(String oldPwd, String newPwd) throws OwException {
        OwRoleManagerContext roleCtx = this.getContext().getRegisteredInterface(OwRoleManagerContext.class);
        if (roleCtx.getNetwork().hasInterface(OwRestletAuthenticationHandler.class.getCanonicalName())) {
            OwRestletAuthenticationHandler authHandler;
            try {
                authHandler = (OwRestletAuthenticationHandler)roleCtx.getNetwork().getInterface(OwRestletAuthenticationHandler.class.getCanonicalName(), null);
            }
            catch (OwException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new OwNotSupportedException(this.getContext().localize("profile.OwChangePasswordView.err.authHandler", "Cannot change password, unable to get authentication handler."), (Throwable)ex);
            }
            OwGlobalParametersConfiguration util = ((OwMainAppContext)this.getContext()).getConfiguration().getGlobalParameters();
            String url = util.getSafeString("EcmBaseUrl", null);
            if (url != null) {
                AlfrescoRestFactory connection = new AlfrescoRestFactory(url, authHandler);
                connection.changePassword(this.getUserName(), oldPwd, newPwd);
                return true;
            }
        } else {
            LOG.warn((Object)("OwChangePasswordView.changePassword: Network des not support " + OwRestletAuthenticationHandler.class.getCanonicalName() + " interface."));
            throw new OwInvalidOperationException(this.getContext().localize("profile.OwChangePasswordView.err.missingAuthHandler", "Missing authentication handler support."));
        }
        return false;
    }

    protected String getUserName() throws OwException {
        try {
            return this.getContext().getUserInfo().getUserName();
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwServerException(this.getContext().localize("profile.OwChangePasswordView.err.getUserName", "Unable to retrieve user name."), (Throwable)e);
        }
    }

    public boolean isPasswordChanged() {
        return this.passwordChanged;
    }
}

