/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wd.ui.profile.restlet;

import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwString1;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.LinkedList;
import org.alfresco.wd.ext.restlet.auth.OwRestletAuthenticationHandler;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.restlet.Client;
import org.restlet.Uniform;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;

public class AlfrescoRestFactory {
    protected static final String SERVICE_URI = "/service/api/person/changepassword/";
    private String baseUrl;
    private OwRestletAuthenticationHandler authHandler;

    public AlfrescoRestFactory(String baseUrl, OwRestletAuthenticationHandler authHandler) {
        this.baseUrl = baseUrl;
        this.authHandler = authHandler;
    }

    public void changePassword(String userName, String oldPassword, String newPassword) throws OwException {
        String service;
        Client client = this.createClient();
        try {
            service = SERVICE_URI + URLEncoder.encode(userName, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OwServerException("Unable to encode userName with UTF-8 encoding", (Throwable)e);
        }
        ClientResource cr = this.createClientResource(service, client);
        PasswordPostData data = this.createPasswordPostData(oldPassword, newPassword);
        try {
            cr.post((Object)data);
        }
        catch (ResourceException rex) {
            String msg = null;
            try {
                StringWriter cache = new StringWriter();
                cr.getResponseEntity().write((Writer)cache);
                StringBuffer buf = cache.getBuffer();
                String keyWord = "\"message\"";
                int idx = buf.indexOf(keyWord);
                if (idx > 0) {
                    msg = buf.substring(idx);
                    idx = msg.indexOf(34, keyWord.length());
                    msg = msg.substring(idx, msg.indexOf(34, idx + 1));
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new OwServerException(new OwString1("profile.restlet.AlfrescoRestFactory.err.changePwd", "Unable to change password (%1).", msg == null ? rex.getMessage() : msg), (Throwable)rex);
        }
        finally {
            try {
                client.stop();
            }
            catch (Exception e) {
                throw new OwServerException("Failed to close connection", (Throwable)e);
            }
        }
    }

    protected ClientResource createClientResource(String uri, Client client) throws OwException {
        ClientResource cr = new ClientResource(this.baseUrl + uri);
        this.getAuthHandler().prepareCall(cr);
        cr.setNext((Uniform)client);
        return cr;
    }

    protected Client createClient() {
        LinkedList<Protocol> protocols = new LinkedList<Protocol>();
        protocols.add(Protocol.HTTPS);
        protocols.add(Protocol.HTTP);
        return new Client(protocols);
    }

    protected OwRestletAuthenticationHandler getAuthHandler() {
        return this.authHandler;
    }

    protected PasswordPostData createPasswordPostData(String oldPassword, String newPassword) {
        return new PasswordPostData(newPassword, oldPassword);
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    public static class PasswordPostData {
        private String newpw;
        private String oldpw;

        public PasswordPostData() {
        }

        public PasswordPostData(String newpw, String oldpw) {
            this.newpw = newpw;
            this.oldpw = oldpw;
        }

        public String getNewpw() {
            return this.newpw;
        }

        public void setNewpw(String newpw) {
            this.newpw = newpw;
        }

        public String getOldpw() {
            return this.oldpw;
        }

        public void setOldpw(String oldpw) {
            this.oldpw = oldpw;
        }
    }
}

