/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wd.util.loader;

import com.wewebu.ow.server.exceptions.OwRuntimeException;
import org.alfresco.wd.util.loader.OwLoader;

public class OwClassInstanceLoader<T, O extends T>
implements OwLoader<T> {
    private Class<O> type;

    public OwClassInstanceLoader(Class<O> type) {
        this.type = type;
    }

    @Override
    public T load() {
        try {
            return (T)this.type.newInstance();
        }
        catch (InstantiationException e) {
            throw new OwClassInstanceLoaderException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new OwClassInstanceLoaderException(e.getMessage(), (Throwable)e);
        }
    }

    private static class OwClassInstanceLoaderException
    extends OwRuntimeException {
        private static final long serialVersionUID = 8787642640104197533L;

        public OwClassInstanceLoaderException(String message_p, Throwable cause_p) {
            super(message_p, cause_p);
        }

        @Override
        public String getModulName() {
            return "owd.core";
        }
    }
}

