/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class OwAlfrescoVersion {
    private Properties versionProperties = new Properties();

    public OwAlfrescoVersion(InputStream versionPropertiesStream_p) throws IOException {
        this.versionProperties.load(versionPropertiesStream_p);
    }

    public OwAlfrescoVersion(File versionPropertiesFile_p) throws FileNotFoundException, IOException {
        this(new FileInputStream(versionPropertiesFile_p));
    }

    public String getMajorVersion() {
        return this.versionProperties.getProperty("version.major");
    }

    public String getMinorVersion() {
        return this.versionProperties.getProperty("version.minor");
    }

    public String getRevisionVersion() {
        return this.versionProperties.getProperty("version.revision");
    }

    public String getVersionLable() {
        return this.versionProperties.getProperty("version.label");
    }

    private boolean matchOne(String expectedVersion_p, String actualVersion_p) {
        return expectedVersion_p == null || expectedVersion_p.equals(actualVersion_p);
    }

    public boolean matchNonNull(String major_p, String minor_p, String revision_p, String label_p) {
        return this.matchOne(major_p, this.getMajorVersion()) && this.matchOne(minor_p, this.getMinorVersion()) && this.matchOne(revision_p, this.getRevisionVersion()) && this.matchOne(label_p, this.getVersionLable());
    }

    public String toString() {
        return this.getMajorVersion() + "." + this.getMinorVersion() + "." + this.getRevisionVersion() + this.getVersionLable();
    }
}

