/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Stack;

public class OwOAFileUtil {
    public static boolean delete(File location_p) throws IOException {
        Stack<File> fileStack = new Stack<File>();
        Stack<File> folderStack = new Stack<File>();
        fileStack.push(location_p);
        while (!fileStack.isEmpty()) {
            File stackedLocation = (File)fileStack.pop();
            if (!stackedLocation.exists()) continue;
            if (stackedLocation.isDirectory()) {
                File[] files = stackedLocation.listFiles();
                fileStack.addAll(Arrays.asList(files));
                folderStack.push(stackedLocation);
                continue;
            }
            if (stackedLocation.delete()) continue;
            return false;
        }
        while (!folderStack.isEmpty()) {
            File stackedFolder = (File)folderStack.pop();
            if (stackedFolder.delete()) continue;
            return false;
        }
        return true;
    }

    public static void copy(File source_p, File target_p) throws IOException {
        if (source_p.isDirectory()) {
            if (!target_p.exists()) {
                target_p.mkdir();
            }
            String[] children = source_p.list();
            for (int i = 0; i < children.length; ++i) {
                OwOAFileUtil.copy(new File(source_p, children[i]), new File(target_p, children[i]));
            }
        } else {
            int len;
            File targetParent;
            File target = target_p;
            if (target.isDirectory()) {
                target = new File(target, source_p.getName());
            }
            if (!(targetParent = target.getParentFile()).exists() && !targetParent.mkdirs()) {
                throw new IOException("Could not create folder " + targetParent.getAbsolutePath());
            }
            FileInputStream in = new FileInputStream(source_p);
            FileOutputStream out = new FileOutputStream(target);
            byte[] buf = new byte[4096];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }
}

