/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa;

import com.wewebu.ooa.OwActionObserver;
import com.wewebu.ooa.OwInstallAction;
import com.wewebu.ooa.OwOAAlreadyInstalledException;
import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.OwOAFileUtil;
import com.wewebu.ooa.OwOAIncompatibleAfrescoException;
import com.wewebu.ooa.OwOAInstallError;
import com.wewebu.ooa.OwOAText;
import com.wewebu.ooa.OwOpenAirAlfrescoLocator;
import com.wewebu.ooa.OwOpenAirInstall;
import com.wewebu.ooa.OwOpenAirInstaller;
import com.wewebu.ooa.OwOpenAirLogAdapter;
import com.wewebu.ooa.ace.OwOpenAirComunity32xInstaller;
import com.wewebu.ooa.ace.OwOpenAirComunity34xInstaller;
import com.wewebu.ooa.ace.OwOpenAirComunity40xInstaller;
import com.wewebu.ooa.ace.OwOpenAirComunity41xInstaller;
import com.wewebu.ooa.ace.OwOpenAirComunity42xInstaller;
import java.io.File;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class OwOpenAir
implements OwActionObserver {
    private static final Logger logger = Logger.getLogger("OwOpenAir");
    private static final String ALFRESCO_PATH_ARG_NAME = "-ap";
    private static final String ALFRESCO_CMIS_WS_PORT = "-cp";
    private static final String ALFRESCO_USER_ARG_NAME = "-u";
    private static final String ALFRESCO_PASSWORD_ARG_NAME = "-p";
    private static final String INSTALL_PATH_ARG_NAME = "-i";
    private static final OwOpenAirInstaller[] installers = new OwOpenAirInstaller[]{new OwOpenAirComunity32xInstaller(), new OwOpenAirComunity34xInstaller(), new OwOpenAirComunity40xInstaller(), new OwOpenAirComunity41xInstaller(), new OwOpenAirComunity42xInstaller()};
    private OwOpenAirLogAdapter logAdpter = new OwOpenAirLogAdapter(logger);

    public void install(File[] openAirDescriptorPaths_p, File alfrescoPath_p, String mainServiceURL_p, String cmisUser_p, String cmisPassword_p) throws Throwable {
        int i;
        OwOpenAirInstaller installer = null;
        OwOpenAirAlfrescoLocator locator = new OwOpenAirAlfrescoLocator(alfrescoPath_p, mainServiceURL_p, cmisUser_p, cmisPassword_p);
        for (i = 0; i < installers.length; ++i) {
            if (!installers[i].matchesAlfresco(locator)) continue;
            installer = installers[i];
            break;
        }
        if (installer == null) {
            throw new OwOAIncompatibleAfrescoException(alfrescoPath_p);
        }
        logger.info(OwOAText.text("starting", new String[0]) + " " + installer.getInstallerDescription());
        try {
            for (i = 0; i < openAirDescriptorPaths_p.length; ++i) {
                logger.info(OwOAText.text("processingFile", openAirDescriptorPaths_p[i].getAbsolutePath()));
                OwOpenAirInstall openAirInstall = new OwOpenAirInstall(openAirDescriptorPaths_p[i]);
                File installTrace = locator.findTraceFolder(openAirInstall.getDescriptor());
                if (installTrace.exists()) {
                    throw new OwOAAlreadyInstalledException(openAirInstall.getDescriptor(), alfrescoPath_p);
                }
                installTrace.mkdirs();
                OwOAFileUtil.copy(openAirInstall.getDescriptorXMLFile(), installTrace);
                List<OwInstallAction> actions = openAirInstall.createInstallActions(installer, locator);
                Stack<OwInstallAction> actionStack = new Stack<OwInstallAction>();
                for (OwInstallAction action : actions) {
                    File actionTrace = locator.findTraceFolder(action.getDescriptor());
                    PatternLayout traceLogLayout = new PatternLayout("%d{ISO8601} [%t] %-5p %c [%x] {%C{2}.%M} - %m%n");
                    FileAppender traceLogAppender = new FileAppender((Layout)traceLogLayout, new File(actionTrace, "workdesk_hr_installer.log").getAbsolutePath());
                    logger.addAppender(traceLogAppender);
                    try {
                        actionStack.push(action);
                        action.run(this, openAirInstall.getDataContext());
                    }
                    catch (Throwable t) {
                        traceLogAppender.close();
                        logger.removeAppender(traceLogAppender);
                        logger.fatal(OwOAText.text("actionFatalError", action.toString()), t);
                        while (!actionStack.isEmpty()) {
                            OwInstallAction stackedAction = (OwInstallAction)actionStack.pop();
                            stackedAction.undo(this, t);
                            File stackedActionTrace = locator.findTraceFolder(stackedAction.getDescriptor());
                            logger.fatal(OwOAText.text("deleting", stackedActionTrace.getAbsolutePath()));
                            if (OwOAFileUtil.delete(stackedActionTrace)) continue;
                            logger.fatal(OwOAText.text("errorOnDelete", stackedActionTrace.getAbsolutePath()));
                        }
                        if (!OwOAFileUtil.delete(installTrace)) {
                            logger.fatal(OwOAText.text("errorOnDelete", installTrace.getAbsolutePath()));
                        }
                        throw t;
                    }
                    finally {
                        traceLogAppender.close();
                        logger.removeAppender(traceLogAppender);
                    }
                }
            }
            logger.info(OwOAText.text("successfullyRan", new String[0]) + " " + installer.getInstallerDescription());
        }
        catch (OwOAException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwOAInstallError(e);
        }
    }

    private static void printUsage() {
        String osName = System.getProperty("os.name").toUpperCase();
        boolean win = osName.contains("WINDOWS");
        boolean lin = osName.contains("LINUX");
        boolean osx = osName.contains("OS X");
        String usage = null;
        String example = null;
        if (win) {
            usage = "\toa.bat -i <install_path> -ap <alfresco_path> -u <alfresco_user_name> -p <alfresco_password> [-cp <alfresco_cmis_ws_port>]";
            example = "\toa.bat -i D:\\Installs\\hr-install -ap C:\\Alfresco -u admin -p admin ";
        } else if (lin || osx) {
            usage = "\toa.bat -i <install_path> -ap <alfresco_path> -u <alfresco_user_name> -p <alfresco_password>  [-cp <alfresco_cmis_ws_port>]";
            example = "\tsudo oa.bat -i ~/install-samples/workdesk-hr -ap C:\\Alfresco -u admin -p admin ";
        } else {
            usage = example = "Not avaliable for this OS " + osName + ".";
        }
        System.out.println("Usage\t:");
        System.out.println(usage);
        System.out.println("Example\t:");
        System.out.println(example);
    }

    private static void exitWithUsage() {
        OwOpenAir.printUsage();
        System.exit(1);
    }

    public static void main(String[] args_p) throws Throwable {
        File alfrescoDir;
        String alferscoPath = null;
        String alfrescoUser = null;
        String alfrescoPassword = null;
        String installPath = null;
        String cmisWSPort = "8080";
        if (args_p.length >= 2) {
            try {
                for (int i = 0; i < args_p.length - 1; ++i) {
                    if (args_p[i].equals(ALFRESCO_PATH_ARG_NAME)) {
                        alferscoPath = args_p[i + 1];
                    }
                    if (args_p[i].equals(ALFRESCO_USER_ARG_NAME)) {
                        alfrescoUser = args_p[i + 1];
                    }
                    if (args_p[i].equals(ALFRESCO_PASSWORD_ARG_NAME)) {
                        alfrescoPassword = args_p[i + 1];
                    }
                    if (args_p[i].equals(INSTALL_PATH_ARG_NAME)) {
                        installPath = args_p[i + 1];
                    }
                    if (args_p[i].equals(ALFRESCO_CMIS_WS_PORT)) {
                        cmisWSPort = args_p[i + 1];
                    }
                    ++i;
                }
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println("Invalid arguments!");
                OwOpenAir.exitWithUsage();
            }
        }
        if (alferscoPath == null) {
            System.err.println("No Alfresco path argument found!");
            OwOpenAir.exitWithUsage();
        }
        if (installPath == null) {
            System.err.println("No install path argument found!");
            OwOpenAir.exitWithUsage();
        }
        if (alfrescoUser == null || alfrescoPassword == null) {
            System.err.println("No Alfresco credentials arguments found!");
            OwOpenAir.exitWithUsage();
        }
        if (!(alfrescoDir = new File(alferscoPath)).exists() || !alfrescoDir.isDirectory()) {
            System.err.println("Invalid Alfresco path " + alferscoPath);
            OwOpenAir.exitWithUsage();
        }
        String simpleServiceURL = "http://localhost:" + cmisWSPort + "/alfresco/cmis";
        OwOpenAir openAir = new OwOpenAir();
        openAir.install(new File[]{new File(installPath)}, alfrescoDir, simpleServiceURL, alfrescoUser, alfrescoPassword);
    }

    public void begin(OwInstallAction instanllAction_p) {
        logger.info(OwOAText.text("starting", new String[0]) + " " + instanllAction_p.toString());
    }

    public void log(String logMode_p, String message_p, Throwable throwable_p) {
        this.logAdpter.actionLog(logMode_p, message_p, throwable_p);
    }

    public void step(OwInstallAction instanllAction_p, int stepNumber_p, int stepCount_p) {
        logger.info("\t@ step " + stepNumber_p + "/" + stepCount_p);
    }

    public void end(OwInstallAction instanllAction_p) {
        logger.info(OwOAText.text("stopping", new String[0]) + " " + instanllAction_p.toString());
    }
}

