/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa;

import com.wewebu.ooa.OwInstallAction;
import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.OwOAInstallError;
import com.wewebu.ooa.OwOAText;
import com.wewebu.ooa.OwOpenAirAlfrescoLocator;
import com.wewebu.ooa.OwOpenAirInstaller;
import com.wewebu.ooa.data.OwData;
import com.wewebu.ooa.data.OwDataCollection;
import com.wewebu.ooa.data.OwDataContext;
import com.wewebu.ooa.data.OwDataDefinition;
import com.wewebu.ooa.data.OwDataSource;
import com.wewebu.ooa.data.OwExtension;
import com.wewebu.ooa.data.OwMerger;
import com.wewebu.ooa.databatch.OwAddJob;
import com.wewebu.ooa.databatch.OwBooleanValues;
import com.wewebu.ooa.databatch.OwCMISBaseType;
import com.wewebu.ooa.databatch.OwContentData;
import com.wewebu.ooa.databatch.OwDataBatch;
import com.wewebu.ooa.databatch.OwDateTimeValues;
import com.wewebu.ooa.databatch.OwDecimalValues;
import com.wewebu.ooa.databatch.OwIdValues;
import com.wewebu.ooa.databatch.OwIntegerValues;
import com.wewebu.ooa.databatch.OwObjectData;
import com.wewebu.ooa.databatch.OwPropertyData;
import com.wewebu.ooa.databatch.OwSetPropertiesJob;
import com.wewebu.ooa.databatch.OwStringValues;
import com.wewebu.ooa.databatch.OwValuesData;
import com.wewebu.ooa.descriptor.OwActionDescriptor;
import com.wewebu.ooa.descriptor.OwDataBatchDescriptor;
import com.wewebu.ooa.descriptor.OwImportContextDescriptor;
import com.wewebu.ooa.descriptor.OwOpenAirInstallDescriptor;
import com.wewebu.ooa.descriptor.OwStartAlfrescoDescriptor;
import com.wewebu.ooa.descriptor.OwStopAlfrescoDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwOpenAirInstall {
    private static final Logger logger = Logger.getLogger("OwOpenAirInstallDescriptor");
    private static final String OPENAIR_ELEMENT = "openair";
    private static final String IMPORT_CONTEXT_ELEMENT = "importContext";
    private static final String START_ALFRESCO_ELEMENT = "startAlfresco";
    private static final String STOP_ALFRESCO_ELEMENT = "stopAlfresco";
    private static final String DATA_BATCH_ELEMENT = "dataBatch";
    private static final String ADD_ELEMENT = "add";
    private static final String SET_ELEMENT = "set";
    private static final String DOCUMENT_ELEMENT = "document";
    private static final String FOLDER_ELEMENT = "folder";
    private static final String FIELD_ELEMENT = "field";
    private static final String KEY_ELEMENT = "key";
    private static final String VALUES_ELEMENT = "values";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String MERGER_ELEMENT = "merger";
    private static final String EXTENSION_ELEMENT = "extension";
    private static final String VALUE_ELEMENT = "value";
    private static final String RANGE_ELEMENT = "range";
    private static final String CONTENT_ELEMENT = "content";
    private static final String DATA_ELEMENT = "data";
    private static final String COLLECTION_ELEMENT = "collection";
    private static final String REPOSITORY_ATTRIBUTE = "repository";
    private static final String FOR_EACH_ATTRIBUTE = "forEach";
    private static final String PATH_ATTRIBUTE = "path";
    private static final String FILE_ATTRIBUTE = "file";
    private static final String DATA_ATTRIBUTE = "data";
    private static final String FORK_ATTRIBUTE = "fork";
    private static final String INDEX_ATTRIBUTE = "index";
    private static final String MIME_ATTRIBUTE = "mime";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String INITIAL_ATTRIBUTE = "initial";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ID_ATTRIBUTE = "id";
    private static final String COLLECTION_ATTRIBUTE = "collection";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String VALUES_ATTRIBUTE = "values";
    private static final String SEPARATOR_ATTRIBUTE = "separator";
    private static final String DESCRIPTOR_ATTRIBUTE = "descriptor";
    private static final String DEFAULT_DESCRIPTOR_FILE_NAME = ".descriptor.xml";
    private OwOpenAirInstallDescriptor installDescriptor;
    private OwDataContext dataContext;
    private File descriptorBaseLocation;

    private static FileInputStream getStream(File descriptorLocation_p) throws FileNotFoundException {
        File theFile = descriptorLocation_p;
        if (descriptorLocation_p.isDirectory()) {
            theFile = new File(descriptorLocation_p, DEFAULT_DESCRIPTOR_FILE_NAME);
        }
        return new FileInputStream(theFile);
    }

    private static File getBaseLocation(File descriptorLocation_p) throws FileNotFoundException {
        if (descriptorLocation_p.isDirectory()) {
            return descriptorLocation_p;
        }
        return descriptorLocation_p;
    }

    public OwOpenAirInstall(File descriptorLocation_p) throws ParserConfigurationException, SAXException, IOException {
        this(OwOpenAirInstall.getBaseLocation(descriptorLocation_p), OwOpenAirInstall.getStream(descriptorLocation_p));
    }

    public OwOpenAirInstall(File descriptorBaseLocation_p, InputStream xmlDescriptorStream_p) throws ParserConfigurationException, SAXException, IOException {
        this.descriptorBaseLocation = descriptorBaseLocation_p;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser p = factory.newSAXParser();
        p.parse(xmlDescriptorStream_p, (DefaultHandler)new OwInstallDescriptorXMLHanlder());
    }

    public OwOpenAirInstallDescriptor getDescriptor() {
        return this.installDescriptor;
    }

    public File getDescriptorXMLFile() {
        return new File(this.descriptorBaseLocation, DEFAULT_DESCRIPTOR_FILE_NAME);
    }

    public OwDataContext getDataContext() {
        return this.dataContext;
    }

    public List<OwInstallAction> createInstallActions(OwOpenAirInstaller installer_p, OwOpenAirAlfrescoLocator alfrescoLocator_p) throws Exception {
        LinkedList<OwInstallAction> actions = new LinkedList<OwInstallAction>();
        List<OwActionDescriptor> actionDescriptors = this.installDescriptor.getActionDescriptors();
        for (OwActionDescriptor descriptor : actionDescriptors) {
            OwInstallAction action = installer_p.createInstallAction(alfrescoLocator_p, descriptor);
            actions.add(action);
        }
        return actions;
    }

    private class OwInstallDescriptorXMLHanlder
    extends DefaultHandler {
        private Stack<OwDataBatch> dataBatchStack = new Stack();
        private List<OwObjectData> objects = null;
        private OwObjectData currentObjectData = null;
        private OwAddJob currentAddJob = null;
        private OwSetPropertiesJob currentSetPropertiesJob = null;
        private OwPropertyData currentPropertyData = null;
        private OwValuesData currentValuesData = null;
        private Stack<OwDataSource> sourceStack = null;
        private OwMerger merger = null;
        private Stack<OwDataDefinition> dataDefinitions = new Stack();

        private OwInstallDescriptorXMLHanlder() {
        }

        public void startDocument() throws SAXException {
            this.sourceStack = new Stack();
            OwDataCollection rootCollection = new OwDataCollection("[root]");
            this.sourceStack.push(rootCollection);
        }

        public void endDocument() throws SAXException {
            OwDataSource root = this.sourceStack.pop();
            OwOpenAirInstall.this.dataContext = root.defineContext(null);
        }

        public void startElement(String uri_p, String localName_p, String name_p, Attributes attributes_p) throws SAXException {
            String id;
            String type;
            String path;
            String repository;
            Object data;
            if (OwOpenAirInstall.OPENAIR_ELEMENT.equals(name_p)) {
                String descriptorName = attributes_p.getValue(OwOpenAirInstall.DESCRIPTOR_ATTRIBUTE);
                OwOpenAirInstall.this.installDescriptor = new OwOpenAirInstallDescriptor(descriptorName, OwOpenAirInstall.this.descriptorBaseLocation);
            }
            if (OwOpenAirInstall.IMPORT_CONTEXT_ELEMENT.equals(name_p)) {
                String contextName = attributes_p.getValue(OwOpenAirInstall.NAME_ATTRIBUTE);
                new OwImportContextDescriptor(OwOpenAirInstall.this.installDescriptor, contextName);
                logger.info(OwOAText.text("loadedAction", name_p, contextName));
            }
            if (OwOpenAirInstall.START_ALFRESCO_ELEMENT.equals(name_p)) {
                new OwStartAlfrescoDescriptor(OwOpenAirInstall.this.installDescriptor);
                logger.info(OwOAText.text("loadedAction", name_p, ""));
            }
            if (OwOpenAirInstall.STOP_ALFRESCO_ELEMENT.equals(name_p)) {
                new OwStopAlfrescoDescriptor(OwOpenAirInstall.this.installDescriptor);
                logger.info(OwOAText.text("loadedAction", name_p, ""));
            }
            if (OwOpenAirInstall.DATA_BATCH_ELEMENT.equals(name_p)) {
                String forEach = attributes_p.getValue(OwOpenAirInstall.FOR_EACH_ATTRIBUTE);
                data = attributes_p.getValue("data");
                String fork = attributes_p.getValue(OwOpenAirInstall.FORK_ATTRIBUTE);
                int forkInt = 1;
                if (fork != null) {
                    try {
                        forkInt = Integer.parseInt(fork);
                    }
                    catch (NumberFormatException e) {
                        logger.error(e);
                    }
                }
                OwDataBatch dataBatch = new OwDataBatch(forEach, (String)data, forkInt);
                this.dataBatchStack.push(dataBatch);
                logger.info(OwOAText.text("processingAction", name_p, ""));
            }
            if (OwOpenAirInstall.ADD_ELEMENT.equals(name_p)) {
                repository = attributes_p.getValue(OwOpenAirInstall.REPOSITORY_ATTRIBUTE);
                path = attributes_p.getValue(OwOpenAirInstall.PATH_ATTRIBUTE);
                this.currentAddJob = new OwAddJob(repository, path);
                this.objects = new LinkedList<OwObjectData>();
                logger.info(OwOAText.text("processing", name_p, "", "", ""));
            }
            if (OwOpenAirInstall.SET_ELEMENT.equals(name_p)) {
                repository = attributes_p.getValue(OwOpenAirInstall.REPOSITORY_ATTRIBUTE);
                this.currentSetPropertiesJob = new OwSetPropertiesJob(repository);
                this.objects = new LinkedList<OwObjectData>();
                logger.info(OwOAText.text("processing", name_p, "", "", ""));
            }
            if (OwOpenAirInstall.DOCUMENT_ELEMENT.equals(name_p) || OwOpenAirInstall.FOLDER_ELEMENT.equals(name_p)) {
                type = attributes_p.getValue(OwOpenAirInstall.TYPE_ATTRIBUTE);
                path = attributes_p.getValue(OwOpenAirInstall.PATH_ATTRIBUTE);
                this.currentObjectData = new OwObjectData(type, OwOpenAirInstall.DOCUMENT_ELEMENT.equals(name_p) ? OwCMISBaseType.DOCUMENT : OwCMISBaseType.FOLDER, path);
                logger.info(OwOAText.text("processing", name_p, "", "", ""));
            }
            if (OwOpenAirInstall.PROPERTY_ELEMENT.equals(name_p)) {
                String propertyName = attributes_p.getValue(OwOpenAirInstall.NAME_ATTRIBUTE);
                this.currentPropertyData = new OwPropertyData(propertyName);
                logger.info(OwOAText.text("processing", name_p, propertyName, "", ""));
            }
            if ("values".equals(name_p)) {
                type = attributes_p.getValue(OwOpenAirInstall.TYPE_ATTRIBUTE);
                try {
                    this.currentValuesData = this.createValues(type);
                }
                catch (OwOAInstallError e) {
                    logger.error(OwOAText.text("processing", "values", type, ""), e);
                }
            }
            if ("value".equals(name_p)) {
                String data2 = attributes_p.getValue("data");
                try {
                    this.currentValuesData.addStringValueData(data2);
                }
                catch (OwOAException e) {
                    logger.error(OwOAText.text("processing", "value", data2, ""), e);
                    this.currentValuesData = null;
                }
            }
            if (OwOpenAirInstall.CONTENT_ELEMENT.equals(name_p)) {
                String file = attributes_p.getValue(OwOpenAirInstall.FILE_ATTRIBUTE);
                String mime = attributes_p.getValue(OwOpenAirInstall.MIME_ATTRIBUTE);
                this.currentObjectData.setContent(new OwContentData(file, mime));
                logger.info(OwOAText.text("processing", OwOpenAirInstall.CONTENT_ELEMENT, file, mime, ""));
            }
            if ("data".equals(name_p)) {
                id = attributes_p.getValue(OwOpenAirInstall.ID_ATTRIBUTE);
                if (id == null) {
                    id = "#";
                }
                data = new OwData(id);
                this.dataDefinitions.push((OwDataDefinition)data);
                this.sourceStack.push((OwDataSource)data);
                logger.info(OwOAText.text("processing", "data", "", ""));
            }
            if (OwOpenAirInstall.FIELD_ELEMENT.equals(name_p)) {
                id = attributes_p.getValue(OwOpenAirInstall.ID_ATTRIBUTE);
                String value = attributes_p.getValue("value");
                this.dataDefinitions.peek().setField(id, value);
                logger.info(OwOAText.text("processing", OwOpenAirInstall.FIELD_ELEMENT, id, value));
            }
            if (OwOpenAirInstall.KEY_ELEMENT.equals(name_p)) {
                id = attributes_p.getValue(OwOpenAirInstall.ID_ATTRIBUTE);
                String initial = attributes_p.getValue(OwOpenAirInstall.INITIAL_ATTRIBUTE);
                int initialValue = 0;
                try {
                    initialValue = Integer.parseInt(initial);
                }
                catch (NumberFormatException e) {
                    logger.error(OwOAText.text("processing", OwOpenAirInstall.FIELD_ELEMENT, id, initial), e);
                }
                this.merger.addKey(id, initialValue);
                logger.info(OwOAText.text("processing", OwOpenAirInstall.KEY_ELEMENT, id, initial));
            }
            if ("collection".equals(name_p)) {
                id = attributes_p.getValue(OwOpenAirInstall.ID_ATTRIBUTE);
                OwDataCollection collection = new OwDataCollection(id);
                this.sourceStack.push(collection);
                logger.info(OwOAText.text("processing", "collection", id, "", ""));
            }
            if (OwOpenAirInstall.MERGER_ELEMENT.equals(name_p)) {
                this.merger = new OwMerger();
                this.sourceStack.push(this.merger);
                this.dataDefinitions.push(this.merger);
                logger.info(OwOAText.text("processing", OwOpenAirInstall.MERGER_ELEMENT, "", "", ""));
            }
            if (OwOpenAirInstall.EXTENSION_ELEMENT.equals(name_p)) {
                String collectionId = attributes_p.getValue("collection");
                String dataId = attributes_p.getValue("data");
                String indexId = attributes_p.getValue(OwOpenAirInstall.INDEX_ATTRIBUTE);
                this.dataDefinitions.push(new OwExtension(collectionId, dataId, indexId));
                this.sourceStack.peek().add(this.dataDefinitions.peek());
                logger.info(OwOAText.text("processing", OwOpenAirInstall.EXTENSION_ELEMENT, collectionId + "," + dataId + "," + indexId, ""));
            }
            if (OwOpenAirInstall.RANGE_ELEMENT.equals(name_p)) {
                id = attributes_p.getValue(OwOpenAirInstall.ID_ATTRIBUTE);
                String values = attributes_p.getValue("values");
                String separator = attributes_p.getValue(OwOpenAirInstall.SEPARATOR_ATTRIBUTE);
                this.merger.addRange(id, values, separator);
                logger.info(OwOAText.text("processing", OwOpenAirInstall.RANGE_ELEMENT, id, values, "\"" + separator + "\""));
            }
        }

        private OwValuesData createValues(String type_p) throws OwOAInstallError {
            if ("string".equals(type_p)) {
                return new OwStringValues();
            }
            if ("integer".equals(type_p)) {
                return new OwIntegerValues();
            }
            if ("decimal".equals(type_p)) {
                return new OwDecimalValues();
            }
            if ("boolean".equals(type_p)) {
                return new OwBooleanValues();
            }
            if ("datetime".equals(type_p)) {
                return new OwDateTimeValues();
            }
            if (OwOpenAirInstall.ID_ATTRIBUTE.equals(type_p)) {
                return new OwIdValues();
            }
            throw new OwOAInstallError("Invalid value type " + type_p);
        }

        public void endElement(String uri_p, String localName_p, String name_p) throws SAXException {
            OwDataSource contextSource;
            OwDataBatch currentDataBatch;
            if (OwOpenAirInstall.DATA_BATCH_ELEMENT.equals(name_p)) {
                OwDataBatch dataBatch = this.dataBatchStack.pop();
                if (this.dataBatchStack.isEmpty()) {
                    new OwDataBatchDescriptor(OwOpenAirInstall.this.installDescriptor, dataBatch);
                    logger.info(OwOAText.text("loadedAction", OwOpenAirInstall.DATA_BATCH_ELEMENT, ""));
                } else {
                    this.dataBatchStack.peek().add(dataBatch);
                    logger.warn(OwOAText.text("ignoredAction", name_p, ""));
                }
            }
            if (OwOpenAirInstall.ADD_ELEMENT.equals(name_p)) {
                this.currentAddJob.addObjects(this.objects);
                currentDataBatch = this.dataBatchStack.peek();
                currentDataBatch.add(this.currentAddJob);
                logger.info(OwOAText.text("processing", name_p, " job added to batch ", ""));
            }
            if (OwOpenAirInstall.SET_ELEMENT.equals(name_p)) {
                this.currentSetPropertiesJob.addObjects(this.objects);
                currentDataBatch = this.dataBatchStack.peek();
                currentDataBatch.add(this.currentSetPropertiesJob);
                logger.info(OwOAText.text("processing", name_p, " job added to batch ", ""));
            }
            if (OwOpenAirInstall.DOCUMENT_ELEMENT.equals(name_p) || OwOpenAirInstall.FOLDER_ELEMENT.equals(name_p)) {
                this.objects.add(this.currentObjectData);
                logger.info(OwOAText.text("processing", name_p, " added to job objects ", ""));
            }
            if (OwOpenAirInstall.PROPERTY_ELEMENT.equals(name_p)) {
                this.currentPropertyData.setValues(this.currentValuesData);
                this.currentObjectData.addProperty(this.currentPropertyData);
                logger.info(OwOAText.text("processing", name_p, " added to object ", ""));
            }
            if ("data".equals(name_p)) {
                this.sourceStack.pop();
                OwDataSource currentCollection = this.sourceStack.peek();
                OwDataDefinition data = this.dataDefinitions.pop();
                currentCollection.add(data);
                logger.info(OwOAText.text("processing", "data added to current source ", "", ""));
            }
            if ("collection".equals(name_p)) {
                OwDataSource collection = this.sourceStack.pop();
                contextSource = this.sourceStack.peek();
                contextSource.add(collection);
                logger.info(OwOAText.text("processing", "collection added to current source ", "", "", ""));
            }
            if (OwOpenAirInstall.MERGER_ELEMENT.equals(name_p)) {
                this.dataDefinitions.pop();
                OwDataSource merger = this.sourceStack.pop();
                contextSource = this.sourceStack.peek();
                this.merger = null;
                contextSource.add(merger);
                logger.info(OwOAText.text("processing", "merger added to current source", "", "", ""));
            }
        }
    }
}

