/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.ace;

import com.sun.org.apache.xpath.internal.XPathAPI;
import com.wewebu.ooa.OwActionObserver;
import com.wewebu.ooa.OwInstallActionBase;
import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.OwOAFileUtil;
import com.wewebu.ooa.OwOAInstallError;
import com.wewebu.ooa.OwOAText;
import com.wewebu.ooa.OwOpenAirAlfrescoLocator;
import com.wewebu.ooa.data.OwDataContext;
import com.wewebu.ooa.descriptor.OwActionDescriptor;
import com.wewebu.ooa.descriptor.OwImportContextDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public class OwImportContext3xAction
extends OwInstallActionBase {
    private static final String ALFRESCO_CLASSES_SUBPATH = "tomcat/webapps/alfresco/WEB-INF/classes/";
    private static final String ALFRESCO_CONFIG_CLASSES_SUBPATH = "tomcat/webapps/alfresco/WEB-INF/classes/alfresco/";
    private static final String APPLICATION_CONTEXT_XML = "application-context.xml";
    private static final String APPCONTEXT_XML_ALFRESCO_SUBPATH = "tomcat/webapps/alfresco/WEB-INF/classes/alfresco/application-context.xml";
    private static final String SHARED_PATH = "tomcat/shared/classes/";
    private static final String SHARED_EXTENSION_PATH = "tomcat/shared/classes/alfresco/extension/";
    private OwImportContextDescriptor importContextDescriptor;

    public OwImportContext3xAction(OwImportContextDescriptor importContextDescription_p, OwOpenAirAlfrescoLocator locator_p) {
        super(locator_p);
        this.importContextDescriptor = importContextDescription_p;
        this.locator = locator_p;
    }

    protected void createUniqueTrace(OwActionObserver observer_p) throws OwOAException {
        observer_p.step(this, 1, 2);
        File descriptorContextTrace = this.locator.findTraceFolder(this.importContextDescriptor);
        if (!descriptorContextTrace.exists() && !descriptorContextTrace.mkdirs()) {
            throw new OwOAInstallError("Failed to create trace folder : " + descriptorContextTrace.getAbsolutePath());
        }
    }

    protected void importContext(OwActionObserver observer_p) throws OwOAException {
        try {
            observer_p.step(this, 2, 3);
            File alfrescoDir = this.locator.getAlfrescoInstallDir();
            File descriptorContextTrace = this.locator.findTraceFolder(this.importContextDescriptor);
            File appContext = new File(alfrescoDir, APPCONTEXT_XML_ALFRESCO_SUBPATH);
            File appContextTrace = new File(descriptorContextTrace, APPLICATION_CONTEXT_XML);
            observer_p.log("info", OwOAText.text("tracing", appContext.getAbsolutePath(), descriptorContextTrace.getAbsolutePath()), null);
            OwOAFileUtil.copy(appContext, appContextTrace);
            observer_p.log("info", OwOAText.text("addingImportContext", appContext.getAbsolutePath()), null);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/namespaces", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/validation", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            Document appContextDocument = builder.parse(appContext);
            appContextDocument.normalize();
            Element beansElement = appContextDocument.getDocumentElement();
            beansElement.appendChild(appContextDocument.createComment("Workdesk OpenAir added context. Trace backup is located at " + descriptorContextTrace.getAbsolutePath()));
            Element importElement = (Element)beansElement.appendChild(appContextDocument.createElement("import"));
            importElement.setAttribute("resource", "classpath:alfresco/" + this.importContextDescriptor.getContextName());
            FileOutputStream fos = new FileOutputStream(appContext);
            OutputFormat outputFormat = new OutputFormat("XML", "UTF-8", true);
            outputFormat.setIndent(1);
            outputFormat.setIndenting(true);
            XMLSerializer serializer = new XMLSerializer((OutputStream)fos, outputFormat);
            serializer.asDOMSerializer();
            serializer.serialize(appContextDocument);
            fos.close();
        }
        catch (ParserConfigurationException e) {
            throw new OwOAInstallError(e);
        }
        catch (SAXException e) {
            throw new OwOAInstallError(e);
        }
        catch (IOException e) {
            throw new OwOAInstallError(e);
        }
    }

    protected void installContextFiles(OwActionObserver observer_p) throws OwOAException {
        try {
            Node modelNode;
            observer_p.step(this, 2, 2);
            File alfrescoDir = this.locator.getAlfrescoInstallDir();
            File contextFile = this.importContextDescriptor.getContextFile();
            File contextDestFile = new File(alfrescoDir, "tomcat/shared/classes/alfresco/extension//" + this.importContextDescriptor.getContextName());
            observer_p.log("info", "\tcopying context\t: " + contextFile + " -> " + contextDestFile.getAbsolutePath(), null);
            OwOAFileUtil.copy(contextFile, contextDestFile);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/namespaces", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/validation", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            Document contextDocument = builder.parse(contextFile);
            contextDocument.normalize();
            Element documentElement = contextDocument.getDocumentElement();
            NodeIterator modelsIterator = XPathAPI.selectNodeIterator(documentElement.getFirstChild(), "/beans/bean/property[@name=\"models\"]/list/value");
            while ((modelNode = modelsIterator.nextNode()) != null) {
                String modelXML = modelNode.getFirstChild().getNodeValue();
                if (modelXML == null || modelXML.length() <= 0) continue;
                modelXML = modelXML.trim();
                int lastPathSeparator = modelXML.lastIndexOf("/");
                String descriptorBaseModelXML = modelXML;
                if (lastPathSeparator >= 0 && lastPathSeparator < modelXML.length() - 1) {
                    descriptorBaseModelXML = modelXML.substring(lastPathSeparator + 1);
                }
                String fullModelPath = alfrescoDir + "/" + SHARED_PATH + "/" + modelXML;
                File installFile = new File(fullModelPath);
                File descriptorFile = this.importContextDescriptor.getDescriptorRelativeFile(descriptorBaseModelXML);
                observer_p.log("info", "\tcopying model\t: " + descriptorFile.getAbsolutePath() + " -> " + installFile.getAbsolutePath(), null);
                OwOAFileUtil.copy(descriptorFile, installFile);
            }
        }
        catch (ParserConfigurationException e) {
            throw new OwOAInstallError(e);
        }
        catch (SAXException e) {
            throw new OwOAInstallError(e);
        }
        catch (IOException e) {
            throw new OwOAInstallError(e);
        }
        catch (TransformerException e) {
            throw new OwOAInstallError(e);
        }
    }

    public void undo(OwActionObserver observer_p, Throwable t_p) throws OwOAException {
        observer_p.log("fatal", OwOAText.text("actionFatalError", new String[0]), t_p);
        File alfrescoDir = this.locator.getAlfrescoInstallDir();
        File descriptorContextTrace = this.locator.findTraceFolder(this.importContextDescriptor);
        File appContext = new File(alfrescoDir, APPCONTEXT_XML_ALFRESCO_SUBPATH);
        File appContextTrace = new File(descriptorContextTrace, APPLICATION_CONTEXT_XML);
        if (appContextTrace.exists()) {
            try {
                observer_p.log("info", OwOAText.text("untracing", appContextTrace.getAbsolutePath(), appContext.getAbsolutePath()), null);
                OwOAFileUtil.copy(appContextTrace, appContext);
            }
            catch (IOException e) {
                throw new OwOAInstallError(e);
            }
        }
    }

    public void runBare(OwActionObserver observer_p, OwDataContext context_p) throws OwOAException {
        File alfrescoDir = this.locator.getAlfrescoInstallDir();
        observer_p.log("info", "\t@" + alfrescoDir, null);
        this.createUniqueTrace(observer_p);
        this.installContextFiles(observer_p);
    }

    public OwActionDescriptor getDescriptor() {
        return this.importContextDescriptor;
    }

    public String toString() {
        File contextFile = this.importContextDescriptor.getContextFile();
        return "[Alfresco 3xx contex import for " + contextFile.getAbsolutePath() + "]";
    }
}

