/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.ace;

import com.wewebu.ooa.OwAlfrescoVersion;
import com.wewebu.ooa.OwInstallAction;
import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.OwOAUnsupportedOperationException;
import com.wewebu.ooa.OwOpenAirAlfrescoLocator;
import com.wewebu.ooa.OwOpenAirInstaller;
import com.wewebu.ooa.OwUninstallAction;
import com.wewebu.ooa.ace.OwDataBatch3xAction;
import com.wewebu.ooa.ace.OwImportContext3xAction;
import com.wewebu.ooa.descriptor.OwActionDescriptor;
import com.wewebu.ooa.descriptor.OwDataBatchDescriptor;
import com.wewebu.ooa.descriptor.OwImportContextDescriptor;
import com.wewebu.ooa.descriptor.OwStartAlfrescoDescriptor;
import com.wewebu.ooa.descriptor.OwStopAlfrescoDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public abstract class OwOpenAirComunity3xxInstaller
implements OwOpenAirInstaller {
    protected static final String WEBAPPS_RELATIVE_PATH = "/tomcat/webapps/";
    protected static final String ALFRESCO_WAR_RELATIVE_PATH = "/tomcat/webapps/alfresco.war";
    protected static final String ALFRESCO_WEBAPP_EXPLOSION_RELATIVE_PATH = "/tomcat/webapps/alfresco/";
    protected static final String VERSION_FILE_RELATIVE_PATH = "/tomcat/webapps/alfresco/WEB-INF/classes/alfresco/version.properties";

    protected abstract Logger getLogger();

    protected void explode(File warFile_p, File explodeLocation_p) throws OwOAException {
        try {
            ZipEntry entry;
            this.getLogger().info("Exploding " + warFile_p.getAbsolutePath() + " to " + explodeLocation_p.getAbsolutePath(), null);
            int bufferSize = 2048;
            FileInputStream fis = new FileInputStream(warFile_p);
            CheckedInputStream checksum = new CheckedInputStream(fis, new Adler32());
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(checksum));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                if (entry.isDirectory()) {
                    File outFile = new File(explodeLocation_p, entry.getName());
                    outFile.mkdirs();
                    continue;
                }
                byte[] data = new byte[2048];
                File outFile = new File(explodeLocation_p, entry.getName());
                File outParent = outFile.getParentFile();
                if (!outParent.exists()) {
                    outParent.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(outFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
            this.getLogger().info("\tchecksum " + checksum.getChecksum().getValue(), null);
        }
        catch (Exception e) {
            throw new OwOAException(e);
        }
    }

    protected boolean matchesAlfrescoVersion(OwOpenAirAlfrescoLocator alfrescoLocator_p, String major_p, String minor_p, String revision_p, String label_p) {
        return this.matchesAlfrescoVersion(alfrescoLocator_p, new String[][]{{major_p, minor_p, revision_p, label_p}});
    }

    protected boolean matchesAlfrescoVersion(OwOpenAirAlfrescoLocator alfrescoLocator_p, String[][] versions_p) {
        try {
            File versionFile;
            File explosionFolder = new File(alfrescoLocator_p.getAlfrescoInstallDir(), ALFRESCO_WEBAPP_EXPLOSION_RELATIVE_PATH);
            if (!explosionFolder.exists()) {
                File warFile = new File(alfrescoLocator_p.getAlfrescoInstallDir(), ALFRESCO_WAR_RELATIVE_PATH);
                if (warFile.exists()) {
                    this.explode(warFile, explosionFolder);
                } else {
                    return false;
                }
            }
            if ((versionFile = new File(alfrescoLocator_p.getAlfrescoInstallDir(), VERSION_FILE_RELATIVE_PATH)).exists()) {
                OwAlfrescoVersion alfrescoVersion = new OwAlfrescoVersion(versionFile);
                for (int i = 0; i < versions_p.length; ++i) {
                    if (!alfrescoVersion.matchNonNull(versions_p[i][0], versions_p[i][1], versions_p[i][2], versions_p[i][3])) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Throwable t) {
            if (!versions_p.equals("3")) {
                this.getLogger().error("Error matching the 3x installer", t);
            }
            if (!versions_p.equals("4")) {
                this.getLogger().error("Error matching the 4x installer", t);
            }
            return false;
        }
    }

    protected abstract OwInstallAction createAction(OwOpenAirAlfrescoLocator var1, OwStartAlfrescoDescriptor var2);

    protected abstract OwInstallAction createAction(OwOpenAirAlfrescoLocator var1, OwStopAlfrescoDescriptor var2);

    public OwInstallAction createInstallAction(OwOpenAirAlfrescoLocator alfrescoLocator_p, OwActionDescriptor actionDescription_p) throws Exception {
        if (actionDescription_p instanceof OwImportContextDescriptor) {
            OwImportContextDescriptor importContext = (OwImportContextDescriptor)actionDescription_p;
            return new OwImportContext3xAction(importContext, alfrescoLocator_p);
        }
        if (actionDescription_p instanceof OwStartAlfrescoDescriptor) {
            return this.createAction(alfrescoLocator_p, (OwStartAlfrescoDescriptor)actionDescription_p);
        }
        if (actionDescription_p instanceof OwStopAlfrescoDescriptor) {
            return this.createAction(alfrescoLocator_p, (OwStopAlfrescoDescriptor)actionDescription_p);
        }
        if (actionDescription_p instanceof OwDataBatchDescriptor) {
            return new OwDataBatch3xAction((OwDataBatchDescriptor)actionDescription_p, alfrescoLocator_p);
        }
        throw new IllegalArgumentException("Unsupported action " + actionDescription_p);
    }

    public OwUninstallAction createUninstallAction(OwOpenAirAlfrescoLocator alfrescoLocator_p, OwActionDescriptor actionDescription_p) throws OwOAException {
        throw new OwOAUnsupportedOperationException();
    }

    protected boolean isWindowsHostOS() {
        String osName = System.getProperty("os.name");
        return osName.toUpperCase().contains("WINDOWS");
    }

    protected boolean isLinuxHostOS() {
        String osName = System.getProperty("os.name");
        return osName.toUpperCase().contains("LINUX");
    }

    protected boolean isOsXHost() {
        String osName = System.getProperty("os.name");
        return osName.toUpperCase().contains("OS X");
    }
}

