/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.ace;

import com.wewebu.ooa.OwInstallAction;
import com.wewebu.ooa.OwOpenAirAlfrescoLocator;
import com.wewebu.ooa.ace.OwBatchScript;
import com.wewebu.ooa.ace.OwOpenAirComunity3xxInstaller;
import com.wewebu.ooa.ace.OwStartAlfresco3xAction;
import com.wewebu.ooa.ace.OwStopAlfresco3xAction;
import com.wewebu.ooa.descriptor.OwStartAlfrescoDescriptor;
import com.wewebu.ooa.descriptor.OwStopAlfrescoDescriptor;
import java.io.File;
import org.apache.log4j.Logger;

public class OwOpenAirComunity40xInstaller
extends OwOpenAirComunity3xxInstaller {
    private static final Logger logger = Logger.getLogger("OwOpenAirComunity40xInstaller");
    private static final String SERVICERUN_BAT = "servicerun.bat";
    private static final String SERVICERUN_BAT_PATH = "/servicerun.bat";
    private static final String ALFRESCO_SH = "alfresco.sh";
    private static final String ALFRESCO_SH_PATH = "/alfresco.sh";

    public String getInstallerDescription() {
        return "Workdesk Human Resources application installer @ Alfresco Community Edition 4.0.x";
    }

    public boolean matchesAlfresco(OwOpenAirAlfrescoLocator alfrescoLocator_p) {
        return this.matchesAlfrescoVersion(alfrescoLocator_p, "4", "0", null, null);
    }

    protected OwInstallAction createAction(OwOpenAirAlfrescoLocator alfrescoLocator_p, OwStartAlfrescoDescriptor startAlfrescoDescriptor_p) {
        OwBatchScript startScript = null;
        if (this.isWindowsHostOS()) {
            File alfrescoDir = alfrescoLocator_p.getAlfrescoInstallDir();
            String startScriptPath = alfrescoDir.getAbsolutePath() + SERVICERUN_BAT_PATH;
            startScript = new OwBatchScript(SERVICERUN_BAT, alfrescoDir, startScriptPath, "START");
        } else if (this.isLinuxHostOS()) {
            File alfrescoDir = alfrescoLocator_p.getAlfrescoInstallDir();
            String startScriptPath = alfrescoDir.getAbsolutePath() + ALFRESCO_SH_PATH;
            startScript = new OwBatchScript(ALFRESCO_SH, alfrescoDir, startScriptPath, "start");
        } else {
            throw new UnsupportedOperationException("Unsupported action for OS " + System.getProperty("os.name"));
        }
        return new OwStartAlfresco3xAction(startAlfrescoDescriptor_p, alfrescoLocator_p, startScript);
    }

    protected OwInstallAction createAction(OwOpenAirAlfrescoLocator alfrescoLocator_p, OwStopAlfrescoDescriptor stopAlfrescoDescriptor_p) {
        OwBatchScript stopScript = null;
        if (this.isWindowsHostOS()) {
            File alfrescoDir = alfrescoLocator_p.getAlfrescoInstallDir();
            String stopScriptPath = alfrescoDir.getAbsolutePath() + SERVICERUN_BAT_PATH;
            stopScript = new OwBatchScript(SERVICERUN_BAT, alfrescoDir, stopScriptPath, "STOP");
        } else if (this.isLinuxHostOS()) {
            File alfrescoDir = alfrescoLocator_p.getAlfrescoInstallDir();
            String stopScriptPath = alfrescoDir.getAbsolutePath() + ALFRESCO_SH_PATH;
            stopScript = new OwBatchScript(ALFRESCO_SH, alfrescoDir, stopScriptPath, "stop");
        } else {
            throw new UnsupportedOperationException("Unsupported action for OS " + System.getProperty("os.name"));
        }
        return new OwStopAlfresco3xAction(stopAlfrescoDescriptor_p, alfrescoLocator_p, stopScript);
    }

    protected Logger getLogger() {
        return null;
    }
}

