/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.cmis;

import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.cmis.OwCMISStaticProperty;
import java.util.LinkedList;
import java.util.List;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OwCMISPropertyNames {
    PATH("cmis:path", true),
    ALLOWED_CHILD_OBJECTTYPE_IDS("cmis:allowedChildObjectTypeIds", true),
    BASE_TYPE_ID("cmis:baseTypeId", true),
    IS_IMMUTABLE("cmis:isImmutable", true),
    CHECKIN_COMMENT("cmis:checkinComment", true),
    IS_VERSION_SERIES_CHECKED_OUT("cmis:isVersionSeriesCheckedOut", true),
    IS_LATEST_MAJOR_VERSION("cmis:isLatestMajorVersion", true),
    IS_MAJOR_VERSION("cmis:isMajorVersion", true),
    VERSION_SERIES_CHECKED_OUT_BY("cmis:versionSeriesCheckedOutBy", true),
    VERSION_SERIES_CHECKED_OUT_ID("cmis:versionSeriesCheckedOutId", true),
    IS_LATEST_VERSION("cmis:isLatestVersion", true),
    CHANGE_TOKEN("cmis:changeToken", true),
    VERSION_LABEL("cmis:versionLabel", true),
    CONTENT_STREAM_ID("cmis:contentStreamId", true),
    VERSION_SERIES_ID("cmis:versionSeriesId", true),
    OBJECT_ID("cmis:objectId"),
    NAME("cmis:name"),
    OBJECT_TYPE_ID("cmis:objectTypeId"),
    CONTENT_STREAM_MIME_TYPE("cmis:contentStreamMimeType"),
    CONTENT_STREAM_FILENAME("cmis:contentStreamFileName"),
    CONTENT_STREAM_LENGTH("cmis:contentStreamLength"),
    NONE("cmis:none");

    private static SyncList LST;
    private String cmisId;
    private boolean systemProperty;

    public static List<String> getSystemPropertiesCmisNames() {
        if (LST == null) {
            LST = SyncList.getInstance();
        }
        return LST.getList();
    }

    private OwCMISPropertyNames(String cmisName_p) {
        this(cmisName_p, false);
    }

    private OwCMISPropertyNames(String cmisName_p, boolean systemProperty_p) {
        this.cmisId = cmisName_p;
        this.systemProperty = systemProperty_p;
    }

    public boolean isSystemProperty() {
        return this.systemProperty;
    }

    public String getId() {
        return this.cmisId;
    }

    public CmisProperty fromObject(CmisObjectType cmisObject_p) {
        CmisPropertiesType properties = cmisObject_p.getProperties();
        List<CmisProperty> propertyList = properties.getProperty();
        return this.fromPropertyList(propertyList);
    }

    public CmisProperty fromPropertyList(List<CmisProperty> propertyList_p) {
        for (CmisProperty cmisProperty : propertyList_p) {
            if (!this.cmisId.equals(cmisProperty.getPropertyDefinitionId())) continue;
            return cmisProperty;
        }
        return null;
    }

    public String getIdValue(CmisObjectType cmisObject_p) throws OwOAException {
        CmisProperty property = this.fromObject(cmisObject_p);
        return OwCMISStaticProperty.getIdValue(property);
    }

    public Boolean getBooleanValue(CmisObjectType cmisObject_p) throws OwOAException {
        CmisProperty property = this.fromObject(cmisObject_p);
        return OwCMISStaticProperty.getBooleanValue(property);
    }

    public String getStringValue(CmisObjectType cmisObject_p) throws OwOAException {
        CmisProperty property = this.fromObject(cmisObject_p);
        return OwCMISStaticProperty.getStringValue(property);
    }

    public boolean isSameId(String id_p) {
        return this.cmisId.equals(id_p);
    }

    public boolean isSameId(CmisPropertyDefinitionType propertyDefinitionType_p) {
        return this.isSameId(propertyDefinitionType_p.getId());
    }

    static {
        LST = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SyncList {
        LinkedList<String> lst;
        private static SyncList singleton;

        private SyncList() {
            this.init();
        }

        public static synchronized SyncList getInstance() {
            if (singleton == null) {
                singleton = new SyncList();
            }
            return singleton;
        }

        protected synchronized void init() {
            if (this.lst == null) {
                this.lst = new LinkedList();
                OwCMISPropertyNames[] allProperties = OwCMISPropertyNames.values();
                for (int i = 0; i < allProperties.length; ++i) {
                    if (!allProperties[i].isSystemProperty()) continue;
                    this.lst.add(allProperties[i].getId());
                }
            }
        }

        protected List<String> getList() {
            return this.lst;
        }
    }
}

