/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.data;

import com.wewebu.ooa.data.OwData;
import com.wewebu.ooa.data.OwDataContext;
import com.wewebu.ooa.data.OwDataDefinition;
import com.wewebu.ooa.data.OwDataSource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwMerger
implements OwDataDefinition {
    private Map<String, String[]> rangeValues = new HashMap<String, String[]>();
    private List<OwMergerKey> keys = new LinkedList<OwMergerKey>();
    private List<OwDataSource> sources = new LinkedList<OwDataSource>();
    private Map<String, String> fields = new HashMap<String, String>();

    public void addRange(String fieldId_p, String values_p, String separator_p) {
        String[] values;
        if (values_p == null) {
            values = new String[]{};
        } else {
            if (separator_p == null) {
                separator_p = ",";
            }
            values = values_p.split(separator_p);
        }
        this.rangeValues.put(fieldId_p, values);
    }

    public void addKey(String keyId_p, int initialValue_p) {
        this.keys.add(new OwMergerKey(keyId_p, initialValue_p));
    }

    @Override
    public int getDataCount(OwDataContext context_p) {
        int count = 0;
        Set<Map.Entry<String, String[]>> propertyEntries = this.rangeValues.entrySet();
        for (Map.Entry<String, String[]> entry : propertyEntries) {
            String[] value = entry.getValue();
            if (value.length == 0) continue;
            if (count == 0) {
                count = value.length;
                continue;
            }
            count *= value.length;
        }
        return count;
    }

    @Override
    public Iterator<OwData> iterator(OwDataContext context_p) {
        return new Iterator<OwData>(){
            private Map<String, Integer> mergeIndexes;
            private Map<String, Integer> keyValues;
            private boolean hasNext = false;

            @Override
            public synchronized boolean hasNext() {
                if (this.mergeIndexes == null) {
                    this.mergeIndexes = new HashMap<String, Integer>();
                    Set rageIds = OwMerger.this.rangeValues.keySet();
                    for (String id : rageIds) {
                        this.mergeIndexes.put(id, 0);
                        if (((String[])OwMerger.this.rangeValues.get(id)).length <= 0) continue;
                        this.hasNext = true;
                    }
                    this.keyValues = new HashMap<String, Integer>();
                    for (OwMergerKey key : OwMerger.this.keys) {
                        this.keyValues.put(key.id, key.initialValue);
                    }
                }
                return this.hasNext;
            }

            @Override
            public synchronized OwData next() {
                if (this.hasNext()) {
                    HashMap<String, String> fields = new HashMap<String, String>();
                    Set ranges = OwMerger.this.rangeValues.entrySet();
                    boolean increment = true;
                    boolean lastObject = true;
                    for (Map.Entry range : ranges) {
                        String[] values = (String[])range.getValue();
                        if (values.length <= 0) continue;
                        int currnetIndex = this.mergeIndexes.get(range.getKey());
                        String value = values[currnetIndex];
                        fields.put((String)range.getKey(), value);
                        if (currnetIndex != values.length - 1) {
                            lastObject = false;
                        }
                        if (increment) {
                            ++currnetIndex;
                        }
                        if (currnetIndex == values.length) {
                            currnetIndex = 0;
                        } else {
                            increment = false;
                        }
                        this.mergeIndexes.put((String)range.getKey(), currnetIndex);
                    }
                    for (OwMergerKey key : OwMerger.this.keys) {
                        Integer index;
                        Integer n = index = this.keyValues.get(key.id);
                        Integer n2 = index = Integer.valueOf(index + 1);
                        fields.put(key.id, "" + index);
                        this.keyValues.put(key.id, index);
                    }
                    Set fieldsEntries = OwMerger.this.fields.entrySet();
                    for (Map.Entry entry : fieldsEntries) {
                        fields.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    this.hasNext = !lastObject;
                    OwData data = new OwData("#", fields);
                    data.addAll(OwMerger.this.sources);
                    return data;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public OwDataContext defineContext(OwDataContext parentContext_p) {
        return null;
    }

    @Override
    public void add(OwDataSource source_p) {
        this.sources.add(source_p);
    }

    @Override
    public void setField(String name_p, String value_p) {
        this.fields.put(name_p, value_p);
    }

    private class OwMergerKey {
        private final int initialValue;
        private final String id;

        public OwMergerKey(String id_p, int initialValue_p) {
            this.id = id_p;
            this.initialValue = initialValue_p;
        }
    }
}

