/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owaddmultidocuments;

import com.wewebu.ow.server.app.OwDocumentImportItem;
import com.wewebu.ow.server.app.OwDocumentImporter;
import com.wewebu.ow.server.app.OwDocumentImporterCallback;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.app.OwSubNavigationView;
import com.wewebu.ow.server.plug.owaddmultidocuments.OwAddMultiDocumentsDocument;
import com.wewebu.ow.server.plug.owaddmultidocuments.OwDocumentImportViewListener;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwLayout;
import com.wewebu.ow.server.ui.OwMultipanel;
import com.wewebu.ow.server.ui.OwSmallSubNavigationView;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class OwDocumentImportView
extends OwLayout
implements OwMultipanel,
OwDocumentImporterCallback {
    public static final int NAVIGATION_REGION = 0;
    public static final int MENU_REGION = 1;
    public static final int MAIN_REGION = 2;
    protected OwSubNavigationView m_subNavigationView;
    protected OwSubMenuView m_MenuView;
    protected OwView m_nextView;
    protected OwView m_prevView;
    private List m_documentImporters;
    protected int m_iNextButtonIndex;
    private OwDocumentImportViewListener m_eventListner = null;
    private LinkedList importerCallbackListener;

    public OwDocumentImportView(List documentImporters_p) {
        if (documentImporters_p == null) {
            throw new IllegalArgumentException("OwDocumentImportView must not be instantiated without List of document importers.");
        }
        this.m_documentImporters = documentImporters_p;
    }

    protected void init() throws Exception {
        super.init();
        this.importerCallbackListener = new LinkedList();
        this.m_subNavigationView = this.createNavigationView();
        this.addView((OwView)this.m_subNavigationView, 0, null);
        this.m_subNavigationView.setValidatePanels(true);
        this.addViewReference(this.m_subNavigationView.getViewReference(), 2);
        this.m_MenuView = new OwSubMenuView();
        this.addView((OwView)this.m_MenuView, 1, null);
        this.m_iNextButtonIndex = this.m_MenuView.addMenuItem((OwEventTarget)this, this.getContext().localize("plug.owaddmultidocuments.OwDocumentImportView.Next", "Next"), null, "Next", null, null);
        this.m_MenuView.enable(this.m_iNextButtonIndex, false);
        for (OwDocumentImporter docImporter : this.m_documentImporters) {
            OwView docImporterView = docImporter.getView(1, (OwDocumentImporterCallback)this);
            String docImporterTitle = docImporter.getDisplayName();
            String docImporterIcon = docImporter.getIconURL();
            this.m_subNavigationView.addView(docImporterView, docImporterTitle, null, docImporterIcon, null, null);
        }
        this.m_subNavigationView.navigate(0);
    }

    public void setEventListener(OwDocumentImportViewListener eventListner_p) {
        this.m_eventListner = eventListner_p;
    }

    protected OwSubNavigationView createNavigationView() {
        return new OwSmallSubNavigationView();
    }

    public void onNext(HttpServletRequest request_p, Object oReason_p) throws Exception {
        if (this.m_nextView != null) {
            this.m_nextView.activate();
        }
    }

    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("owaddmulti/OwDocumentImportView.jsp", w_p);
    }

    public void onDocumentImported(OwDocumentImporter importer_p, OwDocumentImportItem item_p) {
        this.notifyCallbackListener(importer_p, item_p);
        this.m_MenuView.enable(this.m_iNextButtonIndex, true);
        if (this.m_eventListner != null) {
            this.m_eventListner.onDocumentImported();
        }
    }

    public void setNextActivateView(OwView nextView_p) {
        this.m_nextView = nextView_p;
    }

    public void setPrevActivateView(OwView prevView_p) {
        this.m_prevView = prevView_p;
    }

    public boolean isValidated() {
        return this.getCurrentDocument().getImportedDocumentsCount() > 0;
    }

    protected OwAddMultiDocumentsDocument getCurrentDocument() {
        return (OwAddMultiDocumentsDocument)this.getDocument();
    }

    public void addDocumentImporterCallBackListener(OwDocumentImporterCallback listener_p) {
        this.importerCallbackListener.add(listener_p);
    }

    public void removeDocumentImporterCallBackListener(OwDocumentImporterCallback listener_p) {
        this.importerCallbackListener.remove(listener_p);
    }

    protected void notifyCallbackListener(OwDocumentImporter importer_p, OwDocumentImportItem item_p) {
        Iterator it = this.importerCallbackListener.iterator();
        while (it.hasNext()) {
            try {
                ((OwDocumentImporterCallback)it.next()).onDocumentImported(importer_p, item_p);
            }
            catch (Exception e) {}
        }
    }

    public OwDocumentImportItem getImportedDocument(int i_p) {
        return ((OwAddMultiDocumentsDocument)this.getDocument()).getImportedDocument(i_p);
    }

    public int getImportedDocumentsCount() {
        return ((OwAddMultiDocumentsDocument)this.getDocument()).getImportedDocumentsCount();
    }
}

