/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owaddobject;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwEcmUtil;
import com.wewebu.ow.server.app.OwJspFormConfigurator;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwRecordFunction;
import com.wewebu.ow.server.dmsdialogs.OwCreateObjectDialog;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectClassProcessor;
import com.wewebu.ow.server.dmsdialogs.views.classes.OwObjectClassSelectionCfg;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.plug.owutil.OwMappingUtils;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.alfresco.wd.ui.conf.OwPropertyListConfiguration;
import org.apache.log4j.Logger;

public class OwAddObjectRecordFunction
extends OwRecordFunction
implements OwDialog.OwDialogListener {
    private static final String ADD_RECORD_BIG_IMAGE = "/images/plug/owaddrecord/add_record_24.png";
    private static final String ADD_RECORD_IMAGE = "/images/plug/owaddrecord/add_record.png";
    private static final String ADD_RECORD_EXT_BIG_IMAGE = "/images/plug/owaddrecordwithid/add_record_with_id_24.png";
    private static final String ADD_RECORD_EXT_IMAGE = "/images/plug/owaddrecordwithid/add_record_with_id.png";
    private static final Logger LOG = OwLog.getLogger(OwAddObjectRecordFunction.class);
    protected OwObject m_rootObject;
    protected OwObject m_folderObject;
    protected String m_objectClass;
    protected OwJspFormConfigurator m_jspPageConfigurator;
    protected boolean isGeneratedIdsFeatureInUse;
    private OwObjectClassProcessor objectClassProcessor;
    private OwPropertyListConfiguration propertyListConfiguration;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        OwXMLUtil util;
        String strClazz;
        this.isGeneratedIdsFeatureInUse = node_p.getSubUtil("DialogHandler") != null;
        super.init(node_p, context_p);
        this.m_objectClass = node_p.getSafeTextValue("ObjectClass", null);
        OwXMLUtil handler = this.getConfigNode().getSubUtil("AspectsAssociations");
        if (handler != null && (strClazz = handler.getSafeStringAttributeValue("class", "com.wewebu.ow.server.plug.owaddmultidocuments.OwSecondaryTypesProcessor")) != null) {
            try {
                Class<?> procCls = Class.forName(strClazz);
                this.objectClassProcessor = (OwObjectClassProcessor)procCls.newInstance();
                this.objectClassProcessor.init(handler);
            }
            catch (ClassNotFoundException ex) {
                String msg = "Plugin initialization failed, Pluginid = " + this.getPluginID() + ". AspectsAssociations with class = " + strClazz + " not found, please check configuration.";
                LOG.error((Object)msg, (Throwable)ex);
                throw new OwConfigurationException(msg, (Throwable)ex);
            }
        }
        if ((util = this.getConfigNode().getSubUtil("EditPropertyList")) != null) {
            this.propertyListConfiguration = new OwPropertyListConfiguration(this.getPluginID());
            this.propertyListConfiguration.build(util);
        }
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", this.isGeneratedIdsFeatureInUse ? ADD_RECORD_EXT_IMAGE : ADD_RECORD_IMAGE);
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", this.isGeneratedIdsFeatureInUse ? ADD_RECORD_EXT_BIG_IMAGE : ADD_RECORD_BIG_IMAGE);
    }

    public boolean isEnabled(OwObject rootObject_p, OwObject folderObject_p, int iContext_p) throws Exception {
        if (null == this.getConfigNode().getSafeTextValue("ParentObject", null)) {
            if (super.isEnabled(rootObject_p, folderObject_p, iContext_p)) {
                return this.getContext().getNetwork().canCreateNewObject(folderObject_p.getResource(), folderObject_p, iContext_p);
            }
            return false;
        }
        return true;
    }

    public void onClickEvent(OwObject rootObject_p, OwObject folderObject_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(rootObject_p, folderObject_p, 2)) {
            LOG.error((Object)"OwAddObjectRecordFunction.onClickEvent(): Invalid Object - the functionality is disabled for this object.");
            throw new OwInvalidOperationException(this.getContext().localize("plug.owadddocument.OwAddObjectRecordFunction.invalidobject", "You cannot add an item."));
        }
        this.m_rootObject = rootObject_p;
        String fileParentDefinition = this.getConfigNode().getSafeTextValue("ParentObject", null);
        this.m_folderObject = fileParentDefinition != null ? OwEcmUtil.createObjectFromString((OwMainAppContext)this.getContext(), (String)fileParentDefinition) : folderObject_p;
        boolean fOpenObject = this.getConfigNode().getSafeBooleanValue("OpenObject", false);
        OwObjectClassSelectionCfg classSelectionCfg = OwObjectClassSelectionCfg.fromPluginXml((OwXMLUtil)this.getConfigNode());
        String defaultClassName = null;
        if (classSelectionCfg.hasDefaultClass()) {
            defaultClassName = classSelectionCfg.getDefaultClass().getName();
        }
        if (defaultClassName != null) {
            try {
                this.getContext().getNetwork().getObjectClass(defaultClassName, this.m_folderObject.getResource());
            }
            catch (OwObjectNotFoundException e) {
                throw new OwInvalidOperationException(this.getContext().localize("plug.owadddocument.OwAddObjectRecordFormularFunction.invalidobject", "You cannot add an item."), (Throwable)e);
            }
        }
        this.m_jspPageConfigurator = new OwJspFormConfigurator(this.getConfigNode());
        String strParentObjectClass = this.getConfigNode().getSafeTextValue("ObjectClassParent", null);
        String strClassName = this.getConfigNode().getSafeTextValue("ObjectClass", null);
        OwXMLUtil objectClassSelectionEl = this.getConfigNode().getSubUtil("ObjectClassSelection");
        OwCreateObjectDialog dlg = null;
        dlg = null == strClassName && null == strParentObjectClass && null != objectClassSelectionEl ? this.createCreateObjectDialog(this.m_folderObject, classSelectionCfg, fOpenObject) : this.createCreateObjectDialog(this.m_folderObject, strClassName, strParentObjectClass, fOpenObject);
        dlg.setConfigNode(this.getConfigNode());
        dlg.setJspConfigurator(this.m_jspPageConfigurator);
        dlg.setObjectClassProcessor(this.getObjectClassProcessor());
        dlg.setPropertyListConfiguration(this.getPropertyListConfiguration());
        dlg.setValues(this.getPredefinedValues(rootObject_p, folderObject_p));
        dlg.setHelp(this.getHelpPath());
        dlg.setInfoIcon(this.getBigIcon());
        dlg.setTitle(this.getDefaultLabel());
        dlg.setRefreshContext(refreshCtx_p);
        this.getContext().openDialog((OwDialog)dlg, null);
        this.addHistoryEvent(rootObject_p, this.m_folderObject, 3, 4);
    }

    protected OwCreateObjectDialog createCreateObjectDialog(OwObject folderObject_p, String strClassName_p, String strObjectClassParent_p, boolean fOpenObject_p) throws Exception {
        if (this.isGeneratedIdsFeatureInUse) {
            OwXMLUtil dialogHandler = this.getConfigNode().getSubUtil("DialogHandler");
            String dialogClassName = dialogHandler.getSafeStringAttributeValue("className", null);
            if (dialogClassName == null) {
                LOG.error((Object)"OwAddObjectRecordFunction.createCreateObjectDialog(): No className attribute configured for DialogHandler.");
                throw new OwConfigurationException(this.getContext().localize("plug.owadddocument.OwAddObjectRecordFunction.classNameNotFound", "No class Name attribute configured for DialogHandler."));
            }
            try {
                Class<?> dialogClass = Class.forName(dialogClassName);
                Constructor<?> constructor = dialogClass.getConstructor(OwObject.class, String.class, String.class, Boolean.TYPE);
                OwCreateObjectDialog createDialog = (OwCreateObjectDialog)constructor.newInstance(folderObject_p, strClassName_p, strObjectClassParent_p, fOpenObject_p);
                return createDialog;
            }
            catch (Exception e) {
                LOG.error((Object)"OwAddObjectRecordFunction.createCreateObjectDialog(): Cannot create dialog.", (Throwable)e);
                throw new OwConfigurationException(this.getContext().localize("plug.owadddocument.OwAddObjectRecordFunction.cannotCreateDialog", "Cannot create the ObjectCreateDialog instance."), (Throwable)e);
            }
        }
        OwCreateObjectDialog dialog = new OwCreateObjectDialog(folderObject_p, strClassName_p, strObjectClassParent_p, fOpenObject_p);
        return dialog;
    }

    protected OwCreateObjectDialog createCreateObjectDialog(OwObject folderObject_p, OwObjectClassSelectionCfg classSelectionCfg, boolean fOpenObject_p) throws Exception {
        if (this.isGeneratedIdsFeatureInUse) {
            OwXMLUtil dialogHandler = this.getConfigNode().getSubUtil("DialogHandler");
            String dialogClassName = dialogHandler.getSafeStringAttributeValue("className", null);
            if (dialogClassName == null) {
                LOG.error((Object)"OwAddObjectRecordFunction.createCreateObjectDialog(): No className attribute configured for DialogHandler.");
                throw new OwConfigurationException(this.getContext().localize("plug.owadddocument.OwAddObjectRecordFunction.classNameNotFound", "No class Name attribute configured for DialogHandler."));
            }
            try {
                Class<?> dialogClass = Class.forName(dialogClassName);
                Constructor<?> constructor = dialogClass.getConstructor(OwObject.class, OwObjectClassSelectionCfg.class, Boolean.TYPE);
                OwCreateObjectDialog createDialog = (OwCreateObjectDialog)constructor.newInstance(folderObject_p, classSelectionCfg, fOpenObject_p);
                return createDialog;
            }
            catch (Exception e) {
                LOG.error((Object)"OwAddObjectRecordFunction.createCreateObjectDialog(): Cannot create dialog.", (Throwable)e);
                throw new OwConfigurationException(this.getContext().localize("plug.owadddocument.OwAddObjectRecordFunction.cannotCreateDialog", "Cannot create the ObjectCreateDialog instance."), (Throwable)e);
            }
        }
        OwCreateObjectDialog dialog = new OwCreateObjectDialog(folderObject_p, classSelectionCfg, fOpenObject_p);
        return dialog;
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        int status = ((OwCreateObjectDialog)dialogView_p).getStatus();
        switch (status) {
            case 2: {
                this.addHistoryEvent(this.m_rootObject, this.m_folderObject, 3, 2);
                break;
            }
            case 1: {
                this.addHistoryEvent(this.m_rootObject, this.m_folderObject, 3, 1);
                break;
            }
            default: {
                this.addHistoryEvent(this.m_rootObject, this.m_folderObject, 3, 3);
            }
        }
        this.m_rootObject = null;
        this.m_folderObject = null;
    }

    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
    }

    protected Map getPredefinedValues(OwObject rootObject_p, OwObject folderObject_p) throws Exception {
        return OwMappingUtils.getParameterMapValuesFromRecord((OwXMLUtil)this.getConfigNode(), (OwObject)rootObject_p, (OwObject)folderObject_p);
    }

    protected OwObjectClassProcessor getObjectClassProcessor() {
        return this.objectClassProcessor;
    }

    protected OwPropertyListConfiguration getPropertyListConfiguration() {
        return this.propertyListConfiguration;
    }
}

