/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdocprops;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwClipboard;
import com.wewebu.ow.server.app.OwClipboardContentOwField;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.util.OwString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class OwBatchPropertyAssignmentDocumentFunction
extends OwDocumentFunction {
    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/OwObjectPropertyView/paste_metadata.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/OwObjectPropertyView/paste_metadata_24.png");
    }

    public void onClickEvent(OwObject object_p, OwObject parent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        this.addHistoryEvent(object_p, parent_p, 1, 1);
        if (!this.isEnabled(object_p, parent_p, 2)) {
            throw new OwInvalidOperationException(new OwString("owstd.OwBatchPropertyAssignmentDocumentFunction.invalidobject", "Cannot paste properties into the current object selection!"));
        }
        if (object_p != null) {
            List contentList;
            OwClipboard clipboard = this.getClipboard();
            if (this.isValidClipboardContentType() && (contentList = clipboard.getContent()) != null && contentList.size() > 0) {
                int noProp = 0;
                Collection propNames = this.getPropertyNameList(contentList);
                OwPropertyCollection propCol = object_p.getClonedProperties(propNames);
                Iterator it = contentList.iterator();
                while (it.hasNext()) {
                    OwField updateField = ((OwClipboardContentOwField)it.next()).getField();
                    String propName = updateField.getFieldDefinition().getClassName();
                    try {
                        OwProperty objProp = (OwProperty)propCol.get((Object)propName);
                        if (this.canSetValue(objProp)) {
                            objProp.setValue(updateField.getValue());
                            continue;
                        }
                        if (!this.isSystemProperty(objProp)) continue;
                        propCol.remove((Object)propName);
                    }
                    catch (OwObjectNotFoundException nfex) {
                        OwLog.getLogger(((Object)((Object)this)).getClass()).warn((Object)("OwBatchPropertyAssignmentDocumentFunction.onClickEvent property not found! Property-Name = " + propName));
                        ++noProp;
                    }
                }
                if (propCol != null && !propCol.isEmpty()) {
                    object_p.setProperties(propCol);
                }
                if (noProp == 0) {
                    this.setFinishMessage(OwString.localize((Locale)this.getContext().getLocale(), (String)"owstd.OwBatchPropertyAssignmentDocumentFunction.msg.succes", (String)"Data updated successfully"));
                    this.addHistoryEvent(object_p, parent_p, 3, 1);
                } else {
                    this.setFinishMessage(OwString.localize2((Locale)this.getContext().getLocale(), (String)"owstd.OwBatchPropertyAssignmentDocumentFunction.msg.fail", (String)"Update error, %1 of %2 properties were not updated", (String)(noProp + ""), (String)(propCol.size() + "")));
                    this.addHistoryEvent(object_p, parent_p, 3, 2);
                }
            }
        }
    }

    public void onMultiselectClickEvent(Collection objectCol_p, OwObject parent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        this.addHistoryEvent(objectCol_p, parent_p, 1, 1);
        if (objectCol_p != null && objectCol_p.size() > 0) {
            List content = this.getClipboard().getContent();
            if (this.isValidClipboardContentType() && content != null && content.size() > 0) {
                int failedUpdates = 0;
                LinkedList<OwObject> processedObjects = new LinkedList<OwObject>();
                LinkedList<OwObject> disabledObjects = new LinkedList<OwObject>();
                LinkedList<OwObject> failedObjects = new LinkedList<OwObject>();
                Collection propNames = this.getPropertyNameList(content);
                for (OwObject obj : objectCol_p) {
                    if (!this.isEnabled(obj, null, 0)) {
                        disabledObjects.add(obj);
                        continue;
                    }
                    try {
                        OwPropertyCollection propCol = obj.getClonedProperties(propNames);
                        Iterator itFields = content.iterator();
                        while (itFields.hasNext()) {
                            OwField updateField = ((OwClipboardContentOwField)itFields.next()).getField();
                            String propertyName = updateField.getFieldDefinition().getClassName();
                            OwProperty objProp = (OwProperty)propCol.get((Object)propertyName);
                            if (this.canSetValue(objProp)) {
                                objProp.setValue(updateField.getValue());
                                continue;
                            }
                            if (!this.isSystemProperty(objProp)) continue;
                            propCol.remove((Object)propertyName);
                        }
                        if (propCol == null || propCol.isEmpty()) continue;
                        obj.setProperties(propCol);
                        processedObjects.add(obj);
                    }
                    catch (OwObjectNotFoundException owEx) {
                        OwLog.getLogger(((Object)((Object)this)).getClass()).warn((Object)("OwBatchPropertyAssignmentDocumentFunction.onMultiselectClickEvent ObjectNotFound: " + owEx.getMessage()));
                        ++failedUpdates;
                        failedObjects.add(obj);
                    }
                }
                if (failedUpdates == 0) {
                    this.setFinishMessage(OwString.localize((Locale)this.getContext().getLocale(), (String)"owstd.OwBatchPropertyAssignmentDocumentFunction.list.msg.succes", (String)"Update finished successfully"));
                } else {
                    this.setFinishMessage(OwString.localize2((Locale)this.getContext().getLocale(), (String)"owstd.OwBatchPropertyAssignmentDocumentFunction.list.msg.fail", (String)"%1 of %2 objects could not be updated", (String)(failedUpdates + ""), (String)(objectCol_p.size() + "")));
                }
                if (!processedObjects.isEmpty()) {
                    this.addHistoryEvent(processedObjects, parent_p, 3, 1);
                }
                if (!failedObjects.isEmpty()) {
                    this.addHistoryEvent(failedObjects, parent_p, 3, 2);
                }
                if (!disabledObjects.isEmpty()) {
                    this.addHistoryEvent(disabledObjects, parent_p, 3, 5);
                }
            }
        }
    }

    public void setFinishMessage(String msg_p) {
        this.getContext().postMessage(msg_p);
    }

    protected OwClipboard getClipboard() {
        return this.getContext().getClipboard();
    }

    protected boolean isClipboardEmpty() {
        List lst = this.getClipboard().getContent();
        return lst == null || lst.isEmpty();
    }

    protected boolean isValidClipboardContentType() {
        return !this.isClipboardEmpty() && this.getClipboard().getContentType() == 3;
    }

    protected boolean isSystemProperty(OwProperty prop_p) throws Exception {
        return prop_p.getPropertyClass().isSystemProperty();
    }

    protected boolean canSetValue(OwProperty prop_p) throws Exception {
        OwPropertyClass propClass = prop_p.getPropertyClass();
        return !this.isSystemProperty(prop_p) && !propClass.isReadOnly(0);
    }

    private Collection getPropertyNameList(List clipboardContent_p) throws Exception {
        ArrayList<String> propNames = new ArrayList<String>();
        Iterator it = clipboardContent_p.iterator();
        while (it.hasNext()) {
            OwField updateField = ((OwClipboardContentOwField)it.next()).getField();
            propNames.add(updateField.getFieldDefinition().getClassName());
        }
        return propNames;
    }

    public boolean isEnabled(OwObject oObject_p, OwObject oParent_p, int iContext_p) throws Exception {
        return this.isValidClipboardContentType() && super.isEnabled(oObject_p, oParent_p, iContext_p);
    }

    public boolean isEnabled(Collection objCol_p, OwObject parent_p, int iContext_p) throws Exception {
        return this.isValidClipboardContentType() && super.isEnabled(objCol_p, parent_p, iContext_p);
    }
}

