/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdocprops;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectPropertyView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owdocprops.OwEditPropertiesDialogSimple;
import com.wewebu.ow.server.plug.owutil.OwConfigUtils;
import com.wewebu.ow.server.plug.owutil.OwObjectUtils;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.wd.ui.conf.OwPropertyListConfiguration;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwEditDocumentPropertiesSimple
extends OwDocumentFunction
implements OwDialog.OwDialogListener {
    private static final Logger LOG = OwLog.getLogger(OwEditDocumentPropertiesSimple.class);
    private static final String AUTO_LOCK_ELEMENT_NAME = "AutoLock";
    private boolean m_useAutoLock;
    private List m_propertyInfos;
    private OwPropertyListConfiguration propertyListConfiguration;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        super.init(node_p, context_p);
        this.m_useAutoLock = node_p.getSafeBooleanValue(AUTO_LOCK_ELEMENT_NAME, false);
        OwXMLUtil util = this.getConfigNode().getSubUtil("EditPropertyList");
        if (util != null) {
            OwPropertyListConfiguration propLstConf = new OwPropertyListConfiguration(this.getPluginID());
            propLstConf.build(util);
            this.setPropertyListConfiguration(propLstConf);
        }
    }

    public boolean isEnabled(OwObject object_p, OwObject parent_p, int context_p) throws Exception {
        boolean result = super.isEnabled(object_p, parent_p, context_p);
        if (result && this.m_useAutoLock && object_p.getLock(2)) {
            result = object_p.getMyLock(2);
        }
        return result;
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owdocprops/edit_properties_simple.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdocprops/edit_properties_simple_24.png");
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(oObject_p, oParent_p, 2)) {
            LOG.debug((Object)"OwEditDocumentPropertiesSimple.onClickEvent(): the edit function is not enabled for the given object !");
            throw new OwInvalidOperationException(new OwString("owdocprops.edit.properties.function.invalid.invalid.object", "Item can not be edited!"));
        }
        LinkedList<OwObject> objects = new LinkedList<OwObject>();
        objects.add(oObject_p);
        this.onMultiselectClickEvent(objects, oParent_p, refreshCtx_p);
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        LinkedList<OwObject> enabledObjects = new LinkedList<OwObject>();
        for (OwObject objectToEdit : objects_p) {
            if (!this.isEnabled(objectToEdit, oParent_p, 2)) continue;
            enabledObjects.add(objectToEdit);
        }
        if (enabledObjects.isEmpty()) {
            LOG.error((Object)"OwEditDocumentPropertiesSimple.onMultiselectClickEvent(): Invalid object collection!The enabled objects collection is empty!");
            throw new OwInvalidOperationException(new OwString("owdocprops.edit.properties.function.invalid.object.collection", "Invalid object collection!"));
        }
        LinkedList<OwObject> objects = enabledObjects;
        if (this.getConfigNode().getSafeBooleanValue("AlwaysUseLatestVersion", false)) {
            objects = OwObjectUtils.getLatesVersionObjects(enabledObjects);
        }
        OwEditPropertiesDialogSimple dlg = new OwEditPropertiesDialogSimple(objects, 0, oParent_p, this.getPropertyListConfiguration(), this.m_useAutoLock);
        int iViewMask = 0;
        iViewMask |= this.getConfigNode().getSafeBooleanValue("EnableMenu", true) ? 0 : 1;
        iViewMask |= this.getConfigNode().getSafeBooleanValue("AutoOpen", false) ? 4 : 0;
        iViewMask |= OwXMLDOMUtil.getSafeBooleanAttributeValue((Node)this.getConfigNode().getSubNode("AutoOpen"), (String)"previewmode", (boolean)false) ? 2 : 0;
        dlg.setViewMask(iViewMask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)this.getConfigNode(), (String)"EnablePasteMetadata", (int)128));
        OwXMLUtil previewConfiguration = this.getConfigNode().getSubUtil("Preview");
        dlg.setPreviewConfiguration(previewConfiguration);
        dlg.setHelp(this.getHelpPath());
        dlg.setTitle(this.getDefaultLabel());
        dlg.setInfoIcon(this.getBigIcon());
        this.getContext().openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
        this.addHistoryEvent(objects, oParent_p, 2, 1);
    }

    private void unlockItem(OwObject object_p) throws Exception {
        if (this.m_useAutoLock && object_p != null && object_p.getLock(2)) {
            object_p.setLock(false);
        }
    }

    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
        switch (code_p) {
            case 15: {
                if (!(caller_p instanceof OwObjectPropertyView)) break;
                OwObjectPropertyView realCaller = (OwObjectPropertyView)caller_p;
                LinkedList<OwObject> objectColection = new LinkedList<OwObject>();
                OwObject objectRef = realCaller.getObjectRef();
                if (objectRef == null) break;
                objectColection.add(objectRef);
                OwObjectCollection parents = objectRef.getParents();
                OwObject parent = parents != null && parents.size() > 0 ? (OwObject)parents.get(0) : null;
                this.addHistoryEvent(objectRef, parent, 3, 1);
            }
        }
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        if (dialogView_p instanceof OwEditPropertiesDialogSimple) {
            OwObject currentItem = ((OwEditPropertiesDialogSimple)dialogView_p).getItem();
            this.unlockItem(currentItem);
        }
    }

    public OwPropertyListConfiguration getPropertyListConfiguration() {
        return this.propertyListConfiguration;
    }

    public void setPropertyListConfiguration(OwPropertyListConfiguration propertyListConfiguration) {
        this.propertyListConfiguration = propertyListConfiguration;
    }
}

