/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdocprops;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwExpressionPriorityRule;
import com.wewebu.ow.server.plug.owdocprops.OwEditPropertiesModifiabilityHandler;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class OwExpressionModifiabilityHandler
implements OwEditPropertiesModifiabilityHandler {
    private static final Logger LOG = OwLog.getLogger(OwExpressionModifiabilityHandler.class);
    private OwExpressionPriorityRule expRule;

    @Override
    public void init(OwAppContext appContext, OwXMLUtil handlerConfigNode) throws OwException {
        List params = handlerConfigNode.getSafeUtilList(null);
        Iterator it = params.iterator();
        List cdata = null;
        while (it.hasNext()) {
            OwXMLUtil param = (OwXMLUtil)it.next();
            if (!"rule".equals(param.getSafeStringAttributeValue("name", null))) continue;
            cdata = param.getSafeCDATAList();
            break;
        }
        if (cdata == null || cdata.isEmpty()) {
            throw new OwConfigurationException(appContext.localize("OwExpressionModifiabilityHandler.init.err.conf", "Specify a rule using the paramEnc element."));
        }
        this.expRule = OwExpressionPriorityRule.newPriorityRule((String)"", (String)cdata.get(0).toString());
    }

    @Override
    public boolean isModifiable(int viewMask, OwObject item) {
        if (viewMask == 1) {
            try {
                return this.expRule.appliesTo(item);
            }
            catch (OwInvalidOperationException e) {
                LOG.warn((Object)"Could not process expression");
            }
        }
        return true;
    }
}

