/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdocprops;

import com.wewebu.ow.server.app.OwClipboard;
import com.wewebu.ow.server.app.OwClipboardContentOwField;
import com.wewebu.ow.server.app.OwClipboardContentOwObject;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMenuView;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.plug.owdocprops.OwEditMultiDocumentFieldsDialogSimple;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwLayout;
import com.wewebu.ow.server.ui.OwMultipanel;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class OwFieldsView
extends OwLayout
implements OwMultipanel,
OwFieldProvider {
    private static final String EVENT_KEY_PASTE_THIS_META_DATA = "PasteThisMetaData";
    public static final int MAIN_REGION = 1;
    public static final int MENU_REGION = 2;
    public static final int VIEW_MASK_RENDER_VERTICAL = 4;
    public static final int VIEW_MASK_ENABLE_PASTE_METADATA = 128;
    protected static final String QUERY_KEY_PROPNAME = "prop";
    protected int m_iViewMask;
    protected OwFieldManager m_theFieldManager;
    protected Map m_fields;
    private Map m_clonedfields;
    protected OwSubMenuView m_MenuView;
    protected int m_iAppyBtnIndex;

    public OwMenuView getMenu() {
        return this.m_MenuView;
    }

    public void detach() {
        super.detach();
        this.m_theFieldManager.detach();
    }

    public void setFields(Map fields_p) throws Exception {
        this.m_fields = fields_p;
        this.m_clonedfields = this.createCloneFromFields(fields_p);
    }

    protected Map createCloneFromFields(Map fields_p) throws Exception {
        HashMap<String, OwEditMultiDocumentFieldsDialogSimple.OwEditField> result = new HashMap<String, OwEditMultiDocumentFieldsDialogSimple.OwEditField>();
        Set keys = fields_p.keySet();
        for (String name : keys) {
            OwEditMultiDocumentFieldsDialogSimple.OwEditField value = (OwEditMultiDocumentFieldsDialogSimple.OwEditField)fields_p.get(name);
            OwEditMultiDocumentFieldsDialogSimple.OwEditField clonedValue = new OwEditMultiDocumentFieldsDialogSimple.OwEditField(value.getFieldDefinition(), value.getValue());
            result.put(name, clonedValue);
        }
        return result;
    }

    protected String usesFormWithAttributes() {
        return "";
    }

    protected void init() throws Exception {
        super.init();
        this.m_theFieldManager = ((OwMainAppContext)this.getContext()).createFieldManager();
        this.m_theFieldManager.setExternalFormTarget(this.getFormTarget());
        this.m_theFieldManager.setFieldProvider((OwFieldProvider)this);
        this.m_MenuView = new OwSubMenuView();
        this.addView((OwView)this.m_MenuView, 2, null);
        if (this.getMenu() != null) {
            this.m_iAppyBtnIndex = this.getMenu().addFormMenuItem((OwEventTarget)this, this.getContext().localize("plug.owdocprops.OwFieldView.save", "Save"), "Apply", null);
            this.getMenu().setDefaultMenuItem(this.m_iAppyBtnIndex);
        }
    }

    public boolean onApply(HttpServletRequest request_p, Object oReason_p) throws Exception {
        HashMap changedFields = new HashMap();
        if (this.m_theFieldManager.update(request_p, changedFields, this.m_clonedfields)) {
            if (this.saveFields(changedFields)) {
                this.succeed();
                return true;
            }
            this.failed();
        }
        return false;
    }

    protected void succeed() {
        ((OwMainAppContext)this.getContext()).postMessage(this.getContext().localize("plug.owdocprops.OwFieldView.saved", "The changes have been applied."));
    }

    protected void failed() {
    }

    protected abstract boolean saveFields(Map var1) throws Exception;

    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 1: {
                this.renderMainRegion(w_p);
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    protected boolean hasViewMask(int iViewMask_p) {
        return (this.m_iViewMask & iViewMask_p) > 0;
    }

    public void setViewMask(int iViewMask_p) {
        this.m_iViewMask = iViewMask_p;
    }

    protected boolean activatePasteMetadata() {
        if (!this.hasViewMask(128)) {
            return false;
        }
        OwClipboard clipboard = ((OwMainAppContext)this.getContext()).getClipboard();
        switch (clipboard.getContentType()) {
            case 1: {
                return clipboard.getContent().size() == 1;
            }
            case 3: {
                return clipboard.getContent().size() > 0;
            }
        }
        return false;
    }

    protected void renderExtraColumnHeader(Writer w_p) throws Exception {
        if (this.activatePasteMetadata()) {
            String pasteTooltip = this.getContext().localize("plug.owdocprops.OwFieldView.pasteallmeta", "Paste all metadata from the clipboard.");
            w_p.write("<th align=\"center\"><a title=\"" + pasteTooltip + "\" href=\"" + this.getEventURL("PasteAllMetaData", null) + "\">");
            w_p.write("<img hspace=\"5\" border=\"0\" src=\"" + this.getContext().getDesignURL() + "/images/OwObjectPropertyView/paste_metadata.png\"");
            w_p.write(" alt=\"");
            w_p.write(pasteTooltip);
            w_p.write("\" title=\"");
            w_p.write(pasteTooltip);
            w_p.write("\"/></a></th>");
        }
    }

    protected String getRowClassName(int iIndex_p, OwField prop_p) {
        return iIndex_p % 2 != 0 ? "OwObjectPropertyView_OddRow" : "OwObjectPropertyView_EvenRow";
    }

    protected void renderMainRegion(Writer w_p) throws Exception {
        this.m_theFieldManager.reset();
        if (this.m_fields == null || this.m_fields.size() == 0) {
            return;
        }
        if (this.hasViewMask(4)) {
            for (OwField field : this.m_fields.values()) {
                OwFieldDefinition fielddefinition = field.getFieldDefinition();
                w_p.write("<div class='OwPropertyName' style='clear: both;'>");
                w_p.write(fielddefinition.getDisplayName(this.getContext().getLocale()));
                w_p.write("</div>\n");
                w_p.write("<div>\n");
                w_p.write("<div class='OwPropertyControl'>");
                this.m_theFieldManager.insertEditField(w_p, field);
                w_p.write("</div>\n");
                w_p.write("<div class='OwPropertyError'>");
                w_p.write(this.m_theFieldManager.getSafeFieldError(field));
                w_p.write("</div>\n");
                w_p.write("<div class='OwPropertyError' id='HotInfo" + this.m_theFieldManager.getFieldJSErrorCtrlID(field) + "'></div>\n");
                w_p.write("<br><br>\n");
                w_p.write("</div>\n");
            }
        } else {
            w_p.write("<table class='OwObjectPropertyView_PropList'>\n");
            w_p.write("<thead>\n");
            w_p.write("<tr class='OwObjectPropertyView_Header'>\n");
            this.renderExtraColumnHeader(w_p);
            w_p.write("<th class='OwRequired'><img hspace='5' src='" + this.getContext().getDesignURL() + "/images/OwObjectPropertyView/notrequired.gif' alt='' title=''></th>");
            w_p.write("<th>" + this.getContext().localize("plug.owdocprops.OwFieldView.fieldcolumn", "Property") + "&nbsp;&nbsp;</th><th>" + this.getContext().localize("plug.owdocprops.OwFieldView.valuecolumn", "Value") + "&nbsp;&nbsp;</th>\n");
            w_p.write("</tr>\n");
            w_p.write("</thead>\n");
            w_p.write("<tbody>\n");
            Iterator it = this.m_fields.values().iterator();
            String strRowClassName = null;
            int iIndex = 0;
            while (it.hasNext()) {
                OwField field = (OwField)it.next();
                OwFieldDefinition fielddefinition = field.getFieldDefinition();
                strRowClassName = this.getRowClassName(iIndex, field);
                w_p.write("<tr class='" + strRowClassName + "'>\n");
                this.renderExtraColumnRows(w_p, field, iIndex);
                w_p.write("<td class=\"OwRequired\">");
                if (fielddefinition.isRequired()) {
                    String tooltip = this.getContext().localize("app.OwObjectPropertyView.required", "Required");
                    w_p.write("<img src='" + this.getContext().getDesignURL() + "/images/OwObjectPropertyView/required.png' alt='" + tooltip + "' title='" + tooltip + "'/>");
                } else {
                    w_p.write("<img src='" + this.getContext().getDesignURL() + "/images/OwObjectPropertyView/notrequired.gif' alt='' title=''/>");
                }
                w_p.write("</td>\n");
                w_p.write("<td nowrap class='OwPropertyName' title='" + fielddefinition.getClassName() + "'>");
                w_p.write(fielddefinition.getDisplayName(this.getContext().getLocale()) + ":&nbsp;&nbsp;");
                w_p.write("</td>\n<td class='DefaultInput'>\n");
                w_p.write("<div class='OwPropertyControl'>");
                this.m_theFieldManager.insertEditField(w_p, field);
                w_p.write("</div>\n");
                w_p.write("<div class='OwPropertyError'>");
                w_p.write(this.m_theFieldManager.getSafeFieldError(field));
                w_p.write("</div>\n");
                w_p.write("<div class='OwPropertyError' id='HotInfo_" + this.m_theFieldManager.getFieldJSErrorCtrlID(field) + "'></div>\n");
                w_p.write("</td>\n");
                w_p.write("</tr>\n");
                ++iIndex;
            }
            w_p.write("</tbody>\n");
            w_p.write("</table>\n");
        }
    }

    protected void onRender(Writer w_p) throws Exception {
        w_p.write(this.m_theFieldManager.renderErrors());
        w_p.write("<div style=\"clear:both\" class=\"OwObjectPropertyView\">");
        w_p.write("<table class='OwObjectPropertyView'>");
        w_p.write("<tr><td>");
        this.renderRegion(w_p, 1);
        w_p.write("</td></tr>");
        w_p.write("<tr><td class='OwObjectPropertyView_MENU OwInlineMenu'>");
        this.renderRegion(w_p, 2);
        w_p.write("</td></tr>");
        w_p.write("</table>");
        w_p.write("</div>");
    }

    private boolean isfieldPasteable(OwField prop_p, OwObject clipboardObject_p) throws Exception {
        try {
            OwProperty clipboardfield = clipboardObject_p.getProperty(prop_p.getFieldDefinition().getClassName());
            return clipboardfield.getFieldDefinition().getJavaClassName().equals(prop_p.getFieldDefinition().getJavaClassName()) && clipboardfield.getValue() != null;
        }
        catch (OwObjectNotFoundException e) {
            return false;
        }
    }

    public void onPasteThisMetaData(HttpServletRequest request_p) throws Exception {
        OwClipboard clipboard = this.getClipboard();
        String strfieldName = request_p.getParameter(QUERY_KEY_PROPNAME);
        OwField prop = (OwField)this.m_fields.get(strfieldName);
        switch (clipboard.getContentType()) {
            case 1: {
                this.pasteMetaDataFromClipboardObject(prop);
                break;
            }
            case 3: {
                this.pasteMetaDataFromClipboardField(prop);
                break;
            }
        }
    }

    public void onPasteAllMetaData(HttpServletRequest request_p) throws Exception {
        OwClipboard clipboard = this.getClipboard();
        switch (clipboard.getContentType()) {
            case 1: {
                for (OwField prop : this.m_fields.values()) {
                    this.pasteMetaDataFromClipboardObject(prop);
                }
                break;
            }
            case 3: {
                for (OwField prop : this.m_fields.values()) {
                    this.pasteMetaDataFromClipboardField(prop);
                }
                break;
            }
        }
    }

    protected OwClipboard getClipboard() {
        return ((OwMainAppContext)this.getContext()).getClipboard();
    }

    private void pasteMetaDataFromClipboardObject(OwField prop_p) throws Exception {
        if (prop_p != null) {
            OwClipboard clipboard = this.getClipboard();
            OwObject clipboardObject = ((OwClipboardContentOwObject)clipboard.getContent().get(0)).getObject();
            try {
                OwProperty clipboardfield = clipboardObject.getProperty(prop_p.getFieldDefinition().getClassName());
                if (this.isfieldPasteable(prop_p, clipboardObject)) {
                    prop_p.setValue(clipboardfield.getValue());
                }
            }
            catch (OwObjectNotFoundException e) {
                // empty catch block
            }
        }
    }

    private void pasteMetaDataFromClipboardField(OwField prop_p) throws Exception {
        OwClipboard clipboard = this.getClipboard();
        if (clipboard != null && !clipboard.getContent().isEmpty()) {
            Iterator it = clipboard.getContent().iterator();
            while (it.hasNext()) {
                OwField field = ((OwClipboardContentOwField)it.next()).getField();
                if (!field.getFieldDefinition().getClassName().equals(prop_p.getFieldDefinition().getClassName())) continue;
                prop_p.setValue(field.getValue());
                break;
            }
        }
    }

    protected void renderExtraColumnRows(Writer w_p, OwField field_p, int iIndex_p) throws Exception {
        if (this.activatePasteMetadata()) {
            String pasteTooltip;
            OwObject clipboardObject;
            OwClipboard clipboard = ((OwMainAppContext)this.getContext()).getClipboard();
            w_p.write("\n<td align='center'>");
            if (clipboard.getContentType() == 1 && this.isfieldPasteable(field_p, clipboardObject = ((OwClipboardContentOwObject)clipboard.getContent().get(0)).getObject())) {
                try {
                    String pasteMetadataTooltip = this.getContext().localize("app.OwFieldView.pastethismeta", "Paste property from clipboard.");
                    w_p.write("<a title=\"" + pasteMetadataTooltip + "\" href=\"" + this.getFormEventURL(EVENT_KEY_PASTE_THIS_META_DATA, "prop=" + field_p.getFieldDefinition().getClassName()) + "\">");
                    w_p.write("<img hspace=\"5\" border=\"0\" src=\"" + this.getContext().getDesignURL() + "/images/OwObjectPropertyView/paste_metadata.png\"");
                    w_p.write(" alt=\"");
                    pasteTooltip = this.getContext().localize1("app.OwFieldView.pastethismetaforfield", "Paste property from clipboard for field %1.", field_p.getFieldDefinition().getDisplayName(this.getContext().getLocale()));
                    w_p.write(pasteTooltip);
                    w_p.write("\" title=\"");
                    w_p.write(pasteTooltip);
                    w_p.write("\"/></a>");
                }
                catch (OwObjectNotFoundException e) {
                    // empty catch block
                }
            }
            if (clipboard.getContentType() == 3) {
                Iterator it = clipboard.getContent().iterator();
                while (it.hasNext()) {
                    OwField field = ((OwClipboardContentOwField)it.next()).getField();
                    if (!field.getFieldDefinition().getClassName().equals(field_p.getFieldDefinition().getClassName())) continue;
                    w_p.write("<a title=\"" + this.getContext().localize("app.OwFieldView.pastethismeta", "Paste property from clipboard."));
                    w_p.write("\" href=\"");
                    w_p.write(this.getFormEventURL(EVENT_KEY_PASTE_THIS_META_DATA, "prop=" + field_p.getFieldDefinition().getClassName()));
                    w_p.write("\"><img hspace=\"5\" border=\"0\" src=\"");
                    w_p.write(this.getContext().getDesignURL());
                    w_p.write("/images/OwObjectPropertyView/paste_metadata.png\")");
                    pasteTooltip = this.getContext().localize1("app.OwFieldView.pastethismetaforfield", "Paste property from clipboard for field %1.", field_p.getFieldDefinition().getDisplayName(this.getContext().getLocale()));
                    w_p.write(" alt=\"");
                    w_p.write(pasteTooltip);
                    w_p.write("\" title=\"");
                    w_p.write(pasteTooltip);
                    w_p.write("\"/></a>");
                    break;
                }
            }
            w_p.write("</td>");
        }
    }

    public boolean isValidated() throws Exception {
        return false;
    }

    public void setNextActivateView(OwView nextView_p) throws Exception {
    }

    public void setPrevActivateView(OwView prevView_p) throws Exception {
    }

    public OwField getField(String name_p) throws Exception, OwObjectNotFoundException {
        OwField field = (OwField)this.m_fields.get(name_p);
        if (null == field) {
            throw new OwObjectNotFoundException("OwFieldsView.getField: " + name_p);
        }
        return field;
    }

    public String getFieldProviderName() {
        return "OwFieldsView";
    }

    public Object getFieldProviderSource() {
        return this;
    }

    public int getFieldProviderType() {
        return 1;
    }

    public Collection getFields() throws Exception {
        return this.m_fields.values();
    }

    public Object getSafeFieldValue(String name_p, Object defaultvalue_p) {
        OwField field = (OwField)this.m_fields.get(name_p);
        if (null == field) {
            return defaultvalue_p;
        }
        try {
            return field.getValue();
        }
        catch (Exception e) {
            return defaultvalue_p;
        }
    }

    public void setField(String name_p, Object value_p) throws Exception, OwObjectNotFoundException {
        OwField field = (OwField)this.m_fields.get(name_p);
        field.setValue(value_p);
    }

    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        OwStandardPropertyCollection changedProperties = new OwStandardPropertyCollection();
        return this.m_theFieldManager.update(request_p, (Map)changedProperties, this.m_clonedfields);
    }
}

