/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdocprops;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.plug.owdocprops.iconrule.OwStatusIconExpressionRule;
import com.wewebu.ow.server.plug.owdocprops.iconrule.OwStatusIconRule;
import com.wewebu.ow.server.plug.owdocprops.iconrule.OwStatusIconSimpleRule;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class OwStatusIconDocumentFunction
extends OwDocumentFunction {
    private List<OwStatusIconRule> m_rules;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        super.init(node_p, context_p);
        this.m_rules = new LinkedList<OwStatusIconRule>();
        for (OwXMLUtil n : node_p.getSubUtil("IconRules").getSafeUtilList(null)) {
            OwStatusIconRule rule = this.createStatusIconRule(n, (OwAppContext)context_p);
            this.m_rules.add(rule);
        }
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owstatus/hasminorversions.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owstatus/hasminorversions_24.png");
    }

    public boolean getObjectInstance() {
        return true;
    }

    public boolean getContextMenu() {
        return false;
    }

    public boolean getMultiselect() {
        return false;
    }

    public boolean getNoEvent() {
        return true;
    }

    public String getIconHTML(OwObject oObject_p, OwObject oParent_p) throws Exception {
        this.addHistoryEvent(oObject_p, oParent_p, 1, 1);
        for (OwStatusIconRule rule : this.m_rules) {
            if (!rule.canApply(oObject_p, oParent_p)) continue;
            StringBuilder result = new StringBuilder("<img class=\"OwFunctionIcon\" ");
            if (rule.getDescription() != null) {
                String tooltip = this.getDisplayName(this.getContext().getLocale(), rule.getDescription());
                result.append("alt=\"");
                result.append(tooltip);
                result.append("\" title=\"");
                result.append(tooltip);
                result.append("\" ");
            }
            result.append("src=\"");
            result.append(this.getContext().getDesignURL());
            result.append(rule.getIcon());
            result.append("\" />");
            return result.toString();
        }
        return "";
    }

    public String getDisplayName(Locale locale_p, String description) {
        return OwString.localizeLabel((Locale)locale_p, (String)description);
    }

    public void onClickEvent(OwObject object_p, OwObject parent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
    }

    protected List<OwStatusIconRule> getRules() {
        return this.m_rules;
    }

    protected OwStatusIconRule createStatusIconRule(OwXMLUtil config, OwAppContext context) throws OwException {
        String nodeName = config.getNode().getNodeName();
        if ("rule".equals(nodeName)) {
            return new OwStatusIconSimpleRule(config, context);
        }
        if ("xrule".equals(nodeName)) {
            return new OwStatusIconExpressionRule(config, context);
        }
        throw new OwConfigurationException(context.localize1("OwStatusIconDcoumentFunction.createStatusIconRule.invalidDef", "Unsupported definition %1 found in IconRules configuration.", nodeName));
    }
}

