/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdocprops.iconrule;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.plug.owdocprops.iconrule.OwStatusIconAbstractRule;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwXMLUtil;
import org.apache.log4j.Logger;

public class OwStatusIconSimpleRule
extends OwStatusIconAbstractRule {
    public static final Logger LOG = OwLog.getLogger(OwStatusIconSimpleRule.class);
    String m_property;
    String m_value;

    public OwStatusIconSimpleRule(OwXMLUtil definitionNode, OwAppContext context) throws OwException {
        super(definitionNode, context);
        String rule = definitionNode.getSafeTextValue(null);
        if (rule == null) {
            throw new OwConfigurationException("Please specify a rule.");
        }
        int iEqual = rule.indexOf("=");
        if (-1 == iEqual) {
            throw new OwConfigurationException("Please specify a '=' in the rule.");
        }
        this.m_property = rule.substring(0, iEqual);
        this.m_property = this.m_property.trim();
        if (this.getDescription() == null) {
            this.setDescription(this.m_property);
        }
        this.m_value = rule.substring(iEqual + 1);
        this.m_value = this.m_value.trim();
        if (this.m_value.equals("OW_NULL")) {
            this.m_value = null;
        }
    }

    @Override
    public boolean canApply(OwObject obj, OwObject parentObj) throws OwException {
        try {
            OwProperty prop = obj.getProperty(this.m_property);
            Object value = prop.getValue();
            if (value == null) {
                return this.m_value == null;
            }
            if (this.m_value != null) {
                return value.toString().equals(this.m_value);
            }
            return false;
        }
        catch (OwObjectNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            throw new OwServerException("Unlable to retrieve property value", (Throwable)e);
        }
    }
}

