/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owshortcut;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.app.OwRecordFunction;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutDocument;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwRecordFunctionShortcut
extends OwRecordFunction {
    private static final Logger LOG = OwLog.getLogger(OwRecordFunctionShortcut.class);
    public static final int INSERT_MODE_REFERENCE = 0;
    public static final int INSERT_MODE_PHYSICALCOPY = 1;
    private OwShortCutDocument m_favoritePlugin = null;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        super.init(node_p, context_p);
        this.m_favoritePlugin = (OwShortCutDocument)this.getFavoriteMasterPlugin();
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owdocshortcut/bookmark_add.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdocshortcut/bookmark_add_24.png");
    }

    public boolean isEnabled(OwObject rootObject_p, OwObject folderObject_p, int iContext_p) throws Exception {
        if (null == this.m_favoritePlugin || folderObject_p == null || folderObject_p.getType() != 8193) {
            return false;
        }
        return super.isEnabled(rootObject_p, folderObject_p, iContext_p);
    }

    public void onClickEvent(OwObject rootObject_p, OwObject folderObject_p, String subpath_p, String subdisplaypath_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(rootObject_p, folderObject_p, 2)) {
            this.addHistoryEvent(rootObject_p, folderObject_p, 1, 2);
            throw new OwInvalidOperationException(new OwString("plug.owdoccopy.OwRecordFunctionPaste.invalidobject", "Item cannot be pasted."));
        }
        this.m_favoritePlugin.addOwObjectShortCut(rootObject_p, subpath_p, subdisplaypath_p);
        if (null != refreshCtx_p) {
            refreshCtx_p.onClientRefreshContextUpdate(4, null);
        }
        this.getContext().postMessage(this.getContext().localize("plug.owshortcut.OwShortCutDocumentFunction.addedfavourite", "The selected object has been added to the favorites."));
        this.addHistoryEvent(rootObject_p, folderObject_p, 1, 1);
    }

    public OwMasterDocument getFavoriteMasterPlugin() throws OwConfigurationException {
        OwMasterDocument masterPlugin = null;
        String sEventTargetID = null;
        try {
            Node useMasterPluginNode = this.getConfigNode().getSubNode("UsedMasterPluginID");
            if (null != useMasterPluginNode) {
                sEventTargetID = useMasterPluginNode.getFirstChild().getNodeValue() + ".Doc";
                masterPlugin = (OwMasterDocument)this.getContext().getEventTarget(sEventTargetID);
            } else if (null == masterPlugin) {
                masterPlugin = this.searchMasterPluginFromClassName();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("OwRecordFunctionShortcut.getFavoriteMasterPlugin(): Cannot find the event target for ID: " + sEventTargetID), (Throwable)e);
        }
        return masterPlugin;
    }

    private OwMasterDocument searchMasterPluginFromClassName() {
        List allowedMaster = this.getContext().getConfiguration().getMasterPlugins(true);
        OwMasterDocument ret = null;
        if (allowedMaster != null) {
            for (OwConfiguration.OwMasterPluginInstance inst : allowedMaster) {
                if (!(inst.getDocument() instanceof OwShortCutDocument)) continue;
                ret = inst.getDocument();
                break;
            }
        }
        return ret;
    }
}

