/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owshortcut;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.ecm.OwStandardObjectReference;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.field.OwStandardFieldColumnInfo;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutDocumentHelper;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutException;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutItem;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutItemContext;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutItemOwObject;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutView;
import com.wewebu.ow.server.plug.owshortcut.OwShortcutDocumentEventListner;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwShortCutDocument
extends OwMasterDocument {
    private static final Logger LOG = OwLog.getLogger(OwShortCutDocument.class);
    public static final String PLUGIN_CONFIG_SHORTCUT_FUNCTIONS = "ShortcutDocumentFunctions";
    public static final String PLUGIN_CONFIG_MAXCHILDSIZE = "MaxChildSize";
    public static final String SETTINGS_PARAM_COLUMN_INFO = "columninfo";
    public static final String SETTINGS_PARAM_SORT = "ColumnSortCriteria";
    private OwShortCutDocumentHelper m_shortcutsHelper;
    private List m_shortcutFunctionIDs;
    protected int m_iMaxChildSize = 50;
    private List m_defaultColumnInfoList;
    private List<OwShortcutDocumentEventListner> m_eventListeners = new LinkedList<OwShortcutDocumentEventListner>();
    private OwSort m_defaultObjectListSort;

    public void addOwObjectShortCuts(Collection objects_p) throws OwShortCutException {
        LinkedList<OwStandardObjectReference> objectReferences = new LinkedList<OwStandardObjectReference>();
        OwMainAppContext mainAppContext = (OwMainAppContext)this.getContext();
        OwNetwork network = mainAppContext.getNetwork();
        try {
            for (OwObjectReference reference : objects_p) {
                String refString = OwStandardObjectReference.getCompleteReferenceString((OwObjectReference)reference, (int)1);
                OwStandardObjectReference stdReference = new OwStandardObjectReference(refString, (OwRepository)network);
                objectReferences.add(stdReference);
            }
            Collection oShortCuts = OwShortCutItemOwObject.createShortCutItems(objectReferences);
            this.addShortCuts(oShortCuts);
        }
        catch (Exception e) {
            throw new OwShortCutException("Error while adding shortcuts !", (Throwable)e);
        }
    }

    public void addOwObjectShortCut(OwObject object_p, String path_p, String subdisplaypath_p) throws OwShortCutException {
        OwObject target;
        OwMainAppContext mainAppContext = (OwMainAppContext)this.getContext();
        OwNetwork network = mainAppContext.getNetwork();
        try {
            String parentPath = object_p.getPath();
            target = parentPath.endsWith("/") ? network.getObjectFromPath(parentPath + subdisplaypath_p.substring(1), false) : network.getObjectFromPath(parentPath + subdisplaypath_p, false);
        }
        catch (Exception e) {
            throw new OwShortCutException("Error while adding shortcut !", (Throwable)e);
        }
        OwShortCutItemOwObject item = new OwShortCutItemOwObject((OwObjectReference)object_p, (OwObjectReference)target, subdisplaypath_p, path_p);
        LinkedList<OwShortCutItemOwObject> shortcuts = new LinkedList<OwShortCutItemOwObject>();
        shortcuts.add(item);
        this.addShortCuts(shortcuts);
    }

    public void addShortCuts(Collection shortcuts_p) throws OwShortCutException {
        OwShortCutDocumentHelper helper = this.getShortCutDocumentHelper();
        if (helper.addShortCut(shortcuts_p)) {
            try {
                OwAttributeBagWriteable bag = this.getPersistentAttributeBagWriteable();
                for (OwShortCutItem owShortCutItem : shortcuts_p) {
                    String persistString = owShortCutItem.saveShortCut();
                    bag.setAttribute(owShortCutItem.getId(), (Object)persistString);
                }
                bag.save();
                this.fireShortcutDocumentChaged();
            }
            catch (Exception e) {
                String msg = this.getContext().localize("plugin.com.wewebu.ow.server.plug.owshortcut.errorsaving", "Error saving the shortcuts to AttributeBag");
                LOG.error((Object)msg, (Throwable)e);
                throw new OwShortCutException(msg, (Throwable)e);
            }
        }
    }

    public void deleteShortCut(String id_p) throws OwShortCutException {
        this.deleteShortCuts(Arrays.asList(id_p));
    }

    public void deleteShortCuts(List shortCutIds_p) throws OwShortCutException {
        OwShortCutDocumentHelper helper = this.getShortCutDocumentHelper();
        for (String id : shortCutIds_p) {
            String persistentId = helper.getPersistentId(id);
            if (!helper.deleteShortCut(id)) continue;
            try {
                OwAttributeBagWriteable bag = this.getPersistentAttributeBagWriteable();
                bag.remove(persistentId);
                bag.save();
            }
            catch (Exception e) {
                String msg = "Error deleting ShortCuts from AttributeBag";
                LOG.error((Object)msg, (Throwable)e);
                throw new OwShortCutException(msg, (Throwable)e);
            }
        }
        this.fireShortcutDocumentChaged();
    }

    public List getShortCutItems() throws OwShortCutException {
        return this.getShortCutDocumentHelper().getShortcuts();
    }

    private void initList() throws OwShortCutException {
        this.m_shortcutsHelper = this.createShortCutHelper();
        try {
            OwAttributeBagWriteable bag = this.getPersistentAttributeBagWriteable();
            Collection attributeName = bag.getAttributeNames();
            OwShortCutItemContext ctx = this.getShortCutItemContext();
            Iterator iterator = attributeName.iterator();
            while (iterator.hasNext()) {
                String persistString = (String)bag.getAttribute((String)iterator.next());
                OwShortCutItem item = this.deserializeShortCut(persistString, ctx);
                this.m_shortcutsHelper.addShortCut(item);
            }
        }
        catch (OwShortCutException e) {
            throw e;
        }
        catch (Exception e1) {
            String msg = "Could not init owShortCutDocument, there are problems with the PersistentAttributeBagWriteable..";
            LOG.error((Object)msg, (Throwable)e1);
            throw new OwShortCutException(msg, (Throwable)e1);
        }
    }

    protected OwShortCutDocumentHelper getShortCutDocumentHelper() throws OwShortCutException {
        if (null == this.m_shortcutsHelper) {
            this.initList();
        }
        return this.m_shortcutsHelper;
    }

    public List getShortcutFunctionIDs() {
        return this.m_shortcutFunctionIDs;
    }

    public OwSort getColumnSortCriteria() throws Exception {
        if (this.m_defaultObjectListSort == null) {
            List properties = (List)this.getSafeSetting(SETTINGS_PARAM_SORT, null);
            LinkedList<OwSort.OwSortCriteria> sortCriterias = new LinkedList<OwSort.OwSortCriteria>();
            HashSet<OwSort.OwSortCriteria> duplicateDedectionSet = new HashSet<OwSort.OwSortCriteria>();
            if (properties != null) {
                for (OwSort.OwSortCriteria sortCriteria : properties) {
                    if (sortCriteria == null) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("owplugins.xml - master plugin with id=");
                        buf.append(this.getPluginID());
                        buf.append(": tag <ColumnSortCriteria> is configured wrongly:");
                        buf.append(" one <property> tag contains no value.");
                        buf.append(" This tag was ignored");
                        LOG.warn((Object)buf.toString());
                        continue;
                    }
                    if (duplicateDedectionSet.contains(sortCriteria)) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("owplugins.xml - master plugin with id=");
                        buf.append(this.getPluginID());
                        buf.append(": tag <ColumnSortCriteria> is configured wrongly:");
                        buf.append(" one <property> tag contains a value=");
                        buf.append(sortCriteria.getPropertyName());
                        buf.append(" that was defined before.");
                        buf.append(" This tag was ignored");
                        LOG.warn((Object)buf.toString());
                        continue;
                    }
                    duplicateDedectionSet.add(sortCriteria);
                    boolean sortAscending = sortCriteria.getAscFlag();
                    sortCriterias.add(new OwSort.OwSortCriteria(sortCriteria.getPropertyName(), sortAscending));
                }
            }
            if (sortCriterias != null) {
                OwMainAppContext context = (OwMainAppContext)this.getContext();
                this.m_defaultObjectListSort = new OwSort(context.getMaxSortCriteriaCount(), true);
                while (!sortCriterias.isEmpty()) {
                    this.m_defaultObjectListSort.addCriteria((OwSort.OwSortCriteria)sortCriterias.removeLast());
                }
            }
        }
        return this.m_defaultObjectListSort;
    }

    public Collection getDefaultColumnInfo() throws Exception {
        if (null == this.m_defaultColumnInfoList) {
            List defaultPropertyNameList = (List)this.getSafeSetting(SETTINGS_PARAM_COLUMN_INFO, null);
            if (defaultPropertyNameList != null) {
                this.m_defaultColumnInfoList = new LinkedList();
                Iterator it = defaultPropertyNameList.iterator();
                while (it.hasNext()) {
                    String strPropertyName = (String)it.next();
                    OwFieldDefinition fielddef = null;
                    try {
                        fielddef = ((OwMainAppContext)this.getContext()).getNetwork().getFieldDefinition(strPropertyName, null);
                    }
                    catch (OwObjectNotFoundException e) {
                        LOG.warn((Object)("Could not resolve property for contentlist: " + strPropertyName));
                        it.remove();
                        continue;
                    }
                    this.m_defaultColumnInfoList.add(new OwStandardFieldColumnInfo(fielddef));
                }
            } else {
                this.m_defaultColumnInfoList = new LinkedList();
            }
        }
        return this.m_defaultColumnInfoList;
    }

    protected void init() throws Exception {
        super.init();
        this.m_shortcutFunctionIDs = this.getConfigNode().getSafeStringList(PLUGIN_CONFIG_SHORTCUT_FUNCTIONS);
        this.m_iMaxChildSize = this.getConfigNode().getSafeIntegerValue(PLUGIN_CONFIG_MAXCHILDSIZE, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(OwShortcutDocumentEventListner listener_p) {
        List<OwShortcutDocumentEventListner> list = this.m_eventListeners;
        synchronized (list) {
            this.m_eventListeners.add(listener_p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(OwShortcutDocumentEventListner listener_p) {
        List<OwShortcutDocumentEventListner> list = this.m_eventListeners;
        synchronized (list) {
            this.m_eventListeners.remove(listener_p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireShortcutDocumentChaged() {
        List<OwShortcutDocumentEventListner> list = this.m_eventListeners;
        synchronized (list) {
            for (OwShortcutDocumentEventListner listener : this.m_eventListeners) {
                listener.onShortcutDocumentChaged(this);
            }
        }
    }

    protected Map getRepositories() {
        HashMap<String, Object> repositories = new HashMap<String, Object>();
        repositories.put("OW_HISTORY", ((OwMainAppContext)this.getContext()).getHistoryManager());
        repositories.put("OW_ECM_ADAPTER", ((OwMainAppContext)this.getContext()).getNetwork());
        return repositories;
    }

    public void refreshShortcuts() throws OwShortCutException {
        OwShortCutDocumentHelper helper = this.getShortCutDocumentHelper();
        try {
            helper.refresh((OwRepository)((OwMainAppContext)this.getContext()).getNetwork());
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot refresh shortcut list", (Throwable)e);
            throw new OwShortCutException("Cannot refresh shortcut list", (Throwable)e);
        }
    }

    protected OwShortCutDocumentHelper createShortCutHelper() {
        return new OwShortCutDocumentHelper();
    }

    protected OwShortCutItem deserializeShortCut(String persistString, OwShortCutItemContext context) throws OwException {
        return OwShortCutItem.loadShortCut(persistString, context, this.m_iMaxChildSize);
    }

    protected OwShortCutItemContext getShortCutItemContext() {
        OwShortCutItemContext ctx = ((OwShortCutView)this.getMasterView()).getItemView();
        if (ctx == null || ctx.getContext() == null) {
            ctx = new OwSimpleShortCutContext(this.getContext());
        }
        return ctx;
    }

    protected static class OwSimpleShortCutContext
    implements OwShortCutItemContext {
        private OwAppContext context;

        public OwSimpleShortCutContext(OwAppContext ctx) {
            this.context = ctx;
        }

        @Override
        public OwAppContext getContext() {
            return this.context;
        }

        @Override
        public OwMimeManager getMimeManager() {
            return null;
        }
    }
}

