/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owshortcut;

import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutException;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutItemContext;
import com.wewebu.ow.server.plug.owshortcut.OwShortCutItemOwObject;
import com.wewebu.ow.server.plug.std.log.OwLog;
import java.io.Writer;
import org.apache.log4j.Logger;

public abstract class OwShortCutItem {
    private static final Logger LOG = OwLog.getLogger(OwShortCutItem.class);
    protected static final String TYPE_DELIMITER = ",";
    protected String persistentId;

    public abstract void insertIcon(OwShortCutItemContext var1, Writer var2) throws Exception;

    public abstract void insertLabel(OwShortCutItemContext var1, Writer var2) throws Exception;

    protected abstract String getPersistString() throws Exception;

    public abstract int getType();

    public abstract String getId() throws Exception;

    public String getPersistentId() throws Exception {
        return this.persistentId != null ? this.persistentId : this.getId();
    }

    public abstract String getName();

    public String saveShortCut() throws OwShortCutException {
        StringBuffer ret = new StringBuffer();
        try {
            ret.append(String.valueOf(this.getType()));
            ret.append(TYPE_DELIMITER);
            ret.append(this.getPersistString());
        }
        catch (Exception e) {
            String msg = "OwShortCutItem.saveShortCut():Exception in save shortcut (getPersistString)...";
            LOG.error((Object)msg, (Throwable)e);
            throw new OwShortCutException(msg, (Throwable)e);
        }
        return ret.toString();
    }

    public static OwShortCutItem loadShortCut(String persistString_p, OwShortCutItemContext context_p, int maxChildSize_p) throws OwException {
        int iTypeIndex = persistString_p.indexOf(TYPE_DELIMITER);
        String type = persistString_p.substring(0, iTypeIndex);
        String rest = persistString_p.substring(iTypeIndex + TYPE_DELIMITER.length());
        int iType = 0;
        try {
            iType = Integer.parseInt(type);
        }
        catch (NumberFormatException mfEx) {
            LOG.error((Object)("Invalid parameter for type object : " + type), (Throwable)mfEx);
            throw new OwServerException("Invalid parameter, cannot identify object type", (Throwable)mfEx);
        }
        switch (iType) {
            case 1: {
                try {
                    return new OwShortCutItemOwObject(rest, context_p, maxChildSize_p);
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Cannot create ShortCutItem from String : " + persistString_p), (Throwable)e);
                    throw new OwShortCutException("Unable to create ShortCutItem", (Throwable)e);
                }
            }
        }
        String msg = "OwShortCutItem.loadShortCut: Can not reconstruct shortcut item, unknown type = " + persistString_p;
        LOG.error((Object)msg);
        throw new OwInvalidOperationException(msg);
    }

    public abstract void refresh(OwRepository var1) throws OwException;
}

