/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.assembler.ClientTubelineAssemblyContext;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.RxConfiguration;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.runtime.McClientTube;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.ClientSession;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import java.io.IOException;
import javax.xml.ws.WebServiceException;

final class RmClientTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(RmClientTube.class);
    private final ClientSession session;
    private final WSDLPort wsdlPort;
    private Packet requestPacketCopy;
    private int resendCounter;

    RmClientTube(RmClientTube original, TubeCloner cloner) {
        super(original, cloner);
        this.session = original.session;
        this.wsdlPort = original.wsdlPort;
        this.requestPacketCopy = null;
        this.resendCounter = 0;
    }

    RmClientTube(RxConfiguration configuration, Tube tubelineHead, ClientTubelineAssemblyContext context) throws RxRuntimeException {
        super(tubelineHead);
        WSEndpointReference clientEndpointReference;
        SecureConversationInitiator scInitiator = context.getImplementation(SecureConversationInitiator.class);
        if (scInitiator == null) {
            scInitiator = context.getScInitiator();
        }
        McClientTube mcClientTube = context.getImplementation(McClientTube.class);
        if (configuration.isMakeConnectionSupportEnabled()) {
            assert (mcClientTube != null);
            clientEndpointReference = mcClientTube.getWsmcAnonymousEndpointReference();
        } else {
            clientEndpointReference = configuration.getAddressingVersion().anonymousEpr;
        }
        this.session = ClientSession.create(configuration, clientEndpointReference, new Communicator("RmClientTubeCommunicator", context.getAddress(), this.next, scInitiator, configuration.getAddressingVersion(), configuration.getSoapVersion(), configuration.getRmVersion().getJaxbContext(configuration.getAddressingVersion())));
        if (configuration.isMakeConnectionSupportEnabled()) {
            assert (mcClientTube != null);
            mcClientTube.registerProtocolResponseHandler(this.session.getRmProtocolResponseHandler());
        }
        this.wsdlPort = context.getWsdlPort();
        this.requestPacketCopy = null;
        this.resendCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmClientTube copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            RmClientTube rmClientTube = new RmClientTube(this, cloner);
            return rmClientTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processRequest(Packet requestPacket) {
        LOGGER.entering();
        try {
            if (this.isResendAttempt()) {
                this.session.registerForResend(Fiber.current(), requestPacket, this.resendCounter);
                NextAction nextAction = this.doSuspend(this.next);
                return nextAction;
            }
            requestPacket = this.session.registerOutgoingRequest(requestPacket);
            this.initResendResources(requestPacket);
            requestPacket = this.session.appendOutgoingAcknowledgementHeaders(requestPacket);
            NextAction nextAction = super.processRequest(requestPacket);
            return nextAction;
        }
        catch (RxRuntimeException ex) {
            LOGGER.logSevereException(ex);
            NextAction nextAction = this.doThrow((Throwable)((Object)ex));
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processResponse(Packet responsePacket) {
        LOGGER.entering();
        try {
            boolean responseToOneWayRequest = this.requestPacketCopy.getMessage().isOneWay(this.wsdlPort);
            responsePacket = this.session.processIncommingPacket(responsePacket, responseToOneWayRequest);
            if (responseToOneWayRequest) {
                if (!this.session.isRequestAcknowledged(this.requestPacketCopy)) {
                    this.session.registerForResend(this.requestPacketCopy, this.resendCounter);
                }
            } else if (!this.session.isRequestAcknowledged(this.requestPacketCopy) || this.responseNotAvailableYet(responsePacket)) {
                LOGGER.fine(LocalizationMessages.WSRM_1102_RESENDING_DROPPED_MESSAGE());
                NextAction nextAction = this.doResend();
                return nextAction;
            }
            this.resetResendResources();
            NextAction nextAction = super.processResponse(responsePacket);
            return nextAction;
        }
        catch (RxRuntimeException ex) {
            LOGGER.logSevereException(ex);
            this.resetResendResources();
            NextAction nextAction = this.doThrow((Throwable)((Object)ex));
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processException(Throwable throwable) {
        LOGGER.entering();
        try {
            if (RmClientTube.isResendPossible(throwable)) {
                NextAction nextAction = this.doResend();
                return nextAction;
            }
            this.resetResendResources();
            NextAction nextAction = super.processException(throwable);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDestroy() {
        LOGGER.entering();
        try {
            this.session.close();
        }
        catch (RuntimeException ex) {
            LOGGER.warning(LocalizationMessages.WSRM_1103_RM_SEQUENCE_NOT_TERMINATED_NORMALLY(), ex);
        }
        finally {
            super.preDestroy();
            LOGGER.exiting();
        }
    }

    static boolean isResendPossible(Throwable throwable) {
        if (throwable instanceof IOException) {
            return true;
        }
        return throwable instanceof WebServiceException && throwable.getCause() instanceof IOException;
    }

    private NextAction doResend() {
        ++this.resendCounter;
        return super.doInvokeAndForget(this, this.requestPacketCopy.copy(true));
    }

    private boolean isResendAttempt() {
        return this.requestPacketCopy != null;
    }

    private void initResendResources(Packet requestPacket) {
        this.requestPacketCopy = requestPacket.copy(true);
    }

    private void resetResendResources() {
        this.requestPacketCopy = null;
        this.resendCounter = 0;
    }

    private boolean responseNotAvailableYet(Packet responsePacket) {
        Message responseMessage = responsePacket.getMessage();
        return responseMessage != null && !responseMessage.hasPayload();
    }
}

