/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming.processor;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.xml.bind.v2.runtime.unmarshaller.Base64Data;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.EncryptedKey;
import com.sun.xml.ws.security.opt.impl.incoming.processor.KeyValueProcessor;
import com.sun.xml.ws.security.opt.impl.incoming.processor.SecurityTokenProcessor;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.logging.impl.opt.LogStringsMessages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.KeySelector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jvnet.staxex.XMLStreamReaderEx;

public class KeyInfoProcessor {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt", "com.sun.xml.wss.logging.impl.opt.LogStrings");
    private static String KEYINFO = "KeyInfo".intern();
    private static String SECURITY_TOKEN_REFERENCE = "SecurityTokenReference".intern();
    private static final int SECURITY_TOKEN_REFERENCE_ELEMENT = 3;
    private static final int ENCRYPTED_KEY_ELEMENT = 4;
    private static final int KEY_VALUE_ELEMENT = 5;
    private static final int RSA_KEY_VALUE_ELEMENT = 6;
    private static final int DSA_KEY_VALUE_ELEMENT = 7;
    private static final int MODULUS_ELEMENT = 8;
    private static final int EXPONENT_ELEMENT = 9;
    private static final int X509_DATA_ELEMENT = 10;
    private static final int BINARY_SECRET_ELEMENT = 11;
    private static final String RSA_KEY_VALUE = "RSAKeyValue";
    private static final String DSA_KEY_VALUE = "DSAKeyValue";
    private static final String ENCRYPTED_KEY = "EncryptedKey";
    private static final String KEY_VALUE = "KeyValue";
    private static final String EXPONENT = "Exponent";
    private static final String MODULUS = "Modulus";
    private static final String X509_DATA = "X509Data";
    private static final String X509Certificate = "X509Certificate";
    private static final String BINARY_SECRET = "BinarySecret";
    private boolean strPresent = false;
    private JAXBFilterProcessingContext pc = null;
    private XMLStreamWriter canonWriter = null;
    private boolean isSAMLSubjectConfirmationKeyInfo = false;
    private KeySelector.Purpose purpose = null;

    public KeyInfoProcessor(JAXBFilterProcessingContext pc) {
        this.pc = pc;
        ((NamespaceContextEx)pc.getNamespaceContext()).addSignatureNS();
    }

    public KeyInfoProcessor(JAXBFilterProcessingContext pc, XMLStreamWriter canonWriter, KeySelector.Purpose purpose) {
        this.pc = pc;
        this.canonWriter = canonWriter;
        this.purpose = purpose;
    }

    public KeyInfoProcessor(JAXBFilterProcessingContext pc, KeySelector.Purpose purpose) {
        this.pc = pc;
        this.purpose = purpose;
    }

    public KeyInfoProcessor(JAXBFilterProcessingContext pc, KeySelector.Purpose purpose, boolean isSAMLSCKey) {
        this.pc = pc;
        this.purpose = purpose;
        this.isSAMLSubjectConfirmationKeyInfo = isSAMLSCKey;
    }

    public Key getKey(XMLStreamReader reader) throws XMLStreamException, XWSSecurityException {
        return this.processKeyInfo(reader);
    }

    private Key processKeyInfo(XMLStreamReader reader) throws XMLStreamException, XWSSecurityException {
        Key retKey = null;
        if (this.canonWriter != null) {
            StreamUtil.writeStartElement(reader, this.canonWriter);
        }
        block11: while (reader.hasNext() && !StreamUtil._break(reader, KEYINFO, "http://www.w3.org/2000/09/xmldsig#")) {
            reader.next();
            int eventType = this.getEventType(reader);
            switch (eventType) {
                case 3: {
                    SecurityTokenProcessor stp = new SecurityTokenProcessor(this.pc, this.canonWriter, this.purpose);
                    retKey = stp.resolveReference(reader);
                    this.strPresent = true;
                    break;
                }
                case 4: {
                    EncryptedKey ek = new EncryptedKey(reader, this.pc, null, true);
                    String dataEncAlgo = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
                    if (this.pc.getAlgorithmSuite() != null) {
                        dataEncAlgo = this.pc.getAlgorithmSuite().getEncryptionAlgorithm();
                    }
                    retKey = ek.getKey(dataEncAlgo);
                    break;
                }
                case 5: {
                    if (this.canonWriter != null) {
                        StreamUtil.writeCurrentEvent(reader, this.canonWriter);
                    }
                    retKey = new KeyValueProcessor(this.pc, this.canonWriter).processKeyValue(reader);
                    if (this.isSAMLSubjectConfirmationKeyInfo || this.purpose != KeySelector.Purpose.VERIFY) break;
                    X509Certificate cer = null;
                    try {
                        cer = this.pc.getSecurityEnvironment().getCertificate(this.pc.getExtraneousProperties(), (PublicKey)retKey, false);
                    }
                    catch (XWSSecurityException ex) {
                        // empty catch block
                    }
                    if (cer == null) continue block11;
                    this.pc.getSecurityEnvironment().validateCertificate(cer, this.pc.getExtraneousProperties());
                    break;
                }
                case 11: {
                    reader.next();
                    retKey = this.buildBinarySecret(reader);
                    break;
                }
                case 10: {
                    if (this.canonWriter != null) {
                        StreamUtil.writeCurrentEvent(reader, this.canonWriter);
                    }
                    StreamUtil.moveToNextStartOREndElement(reader, this.canonWriter);
                    if (reader.getLocalName() != X509Certificate || reader.getNamespaceURI() != "http://www.w3.org/2000/09/xmldsig#") break;
                    reader.next();
                    StringBuffer sb = null;
                    byte[] value = null;
                    CharSequence charSeq = ((XMLStreamReaderEx)reader).getPCDATA();
                    if (charSeq instanceof Base64Data) {
                        Base64Data bd = (Base64Data)((XMLStreamReaderEx)reader).getPCDATA();
                        value = bd.getExact();
                        if (this.canonWriter == null) continue block11;
                        String ev = Base64.encode(value);
                        this.canonWriter.writeCharacters(ev);
                        break;
                    }
                    sb = new StringBuffer();
                    while (true) {
                        if (reader.getEventType() != 4) break;
                        if (reader.getEventType() == 2) break;
                        charSeq = ((XMLStreamReaderEx)reader).getPCDATA();
                        for (int i = 0; i < charSeq.length(); ++i) {
                            sb.append(charSeq.charAt(i));
                        }
                        reader.next();
                    }
                    String dv = sb.toString();
                    if (this.canonWriter != null) {
                        this.canonWriter.writeCharacters(dv);
                    }
                    try {
                        value = Base64.decode(dv);
                    }
                    catch (Base64DecodingException dec) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1606_ERROR_RSAKEYINFO_BASE_64_DECODING("MODULUS"));
                        throw new XWSSecurityException(LogStringsMessages.WSS_1606_ERROR_RSAKEYINFO_BASE_64_DECODING("MODULUS"));
                    }
                    X509Certificate cert = this.buildCertificate(new ByteArrayInputStream(value));
                    if (this.purpose == KeySelector.Purpose.DECRYPT) {
                        retKey = this.pc.getSecurityEnvironment().getPrivateKey(this.pc.getExtraneousProperties(), cert);
                    } else if (this.purpose == KeySelector.Purpose.VERIFY) {
                        retKey = cert.getPublicKey();
                    }
                    if (this.isSAMLSubjectConfirmationKeyInfo || this.purpose != KeySelector.Purpose.VERIFY) break;
                    this.pc.getSecurityEnvironment().validateCertificate(cert, this.pc.getExtraneousProperties());
                }
            }
        }
        if (reader.hasNext() && this.canonWriter != null) {
            StreamUtil.writeCurrentEvent(reader, this.canonWriter);
        }
        reader.next();
        return retKey;
    }

    private Key buildBinarySecret(XMLStreamReader reader) throws XWSSecurityException, XMLStreamException {
        byte[] value = null;
        if (reader.getEventType() == 4) {
            if (reader instanceof XMLStreamReaderEx) {
                CharSequence charSeq = ((XMLStreamReaderEx)reader).getPCDATA();
                if (charSeq instanceof Base64Data) {
                    Base64Data bd = (Base64Data)((XMLStreamReaderEx)reader).getPCDATA();
                    value = bd.getExact();
                    if (this.canonWriter != null) {
                        String ev = Base64.encode(value);
                        this.canonWriter.writeCharacters(ev);
                    }
                } else {
                    String dv = this.readCharacters(reader);
                    try {
                        value = Base64.decode(dv);
                    }
                    catch (Base64DecodingException dec) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1606_ERROR_RSAKEYINFO_BASE_64_DECODING("MODULUS"));
                        throw new XWSSecurityException(LogStringsMessages.WSS_1606_ERROR_RSAKEYINFO_BASE_64_DECODING("MODULUS"));
                    }
                }
            } else {
                String dv = this.readCharacters(reader);
                try {
                    value = Base64.decode(dv);
                }
                catch (Base64DecodingException dec) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1606_ERROR_RSAKEYINFO_BASE_64_DECODING("MODULUS"));
                    throw new XWSSecurityException(LogStringsMessages.WSS_1606_ERROR_RSAKEYINFO_BASE_64_DECODING("MODULUS"));
                }
            }
        }
        String algorithm = "AES";
        if (this.pc.getAlgorithmSuite() != null) {
            algorithm = SecurityUtil.getSecretKeyAlgorithm(this.pc.getAlgorithmSuite().getEncryptionAlgorithm());
        }
        return new SecretKeySpec(value, algorithm);
    }

    private String readCharacters(XMLStreamReader reader) throws XMLStreamException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            if (reader.getEventType() != 4) break;
            if (reader.getEventType() == 2) break;
            CharSequence charSeq = ((XMLStreamReaderEx)reader).getPCDATA();
            for (int i = 0; i < charSeq.length(); ++i) {
                sb.append(charSeq.charAt(i));
            }
            reader.next();
        }
        String dv = sb.toString();
        if (this.canonWriter != null) {
            this.canonWriter.writeCharacters(dv);
        }
        return dv;
    }

    private X509Certificate buildCertificate(InputStream certValue) throws XWSSecurityException {
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certFact.generateCertificate(certValue);
        }
        catch (CertificateException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1605_ERROR_GENERATING_CERTIFICATE(ex));
            throw new XWSSecurityException(LogStringsMessages.WSS_1605_ERROR_GENERATING_CERTIFICATE(ex));
        }
    }

    private int getEventType(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() == 1) {
            if (reader.getLocalName() == SECURITY_TOKEN_REFERENCE) {
                return 3;
            }
            if (reader.getLocalName() == ENCRYPTED_KEY) {
                return 4;
            }
            if (reader.getLocalName() == KEY_VALUE) {
                return 5;
            }
            if (reader.getLocalName() == X509_DATA) {
                return 10;
            }
            if (reader.getLocalName() == BINARY_SECRET) {
                return 11;
            }
        }
        return -1;
    }

    public boolean hasSTR() {
        return this.strPresent;
    }
}

