/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.servicechannel;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.ServerConnectionSession;
import com.sun.xml.ws.transport.tcp.server.TCPAdapter;
import com.sun.xml.ws.transport.tcp.server.WSTCPAdapterRegistry;
import com.sun.xml.ws.transport.tcp.servicechannel.ServiceChannelErrorCode;
import com.sun.xml.ws.transport.tcp.servicechannel.ServiceChannelException;
import com.sun.xml.ws.transport.tcp.util.BindingUtils;
import com.sun.xml.ws.transport.tcp.util.ChannelContext;
import com.sun.xml.ws.transport.tcp.util.ChannelSettings;
import com.sun.xml.ws.transport.tcp.util.ConnectionSession;
import com.sun.xml.ws.transport.tcp.util.WSTCPURI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService
public class ServiceChannelWSImpl {
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.transport.tcp.server");
    @Resource
    private WebServiceContext wsContext;

    public void initiateSession() throws ServiceChannelException {
        ChannelContext serviceChannelContext = this.getChannelContext();
        ConnectionSession connectionSession = serviceChannelContext.getConnectionSession();
        logger.log(Level.FINE, MessagesMessages.WSTCP_1140_SOAPTCP_SESSION_OPEN(connectionSession.hashCode()));
    }

    @WebResult(name="channelId")
    public int openChannel(@WebParam(name="targetWSURI", mode=WebParam.Mode.IN) String targetWSURI, @WebParam(name="negotiatedMimeTypes", mode=WebParam.Mode.INOUT) Holder<List<String>> negotiatedMimeTypes, @WebParam(name="negotiatedParams", mode=WebParam.Mode.INOUT) Holder<List<String>> negotiatedParams) throws ServiceChannelException {
        WSTCPURI tcpURI;
        ChannelContext serviceChannelContext = this.getChannelContext();
        ServerConnectionSession connectionSession = (ServerConnectionSession)serviceChannelContext.getConnectionSession();
        WSTCPAdapterRegistry adapterRegistry = this.getAdapterRegistry();
        TCPAdapter adapter = adapterRegistry.getTarget(tcpURI = WSTCPURI.parse(targetWSURI));
        if (adapter == null) {
            throw new ServiceChannelException(ServiceChannelErrorCode.UNKNOWN_ENDPOINT_ADDRESS, MessagesMessages.WSTCP_0034_WS_ENDPOINT_NOT_FOUND(targetWSURI));
        }
        BindingUtils.NegotiatedBindingContent serviceSupportedContent = BindingUtils.getNegotiatedContentTypesAndParams(adapter.getEndpoint().getBinding());
        ((List)negotiatedMimeTypes.value).retainAll(serviceSupportedContent.negotiatedMimeTypes);
        if (((List)negotiatedMimeTypes.value).size() == 0) {
            throw new ServiceChannelException(ServiceChannelErrorCode.CONTENT_NEGOTIATION_FAILED, MessagesMessages.WSTCP_0033_CONTENT_NEGOTIATION_FAILED(targetWSURI, serviceSupportedContent.negotiatedMimeTypes));
        }
        ((List)negotiatedParams.value).retainAll(serviceSupportedContent.negotiatedParams);
        int channelId = connectionSession.getNextAvailChannelId();
        ChannelSettings channelSettings = new ChannelSettings((List)negotiatedMimeTypes.value, (List)negotiatedParams.value, channelId, adapter.getEndpoint().getServiceName(), tcpURI);
        ChannelContext openedChannelContext = new ChannelContext(connectionSession, channelSettings);
        SOAPVersion soapVersion = adapter.getEndpoint().getBinding().getSOAPVersion();
        Codec defaultCodec = adapter.getEndpoint().createCodec();
        ChannelContext.configureCodec(openedChannelContext, soapVersion, defaultCodec);
        connectionSession.registerChannel(openedChannelContext);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1141_SOAPTCP_CHANNEL_OPEN(connectionSession.hashCode(), openedChannelContext.getChannelId(), targetWSURI));
        }
        return channelId;
    }

    public void closeChannel(@WebParam(name="channelId", mode=WebParam.Mode.IN) int channelId) throws ServiceChannelException {
        ChannelContext serviceChannelContext = this.getChannelContext();
        ServerConnectionSession connectionSession = (ServerConnectionSession)serviceChannelContext.getConnectionSession();
        if (connectionSession.findWSServiceContextByChannelId(channelId) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1142_SOAPTCP_CHANNEL_CLOSE(connectionSession.hashCode(), channelId));
            }
        } else {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, MessagesMessages.WSTCP_0035_UNKNOWN_CHANNEL_UD("Session: " + connectionSession.hashCode() + " Channel-id: " + channelId));
            }
            throw new ServiceChannelException(ServiceChannelErrorCode.UNKNOWN_CHANNEL_ID, MessagesMessages.WSTCP_0035_UNKNOWN_CHANNEL_UD(channelId));
        }
        connectionSession.deregisterChannel(channelId);
    }

    @NotNull
    private ChannelContext getChannelContext() {
        MessageContext messageContext = this.wsContext.getMessageContext();
        return (ChannelContext)messageContext.get((Object)"channelContext");
    }

    @NotNull
    private WSTCPAdapterRegistry getAdapterRegistry() {
        MessageContext messageContext = this.wsContext.getMessageContext();
        return (WSTCPAdapterRegistry)messageContext.get((Object)"AdapterRegistry");
    }
}

