/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import org.glassfish.gmbal.generic.DprintUtil;
import org.glassfish.gmbal.generic.FacetAccessor;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.MBeanImpl;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;

public class MBeanTree {
    private boolean rootIsSet = false;
    private Object root;
    private MBeanImpl rootEntity;
    private Map<Object, MBeanImpl> objectMap;
    private Map<ObjectName, Object> objectNameMap;
    private String domain;
    private ObjectName rootParentName;
    private String rootParentPrefix;
    private String typeString;
    private ManagedObjectManagerInternal mom;
    private DprintUtil dputil;

    private void addToObjectMaps(MBeanImpl mbean) {
        ObjectName oname = mbean.objectName();
        for (Object obj : mbean.facets()) {
            this.objectMap.put(obj, mbean);
        }
        this.objectNameMap.put(oname, mbean);
    }

    private void removeFromObjectMaps(MBeanImpl mbean) {
        ObjectName oname = mbean.objectName();
        for (Object obj : mbean.facets()) {
            this.objectMap.remove(obj);
        }
        this.objectNameMap.remove(oname);
    }

    public synchronized NotificationEmitter setRoot(Object root, String rootName) {
        ObjectName oname;
        if (this.rootIsSet) {
            throw Exceptions.self.rootAlreadySet();
        }
        this.rootIsSet = true;
        MBeanImpl rootMB = this.mom.constructMBean(root, rootName);
        try {
            oname = this.objectName(null, rootMB.type(), rootMB.name());
        }
        catch (MalformedObjectNameException ex) {
            throw Exceptions.self.noRootObjectName(ex);
        }
        rootMB.objectName(oname);
        this.addToObjectMaps(rootMB);
        try {
            rootMB.register();
        }
        catch (JMException ex) {
            throw Exceptions.self.rootRegisterFail(ex);
        }
        this.root = root;
        this.rootEntity = rootMB;
        return rootMB;
    }

    public synchronized Object getRoot() {
        if (this.rootIsSet) {
            return this.root;
        }
        throw Exceptions.self.rootNotSet();
    }

    private String getRootParentPrefix(ObjectName rootParentName) {
        String[] keys = rootParentName.getKeyPropertyListString().split(",");
        StringBuilder res = new StringBuilder();
        String typeValue = null;
        String nameValue = null;
        for (String str : keys) {
            int index = str.indexOf(61);
            String key = str.substring(0, index);
            String value = str.substring(index + 1);
            if (key.equals("type") || key.equals("j2eeType")) {
                typeValue = value;
                continue;
            }
            if (key.equals("name")) {
                nameValue = value;
                continue;
            }
            res.append(key);
            res.append('=');
            res.append(value);
            res.append(',');
        }
        if (typeValue == null || nameValue == null) {
            throw Exceptions.self.invalidRootParentName(rootParentName);
        }
        String result = res + typeValue + '=' + nameValue;
        return result;
    }

    public MBeanTree(ManagedObjectManagerInternal mom, String domain, ObjectName rootParentName, String typeString) {
        this.mom = mom;
        this.domain = domain;
        this.rootParentName = rootParentName;
        this.rootParentPrefix = rootParentName == null ? null : this.getRootParentPrefix(rootParentName);
        this.typeString = typeString;
        this.objectMap = new HashMap<Object, MBeanImpl>();
        this.objectNameMap = new HashMap<ObjectName, Object>();
        this.dputil = new DprintUtil(this.getClass());
    }

    public synchronized FacetAccessor getFacetAccessor(Object obj) {
        return this.objectMap.get(obj);
    }

    private void checkCorrectRoot(MBeanImpl entity) {
        MBeanImpl current = entity;
        do {
            if (current != this.rootEntity) continue;
            return;
        } while ((current = current.parent()) != null);
        throw Exceptions.self.notPartOfThisTree(entity);
    }

    public synchronized ObjectName objectName(MBeanImpl parent, String type, String name) throws MalformedObjectNameException {
        if (parent != null) {
            this.checkCorrectRoot(parent);
        }
        StringBuilder result = new StringBuilder();
        result.append(this.domain);
        result.append(":");
        if (this.rootParentPrefix != null) {
            result.append(this.rootParentPrefix);
            result.append(',');
        }
        if (parent != null) {
            result.append(parent.restName());
        }
        result.append(this.typeString);
        result.append("=");
        result.append(type);
        result.append(',');
        result.append("name");
        result.append("=");
        result.append(name);
        return new ObjectName(result.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized NotificationEmitter register(Object parent, Object obj, MBeanImpl mb) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException {
        if (this.mom.registrationDebug()) {
            this.dputil.enter("register", "parent=", parent, "obj=", obj, "mb=", mb);
        }
        try {
            if (parent == null) {
                throw Exceptions.self.parentCannotBeNull();
            }
            MBeanImpl oldMB = this.objectMap.get(obj);
            if (oldMB != null) {
                String msg = Exceptions.self.objectAlreadyRegistered(obj, oldMB);
                if (this.mom.registrationDebug()) {
                    this.dputil.info(msg);
                }
                throw new IllegalArgumentException(msg);
            }
            MBeanImpl parentEntity = this.objectMap.get(parent);
            if (parentEntity == null) {
                String msg = Exceptions.self.parentNotFound(parent);
                if (this.mom.registrationDebug()) {
                    this.dputil.info(msg);
                }
                throw new IllegalArgumentException(msg);
            }
            ObjectName oname = this.objectName(parentEntity, mb.type(), mb.name());
            mb.objectName(oname);
            this.addToObjectMaps(mb);
            parentEntity.addChild(mb);
            mb.register();
            MBeanImpl mBeanImpl = mb;
            return mBeanImpl;
        }
        finally {
            if (this.mom.registrationDebug()) {
                this.dputil.exit();
            }
        }
    }

    public synchronized void unregister(Object obj) throws InstanceNotFoundException, MBeanRegistrationException {
        MBeanImpl mb;
        if (obj == this.root) {
            this.rootIsSet = false;
            this.root = null;
            this.rootEntity = null;
        }
        if ((mb = this.objectMap.get(obj)) == null) {
            throw Exceptions.self.objectNotFound(obj);
        }
        for (Map<String, MBeanImpl> nameToMBean : mb.children().values()) {
            for (MBeanImpl child : nameToMBean.values()) {
                this.unregister(child.target());
            }
        }
        this.removeFromObjectMaps(mb);
        mb.unregister();
        if (mb.parent() != null) {
            mb.parent().removeChild(mb);
        }
    }

    public synchronized ObjectName getObjectName(Object obj) {
        MBeanImpl result = this.objectMap.get(obj);
        return result.objectName();
    }

    public synchronized Object getObject(ObjectName oname) {
        return this.objectNameMap.get(oname);
    }

    public synchronized MBeanImpl getMBeanImpl(Object obj) {
        return this.objectMap.get(obj);
    }

    public synchronized void clear() {
        if (this.rootIsSet) {
            try {
                this.unregister(this.root);
            }
            catch (InstanceNotFoundException ex) {
                throw Exceptions.self.shouldNotHappen(ex);
            }
            catch (MBeanRegistrationException ex) {
                throw Exceptions.self.shouldNotHappen(ex);
            }
        }
        this.objectMap.clear();
        this.objectNameMap.clear();
        this.rootEntity = null;
    }

    public ObjectName getRootParentName() {
        return this.rootParentName;
    }
}

