/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.parser.handler;

import javax.xml.namespace.QName;
import org.jvnet.wom.api.parser.WSDLEventSource;
import org.jvnet.wom.impl.WSDLBoundFaultImpl;
import org.jvnet.wom.impl.WSDLBoundInputImpl;
import org.jvnet.wom.impl.WSDLBoundOperationImpl;
import org.jvnet.wom.impl.WSDLBoundOutputImpl;
import org.jvnet.wom.impl.parser.WSDLContentHandlerEx;
import org.jvnet.wom.impl.parser.handler.AbstractHandler;
import org.jvnet.wom.impl.parser.handler.BoundFault;
import org.jvnet.wom.impl.parser.handler.BoundInput;
import org.jvnet.wom.impl.parser.handler.BoundOutput;
import org.jvnet.wom.impl.parser.handler.Messages;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BoundOperation
extends AbstractHandler {
    private WSDLBoundOperationImpl boundOperation;
    private WSDLContentHandlerEx runtime;
    private String expectedNamespace;

    public BoundOperation(AbstractHandler parent, WSDLEventSource source, WSDLContentHandlerEx runtime, int cookie, String expectedNamespace) {
        super(source, parent, cookie);
        this.runtime = runtime;
        this.expectedNamespace = expectedNamespace;
    }

    protected BoundOperation(WSDLEventSource source, AbstractHandler parent, int parentCookie) {
        super(source, parent, parentCookie);
    }

    protected WSDLContentHandlerEx getRuntime() {
        return this.runtime;
    }

    protected void onChildCompleted(Object result, int cookie, boolean needAttCheck) throws SAXException {
        switch (cookie) {
            case 711: {
                WSDLBoundInputImpl input = (WSDLBoundInputImpl)result;
                input.setParent(this.boundOperation);
                this.boundOperation.setBoundInput(input);
                break;
            }
            case 712: {
                WSDLBoundOutputImpl output = (WSDLBoundOutputImpl)result;
                output.setParent(this.boundOperation);
                this.boundOperation.setBoundOutput(output);
                break;
            }
            case 713: {
                WSDLBoundFaultImpl fault = (WSDLBoundFaultImpl)result;
                fault.setParent(this.boundOperation);
                this.boundOperation.addBoundFault(fault);
            }
        }
    }

    public void enterElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("operation")) {
            this.runtime.onEnterElementConsumed(uri, localName, qname, atts);
            Attributes test = this.runtime.getCurrentAttributes();
            this.processAttributes(test);
        } else if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("input")) {
            BoundInput boundInput = new BoundInput(this, this._source, this.runtime, 711, this.expectedNamespace);
            this.spawnChildFromEnterElement(boundInput, uri, localName, qname, atts);
        } else if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("output")) {
            BoundOutput boundOutput = new BoundOutput(this, this._source, this.runtime, 712, this.expectedNamespace);
            this.spawnChildFromEnterElement(boundOutput, uri, localName, qname, atts);
        } else if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("fault")) {
            BoundFault boundFault = new BoundFault(this, this._source, this.runtime, 713, this.expectedNamespace);
            this.spawnChildFromEnterElement(boundFault, uri, localName, qname, atts);
        } else {
            super.enterElement(uri, localName, qname, atts);
        }
    }

    public void leaveElement(String uri, String localName, String qname) throws SAXException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(uri) && localName.equals("operation")) {
            this.endProcessingExtentionElement(this.boundOperation);
            this.revertToParentFromLeaveElement(this.boundOperation, this._cookie, uri, localName, qname);
            this.boundOperation.setDocumentation(this.getWSDLDocumentation());
        }
    }

    private void processAttributes(Attributes test) throws SAXException {
        int index;
        int[] validattrs = new int[test.getLength()];
        String name = XmlUtil.fixNull(test.getValue("name"));
        if (name.equals("")) {
            this.runtime.getErrorHandler().warning(new SAXParseException(Messages.format("wsdl.missingName", "wsdl:operation", name), this.runtime.getLocator()));
        }
        if ((index = test.getIndex("name")) >= 0) {
            validattrs[index] = 1;
        }
        this.boundOperation = new WSDLBoundOperationImpl(this.runtime.getLocator(), new QName(this.runtime.currentWSDL.getName().getNamespaceURI(), name), this.runtime.document);
        this.validateAttribute(this.runtime.getErrorHandler(), test, validattrs);
    }
}

