/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.http;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.rpc.client.ClientTransport;
import com.sun.xml.rpc.client.ClientTransportException;
import com.sun.xml.rpc.client.StubPropertyConstants;
import com.sun.xml.rpc.client.http.CookieJar;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDBase64BinaryEncoder;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class HttpClientTransport
implements ClientTransport,
StubPropertyConstants {
    static Logger _logger = Logger.getLogger(HttpClientTransport.class.getName());
    public static final String HTTP_SOAPACTION_PROPERTY = "http.soap.action";
    private static final SimpleTypeEncoder base64Encoder = XSDBase64BinaryEncoder.getInstance();
    private static String LAST_ENDPOINT = "";
    private static boolean redirect = true;
    private static final int START_REDIRECT_COUNT = 3;
    private static int redirectCount = 3;
    private static boolean DEBUG;
    private MessageFactory _messageFactory;
    private OutputStream _logStream;

    public HttpClientTransport() {
        this(null);
    }

    public HttpClientTransport(OutputStream logStream) {
        try {
            this._messageFactory = MessageFactory.newInstance();
            this._logStream = logStream;
        }
        catch (Exception e) {
            throw new ClientTransportException("http.client.cannotCreateMessageFactory");
        }
    }

    public void invoke(String endpoint, SOAPMessageContext context) throws ClientTransportException {
        try {
            HttpURLConnection httpConnection = this.createHttpConnection(endpoint, context);
            this.setupContextForInvoke(context);
            CookieJar cookieJar = this.sendCookieAsNeeded(context, httpConnection);
            this.moveHeadersFromContextToConnection(context, httpConnection);
            if (DEBUG) {
                HttpClientTransport.checkMessageContentType(httpConnection.getRequestProperty("Content-Type"), false);
            }
            this.writeMessageToConnection(context, httpConnection);
            boolean isFailure = this.connectForResponse(httpConnection, context);
            int statusCode = httpConnection.getResponseCode();
            if (this.checkForRedirect(statusCode)) {
                this.redirectRequest(httpConnection, context);
                return;
            }
            MimeHeaders headers = this.collectResponseMimeHeaders(httpConnection);
            this.saveCookieAsNeeded(context, httpConnection, cookieJar);
            SOAPMessage response = null;
            try {
                response = this.readResponse(httpConnection, isFailure, headers);
            }
            catch (SOAPException e) {
                if (statusCode == 204 || isFailure && statusCode != 500) {
                    throw new ClientTransportException("http.status.code", new Object[]{new Integer(statusCode), httpConnection.getResponseMessage()});
                }
                throw e;
            }
            httpConnection = null;
            this.logResponseMessage(context, response);
            if (DEBUG) {
                HttpClientTransport.checkMessageContentType(headers.getHeader("Content-Type")[0], true);
            }
            context.setMessage(response);
        }
        catch (ClientTransportException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof Localizable) {
                throw new ClientTransportException("http.client.failed", (Localizable)((Object)e));
            }
            throw new ClientTransportException("http.client.failed", new LocalizableExceptionAdapter(e));
        }
    }

    public void invokeOneWay(String endpoint, SOAPMessageContext context) {
        try {
            HttpURLConnection httpConnection = this.createHttpConnection(endpoint, context);
            this.setupContextForInvoke(context);
            this.moveHeadersFromContextToConnection(context, httpConnection);
            this.writeMessageToConnection(context, httpConnection);
            this.forceMessageToBeSent(httpConnection, context);
        }
        catch (Exception e) {
            if (e instanceof Localizable) {
                throw new ClientTransportException("http.client.failed", (Localizable)((Object)e));
            }
            throw new ClientTransportException("http.client.failed", new LocalizableExceptionAdapter(e));
        }
    }

    protected void logResponseMessage(SOAPMessageContext context, SOAPMessage response) throws IOException, SOAPException {
        if (this._logStream != null) {
            String s = "Response\n";
            this._logStream.write(s.getBytes());
            s = "Http Status Code: " + context.getProperty("com.sun.xml.rpc.client.http.HTTPStatusCode") + "\n\n";
            this._logStream.write(s.getBytes());
            Iterator iter = response.getMimeHeaders().getAllHeaders();
            while (iter.hasNext()) {
                MimeHeader header = (MimeHeader)iter.next();
                s = header.getName() + ": " + header.getValue() + "\n";
                this._logStream.write(s.getBytes());
            }
            this._logStream.flush();
            response.writeTo(this._logStream);
            s = "******************\n\n";
            this._logStream.write(s.getBytes());
        }
    }

    protected SOAPMessage readResponse(HttpURLConnection httpConnection, boolean isFailure, MimeHeaders headers) throws IOException, SOAPException {
        InputStream contentIn = isFailure ? httpConnection.getErrorStream() : httpConnection.getInputStream();
        byte[] bytes = this.readFully(contentIn);
        int length = httpConnection.getContentLength() == -1 ? bytes.length : httpConnection.getContentLength();
        ByteInputStream in = new ByteInputStream(bytes, length);
        if (DEBUG && httpConnection.getContentType().indexOf("text/html") >= 0) {
            System.out.println("");
            for (int i = 0; i < length; ++i) {
                System.out.print((char)bytes[i]);
            }
            System.out.println("");
        }
        SOAPMessage response = this._messageFactory.createMessage(headers, (InputStream)in);
        contentIn.close();
        return response;
    }

    protected MimeHeaders collectResponseMimeHeaders(HttpURLConnection httpConnection) {
        String key;
        MimeHeaders headers = new MimeHeaders();
        int i = 1;
        while ((key = httpConnection.getHeaderFieldKey(i)) != null) {
            String value = httpConnection.getHeaderField(i);
            try {
                headers.addHeader(key, value);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            ++i;
        }
        return headers;
    }

    protected boolean connectForResponse(HttpURLConnection httpConnection, SOAPMessageContext context) throws IOException {
        httpConnection.connect();
        return this.checkResponseCode(httpConnection, context);
    }

    protected void forceMessageToBeSent(HttpURLConnection httpConnection, SOAPMessageContext context) throws IOException {
        try {
            httpConnection.connect();
            this.checkResponseCode(httpConnection, context);
            httpConnection.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean checkResponseCode(HttpURLConnection httpConnection, SOAPMessageContext context) throws IOException {
        boolean isFailure = false;
        try {
            int statusCode = httpConnection.getResponseCode();
            context.setProperty("com.sun.xml.rpc.client.http.HTTPStatusCode", Integer.toString(statusCode));
            if (httpConnection.getResponseCode() == 500) {
                isFailure = true;
            } else {
                if (httpConnection.getResponseCode() == 401) {
                    throw new ClientTransportException("http.client.unauthorized", httpConnection.getResponseMessage());
                }
                if (httpConnection.getResponseCode() == 404) {
                    throw new ClientTransportException("http.not.found", httpConnection.getResponseMessage());
                }
                if (statusCode == 302 || statusCode == 301) {
                    isFailure = true;
                    if (!redirect || redirectCount <= 0) {
                        throw new ClientTransportException("http.status.code", new Object[]{new Integer(statusCode), this.getStatusMessage(httpConnection)});
                    }
                } else {
                    if (statusCode < 200 || statusCode >= 303 && statusCode < 500) {
                        throw new ClientTransportException("http.status.code", new Object[]{new Integer(statusCode), this.getStatusMessage(httpConnection)});
                    }
                    if (statusCode >= 500) {
                        isFailure = true;
                    }
                }
            }
        }
        catch (IOException e) {
            if (httpConnection.getResponseCode() == 500) {
                isFailure = true;
            }
            throw e;
        }
        return isFailure;
    }

    protected String getStatusMessage(HttpURLConnection httpConnection) throws IOException {
        String location;
        int statusCode = httpConnection.getResponseCode();
        String message = httpConnection.getResponseMessage();
        if ((statusCode == 201 || statusCode >= 300 && statusCode != 304 && statusCode < 400) && (location = httpConnection.getHeaderField("Location")) != null) {
            message = message + " - Location: " + location;
        }
        return message;
    }

    protected void logRequestMessage(SOAPMessageContext context) throws IOException, SOAPException {
        if (this._logStream != null) {
            String s = "******************\nRequest\n";
            this._logStream.write(s.getBytes());
            Iterator iter = context.getMessage().getMimeHeaders().getAllHeaders();
            while (iter.hasNext()) {
                MimeHeader header = (MimeHeader)iter.next();
                s = header.getName() + ": " + header.getValue() + "\n";
                this._logStream.write(s.getBytes());
            }
            this._logStream.flush();
            context.getMessage().writeTo(this._logStream);
            s = "\n";
            this._logStream.write(s.getBytes());
            this._logStream.flush();
        }
    }

    protected void writeMessageToConnection(SOAPMessageContext context, final HttpURLConnection httpConnection) throws IOException, SOAPException {
        OutputStream contentOut = (OutputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return httpConnection.getOutputStream();
                }
                catch (IOException e) {
                    _logger.log(Level.SEVERE, "cannot get httpConnection outputstream", e);
                    return null;
                }
            }
        });
        context.getMessage().writeTo(contentOut);
        contentOut.flush();
        contentOut.close();
        this.logRequestMessage(context);
    }

    protected void moveHeadersFromContextToConnection(SOAPMessageContext context, HttpURLConnection httpConnection) {
        Iterator iter = context.getMessage().getMimeHeaders().getAllHeaders();
        while (iter.hasNext()) {
            MimeHeader header = (MimeHeader)iter.next();
            httpConnection.setRequestProperty(header.getName(), header.getValue());
        }
    }

    protected CookieJar sendCookieAsNeeded(SOAPMessageContext context, HttpURLConnection httpConnection) {
        boolean shouldMaintainSession;
        Boolean shouldMaintainSessionProperty = (Boolean)context.getProperty("javax.xml.rpc.session.maintain");
        boolean bl = shouldMaintainSession = shouldMaintainSessionProperty == null ? false : shouldMaintainSessionProperty;
        if (shouldMaintainSession) {
            CookieJar cookieJar = (CookieJar)context.getProperty("com.sun.xml.rpc.client.http.CookieJar");
            if (cookieJar == null) {
                cookieJar = new CookieJar();
            }
            cookieJar.applyRelevantCookies(httpConnection);
            return cookieJar;
        }
        return null;
    }

    protected void saveCookieAsNeeded(SOAPMessageContext context, HttpURLConnection httpConnection, CookieJar cookieJar) {
        if (cookieJar != null) {
            cookieJar.recordAnyCookies(httpConnection);
            context.setProperty("com.sun.xml.rpc.client.http.CookieJar", cookieJar);
        }
    }

    protected void setupContextForInvoke(SOAPMessageContext context) throws SOAPException, Exception {
        String proxyUser;
        boolean proxySet;
        String soapAction;
        if (context.getMessage().saveRequired()) {
            context.getMessage().saveChanges();
        }
        if ((soapAction = (String)context.getProperty(HTTP_SOAPACTION_PROPERTY)) == null) {
            context.getMessage().getMimeHeaders().setHeader("SOAPAction", "\"\"");
        } else {
            context.getMessage().getMimeHeaders().setHeader("SOAPAction", "\"" + soapAction + "\"");
        }
        String credentials = (String)context.getProperty("javax.xml.rpc.security.auth.username");
        if (credentials != null) {
            credentials = credentials + ":" + (String)context.getProperty("javax.xml.rpc.security.auth.password");
            credentials = base64Encoder.objectToString(credentials.getBytes("UTF-8"), null);
            context.getMessage().getMimeHeaders().setHeader("Authorization", "Basic " + credentials);
        }
        if ((proxySet = Boolean.parseBoolean((String)context.getProperty("com.sun.xml.rpc.client.http.proxySet"))) && (proxyUser = (String)context.getProperty("com.sun.xml.rpc.client.http.proxyUserName")) != null && proxyUser.trim().length() > 0) {
            String proxyCredentials = new StringBuffer(proxyUser).append(":").append((String)context.getProperty("com.sun.xml.rpc.client.http.proxyUserPassword")).toString();
            proxyCredentials = base64Encoder.objectToString(proxyCredentials.getBytes(), null);
            context.getMessage().getMimeHeaders().setHeader("Proxy-Authorization", "Basic " + proxyCredentials);
        }
    }

    protected HttpURLConnection createHttpConnection(String endpoint, SOAPMessageContext context) throws IOException {
        String redirectProperty;
        boolean verification = false;
        String verificationProperty = (String)context.getProperty("com.sun.xml.rpc.client.http.HostnameVerificationProperty");
        if (verificationProperty != null && verificationProperty.equalsIgnoreCase("true")) {
            verification = true;
        }
        if ((redirectProperty = (String)context.getProperty("com.sun.xml.rpc.client.http.RedirectRequestProperty")) != null && redirectProperty.equalsIgnoreCase("false")) {
            redirect = false;
        }
        this.checkEndpoints(endpoint);
        HttpURLConnection httpConnection = this.createConnection(endpoint, context);
        if (!verification && httpConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)httpConnection).setHostnameVerifier(new HttpClientVerifier());
        }
        httpConnection.setAllowUserInteraction(true);
        httpConnection.setDoOutput(true);
        httpConnection.setDoInput(true);
        httpConnection.setRequestMethod("POST");
        httpConnection.setRequestProperty("Content-Type", "text/xml");
        return httpConnection;
    }

    private HttpURLConnection createConnection(String endpoint, SOAPMessageContext context) throws IOException {
        boolean proxySet = Boolean.parseBoolean((String)context.getProperty("com.sun.xml.rpc.client.http.proxySet"));
        if (proxySet) {
            String proxyHost = ((String)context.getProperty("com.sun.xml.rpc.client.http.proxyHost")).trim();
            String proxyPort = ((String)context.getProperty("com.sun.xml.rpc.client.http.proxyPort")).trim();
            if (proxyHost != null && proxyHost.length() > 0 && proxyPort != null && proxyPort.length() > 0) {
                InetSocketAddress address = new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort));
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                return (HttpURLConnection)new URL(endpoint).openConnection(proxy);
            }
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "HTTP Proxy is enabled on the stub, but proxy host/port values not set correctly on the stub; opening connection without the proxy.");
            }
        }
        return (HttpURLConnection)new URL(endpoint).openConnection();
    }

    private void redirectRequest(HttpURLConnection httpConnection, SOAPMessageContext context) {
        String redirectEndpoint = httpConnection.getHeaderField("Location");
        if (redirectEndpoint != null) {
            httpConnection.disconnect();
            this.invoke(redirectEndpoint, context);
        } else {
            System.out.println("redirection Failed");
        }
    }

    private boolean checkForRedirect(int statusCode) {
        return (statusCode == 301 || statusCode == 302) && redirect && redirectCount-- > 0;
    }

    private void checkEndpoints(String currentEndpoint) {
        if (!LAST_ENDPOINT.equalsIgnoreCase(currentEndpoint)) {
            redirectCount = 3;
            LAST_ENDPOINT = currentEndpoint;
        }
    }

    private byte[] readFully(InputStream istream) throws IOException {
        if (istream == null) {
            return new byte[0];
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        byte[] ret = bout.toByteArray();
        return ret;
    }

    private static void checkMessageContentType(String contentType, boolean response) {
        if (contentType.indexOf("text/html") >= 0) {
            System.out.println("##### WARNING " + (response ? "RESPONSE" : "REQUEST") + " CONTENT TYPE INCLUDES 'text/html'");
            return;
        }
        System.out.println("##### CHECKING " + (response ? "RESPONSE" : "REQUEST") + " CONTENT TYPE '" + contentType + "'");
        String negotiation = System.getProperty("com.sun.xml.rpc.client.ContentNegotiation", "none").intern();
        if (negotiation == "none" ? contentType.indexOf("text/xml") < 0 : (negotiation == "optimistic" ? contentType.indexOf("application/fastinfoset") < 0 : negotiation == "pessimistic" && response && contentType.indexOf("application/fastinfoset") < 0)) {
            throw new RuntimeException("Invalid content type '" + contentType + "' in " + (response ? "response" : "request") + " with conneg set to '" + negotiation + "'.");
        }
    }

    static {
        String value = System.getProperty("debug", "false");
        DEBUG = value.equals("on") || value.equals("true");
    }

    static class HttpClientVerifier
    implements HostnameVerifier {
        HttpClientVerifier() {
        }

        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }
}

