/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.dump;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.dump.MessageDumper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WrapperDumpTube
implements Tube {
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);
    private final MessageDumper messageDumper;
    private final int tubeId;
    private final boolean logBefore;
    private final boolean logAfter;
    private final Tube wrappedTube;

    public WrapperDumpTube(boolean logBefore, boolean logAfter, Level loggingLevel, Tube wrappedTube) {
        String wrappedTubeName = wrappedTube.getClass().getName();
        this.messageDumper = new MessageDumper(wrappedTubeName, Logger.getLogger(wrappedTubeName), loggingLevel);
        this.tubeId = ID_GENERATOR.incrementAndGet();
        this.logBefore = logBefore;
        this.logAfter = logAfter;
        this.wrappedTube = wrappedTube;
    }

    private WrapperDumpTube(WrapperDumpTube that, TubeCloner cloner) {
        cloner.add(that, this);
        this.messageDumper = that.messageDumper;
        this.tubeId = ID_GENERATOR.incrementAndGet();
        this.logBefore = that.logBefore;
        this.logAfter = that.logAfter;
        this.wrappedTube = cloner.copy(that.wrappedTube);
    }

    public WrapperDumpTube copy(TubeCloner cloner) {
        return new WrapperDumpTube(this, cloner);
    }

    public NextAction processRequest(Packet request) {
        if (this.logBefore && this.messageDumper.isLoggable()) {
            this.messageDumper.dump(MessageDumper.MessageType.Request, MessageDumper.ProcessingState.Received, this.messageDumper.convertToString(request), this.tubeId, Fiber.current().owner.id);
        }
        NextAction next = this.wrappedTube.processRequest(request);
        if (this.logAfter && this.messageDumper.isLoggable()) {
            this.messageDumper.dump(MessageDumper.MessageType.Request, MessageDumper.ProcessingState.Processed, this.messageDumper.convertToString(next.getPacket()), this.tubeId, Fiber.current().owner.id);
            if (next.getThrowable() != null) {
                this.messageDumper.dump(MessageDumper.MessageType.Request, MessageDumper.ProcessingState.Processed, this.messageDumper.convertToString(next.getThrowable()), this.tubeId, Fiber.current().owner.id);
            }
        }
        return next;
    }

    public NextAction processResponse(Packet response) {
        if (this.logAfter && this.messageDumper.isLoggable()) {
            this.messageDumper.dump(MessageDumper.MessageType.Request, MessageDumper.ProcessingState.Received, this.messageDumper.convertToString(response), this.tubeId, Fiber.current().owner.id);
        }
        NextAction next = this.wrappedTube.processResponse(response);
        if (this.logBefore && this.messageDumper.isLoggable()) {
            this.messageDumper.dump(MessageDumper.MessageType.Request, MessageDumper.ProcessingState.Processed, this.messageDumper.convertToString(next.getPacket()), this.tubeId, Fiber.current().owner.id);
            if (next.getThrowable() != null) {
                this.messageDumper.dump(MessageDumper.MessageType.Request, MessageDumper.ProcessingState.Processed, this.messageDumper.convertToString(next.getThrowable()), this.tubeId, Fiber.current().owner.id);
            }
        }
        return next;
    }

    public NextAction processException(Throwable t) {
        if (this.logAfter && this.messageDumper.isLoggable()) {
            this.messageDumper.dump(MessageDumper.MessageType.Request, MessageDumper.ProcessingState.Received, this.messageDumper.convertToString(t), this.tubeId, Fiber.current().owner.id);
        }
        NextAction next = this.wrappedTube.processException(t);
        if (this.logBefore && this.messageDumper.isLoggable()) {
            if (next.getPacket() != null) {
                this.messageDumper.dump(MessageDumper.MessageType.Request, MessageDumper.ProcessingState.Processed, this.messageDumper.convertToString(next.getPacket()), this.tubeId, Fiber.current().owner.id);
            }
            this.messageDumper.dump(MessageDumper.MessageType.Request, MessageDumper.ProcessingState.Processed, this.messageDumper.convertToString(next.getThrowable()), this.tubeId, Fiber.current().owner.id);
        }
        return next;
    }

    public void preDestroy() {
        this.wrappedTube.preDestroy();
    }
}

