/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.RxConfiguration;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.RmVersion;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.AcceptType;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.CloseSequenceElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.CloseSequenceResponseElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.CreateSequenceElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.CreateSequenceResponseElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.Identifier;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.OfferType;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.TerminateSequenceElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.TerminateSequenceResponseElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.UsesSequenceSTR;
import com.sun.xml.ws.rx.rm.runtime.ClientSession;
import com.sun.xml.ws.rx.rm.runtime.PacketAdapter;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import java.util.Calendar;

final class Rm11ClientSession
extends ClientSession {
    private static final Logger LOGGER = Logger.getLogger(Rm11ClientSession.class);

    Rm11ClientSession(RxConfiguration configuration, WSEndpointReference rmsEndpointReference, Communicator communicator) {
        super(configuration, rmsEndpointReference, communicator);
    }

    void openRmSession(String offerInboundSequenceId, SecurityTokenReferenceType strType) throws RxRuntimeException {
        PacketAdapter responseAdapter;
        CreateSequenceElement csElement = new CreateSequenceElement();
        csElement.setAcksTo(this.rmSourceReference.toSpec());
        if (offerInboundSequenceId != null) {
            Identifier offerIdentifier = new Identifier();
            offerIdentifier.setValue(offerInboundSequenceId);
            OfferType offer = new OfferType();
            offer.setIdentifier(offerIdentifier);
            offer.setEndpoint(csElement.getAcksTo());
            csElement.setOffer(offer);
        }
        if (strType != null) {
            csElement.setSecurityTokenReference(strType);
        }
        PacketAdapter requestAdapter = PacketAdapter.getInstance(this.configuration, this.communicator.createEmptyRequestPacket(true));
        requestAdapter.setRequestMessage(csElement, RmVersion.WSRM200702.createSequenceAction);
        if (strType != null) {
            UsesSequenceSTR usesSequenceSTR = new UsesSequenceSTR();
            usesSequenceSTR.getOtherAttributes().put(this.communicator.soapMustUnderstandAttributeName, "true");
            requestAdapter.appendHeader(usesSequenceSTR);
        }
        if (!(responseAdapter = PacketAdapter.getInstance(this.configuration, this.communicator.send(requestAdapter.getPacket()))).containsMessage()) {
            throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSRM_1114_NULL_RESPONSE_ON_PROTOCOL_MESSAGE_REQUEST("CreateSequence")));
        }
        if (responseAdapter.isFault()) {
            throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSRM_1115_PROTOCOL_MESSAGE_REQUEST_REFUSED("CreateSequence")));
        }
        CreateSequenceResponseElement csrElement = (CreateSequenceResponseElement)responseAdapter.unmarshallMessage();
        responseAdapter.getPacket();
        this.outboundSequenceId = csrElement.getIdentifier().getValue();
        long expirationTime = -1L;
        if (csrElement.getExpires() != null && !"PT0S".equals(csrElement.getExpires().getValue().toString())) {
            expirationTime = csrElement.getExpires().getValue().getTimeInMillis(Calendar.getInstance()) + System.currentTimeMillis();
        }
        this.sequenceManager.createOutboundSequence(this.outboundSequenceId, strType != null ? strType.getId() : null, expirationTime);
        if (offerInboundSequenceId != null) {
            AcceptType accept = csrElement.getAccept();
            if (accept == null || accept.getAcksTo() == null) {
                throw new RxRuntimeException(LocalizationMessages.WSRM_1116_ACKS_TO_NOT_EQUAL_TO_ENDPOINT_DESTINATION(null, this.communicator.getDestinationAddress()));
            }
            if (!this.communicator.getDestinationAddress().getURI().toString().equals(new WSEndpointReference(accept.getAcksTo()).getAddress())) {
                throw new RxRuntimeException(LocalizationMessages.WSRM_1116_ACKS_TO_NOT_EQUAL_TO_ENDPOINT_DESTINATION(accept.getAcksTo().toString(), this.communicator.getDestinationAddress()));
            }
            this.inboundSequenceId = offerInboundSequenceId;
            this.sequenceManager.createInboundSequence(this.inboundSequenceId, strType != null ? strType.getId() : null, -1L);
        }
    }

    void closeOutboundSequence() {
        PacketAdapter requestAdapter = PacketAdapter.getInstance(this.configuration, this.communicator.createEmptyRequestPacket(true));
        requestAdapter.setRequestMessage(new CloseSequenceElement(this.outboundSequenceId, this.sequenceManager.getSequence(this.outboundSequenceId).getLastMessageId()), RmVersion.WSRM200702.closeSequenceAction);
        if (this.inboundSequenceId != null) {
            requestAdapter.appendSequenceAcknowledgementHeader(this.sequenceManager.getSequence(this.inboundSequenceId));
        }
        this.communicator.sendAsync(requestAdapter.getPacket(), new Fiber.CompletionCallback(){

            public void onCompletion(Packet responsePacket) {
                PacketAdapter responseAdapter = PacketAdapter.getInstance(Rm11ClientSession.this.configuration, responsePacket);
                if (!responseAdapter.containsMessage()) {
                    LOGGER.warning(LocalizationMessages.WSRM_1114_NULL_RESPONSE_ON_PROTOCOL_MESSAGE_REQUEST("CloseSequence"));
                }
                Rm11ClientSession.this.processInboundMessageHeaders(responseAdapter, false);
                if (responseAdapter.isFault()) {
                    LOGGER.warning(LocalizationMessages.WSRM_1115_PROTOCOL_MESSAGE_REQUEST_REFUSED("CloseSequence"));
                }
                CloseSequenceResponseElement csrElement = (CloseSequenceResponseElement)responseAdapter.unmarshallMessage();
                responseAdapter.getPacket();
                if (!Rm11ClientSession.this.outboundSequenceId.equals(csrElement.getIdentifier().getValue())) {
                    LOGGER.warning(LocalizationMessages.WSRM_1119_UNEXPECTED_SEQUENCE_ID_IN_CLOSE_SR(csrElement.getIdentifier().getValue(), Rm11ClientSession.this.outboundSequenceId));
                }
            }

            public void onCompletion(Throwable error) {
                LOGGER.warning("Unexpected exception while trying to close sequence", error);
            }
        });
    }

    void terminateOutboundSequence() {
        PacketAdapter requestAdapter = PacketAdapter.getInstance(this.configuration, this.communicator.createEmptyRequestPacket(true));
        requestAdapter.setRequestMessage(new TerminateSequenceElement(this.outboundSequenceId, this.sequenceManager.getSequence(this.outboundSequenceId).getLastMessageId()), RmVersion.WSRM200702.terminateSequenceAction);
        this.communicator.sendAsync(requestAdapter.getPacket(), new Fiber.CompletionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompletion(Packet responsePacket) {
                PacketAdapter responseAdapter = null;
                try {
                    TerminateSequenceResponseElement tsrElement;
                    String responseAction;
                    responseAdapter = PacketAdapter.getInstance(Rm11ClientSession.this.configuration, responsePacket);
                    if (!responseAdapter.containsMessage()) {
                        if (Rm11ClientSession.this.inboundSequenceId != null) {
                            LOGGER.warning(LocalizationMessages.WSRM_1114_NULL_RESPONSE_ON_PROTOCOL_MESSAGE_REQUEST("TerminateSequence"));
                        } else {
                            return;
                        }
                    }
                    Rm11ClientSession.this.processInboundMessageHeaders(responseAdapter, false);
                    if (responseAdapter.isFault()) {
                        LOGGER.warning(LocalizationMessages.WSRM_1115_PROTOCOL_MESSAGE_REQUEST_REFUSED("TerminateSequence"));
                    }
                    if (RmVersion.WSRM200702.terminateSequenceAction.equals(responseAction = responseAdapter.getWsaAction())) {
                        TerminateSequenceElement tsElement = (TerminateSequenceElement)responseAdapter.unmarshallMessage();
                        Rm11ClientSession.this.sequenceManager.terminateSequence(tsElement.getIdentifier().getValue());
                    } else if (RmVersion.WSRM200702.terminateSequenceResponseAction.equals(responseAction) && !Rm11ClientSession.this.outboundSequenceId.equals((tsrElement = (TerminateSequenceResponseElement)responseAdapter.unmarshallMessage()).getIdentifier().getValue())) {
                        LOGGER.warning(LocalizationMessages.WSRM_1117_UNEXPECTED_SEQUENCE_ID_IN_TERMINATE_SR(tsrElement.getIdentifier().getValue(), Rm11ClientSession.this.outboundSequenceId));
                    }
                }
                finally {
                    if (responseAdapter != null) {
                        responseAdapter.consume();
                    }
                }
            }

            public void onCompletion(Throwable error) {
                LOGGER.warning("Unexpected exception while trying to terminate sequence", error);
            }
        });
    }
}

