/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming.processor;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.logging.impl.opt.LogStringsMessages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jvnet.staxex.Base64Data;
import org.jvnet.staxex.XMLStreamReaderEx;

public class BSTProcessor
implements StreamFilter {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt", "com.sun.xml.wss.logging.impl.opt.LogStrings");
    private byte[] bstValue = null;
    private X509Certificate cert = null;

    public byte[] getValue() {
        return this.bstValue;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public boolean accept(XMLStreamReader reader) {
        if (reader.getEventType() == 4) {
            if (reader instanceof XMLStreamReaderEx) {
                try {
                    CharSequence data = ((XMLStreamReaderEx)reader).getPCDATA();
                    if (data instanceof Base64Data) {
                        Base64Data binaryData = (Base64Data)data;
                        this.buildCertificate(binaryData.getInputStream());
                        return true;
                    }
                }
                catch (XMLStreamException ex) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1603_ERROR_READING_STREAM(ex));
                    throw new XWSSecurityRuntimeException(LogStringsMessages.WSS_1603_ERROR_READING_STREAM(ex));
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1603_ERROR_READING_STREAM(ex));
                    throw new XWSSecurityRuntimeException(LogStringsMessages.WSS_1603_ERROR_READING_STREAM(ex));
                }
            }
            try {
                this.bstValue = Base64.decode(reader.getText());
                this.buildCertificate(new ByteArrayInputStream(this.bstValue));
            }
            catch (Base64DecodingException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1604_ERROR_DECODING_BASE_64_DATA(ex));
                throw new XWSSecurityRuntimeException(LogStringsMessages.WSS_1604_ERROR_DECODING_BASE_64_DATA(ex));
            }
        }
        return true;
    }

    private void buildCertificate(InputStream certValue) {
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            this.cert = (X509Certificate)certFact.generateCertificate(certValue);
        }
        catch (CertificateException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1605_ERROR_GENERATING_CERTIFICATE(ex));
            throw new XWSSecurityRuntimeException(LogStringsMessages.WSS_1605_ERROR_GENERATING_CERTIFICATE(ex));
        }
    }
}

