/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.common;

import com.sun.xml.ws.tx.common.LocalizationMessages;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.webservice.member.at.CoordinatorPortType;
import com.sun.xml.ws.tx.webservice.member.at.ParticipantPortType;
import com.sun.xml.ws.tx.webservice.member.coord.RegistrationCoordinatorPortType;
import com.sun.xml.ws.tx.webservice.member.coord.RegistrationPortTypeRPC;
import com.sun.xml.ws.tx.webservice.member.coord.RegistrationRequesterPortType;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.logging.Level;

public class AddressManager {
    private static final TxLogger logger = TxLogger.getLogger(AddressManager.class);
    private static String hostAndPort;
    private static String secureHostAndPort;
    private static final String context = "/__wstx-services";
    private static String preferredScheme;
    private static String httpPortOverride;
    private static String httpsPortOverride;
    private static String hostNameOverride;

    private AddressManager() {
    }

    public static URI getPreferredAddress(Class portType) {
        return "http".equals(preferredScheme) ? AddressManager.getAddress(portType, false) : AddressManager.getAddress(portType, true);
    }

    public static URI getAddress(Class portType, boolean secure) {
        StringBuilder addr = new StringBuilder();
        if (secure) {
            addr.append("https://").append(secureHostAndPort).append(context);
        } else {
            addr.append("http://").append(hostAndPort).append(context);
        }
        if (portType == RegistrationCoordinatorPortType.class) {
            addr.append("/wscoor/coordinator/register");
        } else if (portType == RegistrationRequesterPortType.class) {
            addr.append("/wscoor/coordinator/registerResponse");
        } else if (portType == RegistrationPortTypeRPC.class) {
            addr.append("/wscoor/coordinator/synchRegister");
        } else if (portType == CoordinatorPortType.class) {
            addr.append("/wsat/coordinator");
        } else if (portType == ParticipantPortType.class) {
            addr.append("/wsat/2pc");
        } else {
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(addr.toString());
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        return uri;
    }

    private static void callGetDefaultVirtualServerHostAndPort() {
        try {
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("static initializer", "getting host and port from AS...");
            }
            Class<?> c = Class.forName("com.sun.enterprise.webservice.WsTxUtils");
            Object instance = c.newInstance();
            Method m = c.getMethod("getDefaultVirtualServerHostAndPort", Boolean.TYPE);
            hostAndPort = (String)m.invoke(instance, false);
            secureHostAndPort = (String)m.invoke(instance, true);
            if (secureHostAndPort == null || hostAndPort == null) {
                AddressManager.fallback();
                logger.warning("getAddress", LocalizationMessages.HOST_AND_PORT_LOOKUP_FAILURE_2015(preferredScheme + "://" + secureHostAndPort));
            }
            if (hostNameOverride != null) {
                hostAndPort = hostNameOverride + hostAndPort.substring(hostAndPort.indexOf(58), hostAndPort.length());
                secureHostAndPort = hostNameOverride + secureHostAndPort.substring(secureHostAndPort.indexOf(58), secureHostAndPort.length());
                logger.finest("static initializer", "manual hostname overridden to: " + hostNameOverride);
            }
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("static initializer", "hostAndPort: " + hostAndPort);
                logger.finest("static initializer", "secureHostAndPort: " + secureHostAndPort);
            }
        }
        catch (Throwable t) {
            AddressManager.fallback();
            logger.info("static initializer", LocalizationMessages.HOST_AND_PORT_LOOKUP_FAILURE_2015(preferredScheme + "://" + secureHostAndPort));
            logger.finest("static initializer", LocalizationMessages.HOST_AND_PORT_LOOKUP_FAILURE_2015(preferredScheme + "://" + secureHostAndPort), t);
        }
    }

    private static void calculateHostAndPortOverrides() {
        String hostName = hostAndPort.substring(0, hostAndPort.indexOf(58));
        if ("http".equals(preferredScheme)) {
            if (httpPortOverride != null) {
                if (logger.isLogging(Level.FINEST)) {
                    logger.finest("static initializer", "http port overriden to: " + httpPortOverride);
                }
                hostAndPort = hostName + ':' + httpPortOverride;
            }
        } else if ("https".equals(preferredScheme)) {
            if (httpsPortOverride != null) {
                if (logger.isLogging(Level.FINEST)) {
                    logger.finest("static initializer", "https port overriden to: " + httpsPortOverride);
                }
                secureHostAndPort = hostName + ':' + httpsPortOverride;
            }
        } else {
            logger.warning("static initializer", LocalizationMessages.PREFERRED_SCHEME_ERROR_2016(preferredScheme));
            preferredScheme = "https";
            if (httpsPortOverride != null) {
                if (logger.isLogging(Level.FINEST)) {
                    logger.finest("static initializer", "https port overriden to: " + httpsPortOverride);
                }
                secureHostAndPort = hostName + ':' + httpsPortOverride;
            }
        }
    }

    private static void fallback() {
        preferredScheme = "https";
        String hostName = AddressManager.getServiceHostName();
        hostAndPort = hostName + ":8080";
        secureHostAndPort = hostName + ":8181";
    }

    private static String getServiceHostName() {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            logger.warning("getServiceHostName", LocalizationMessages.FQDN_LOOKUP_FAILURE_2012(), ex);
            try {
                hostname = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                logger.warning("getServiceHostName", LocalizationMessages.FQDN_LOOKUP_FAILURE_2012(), e);
            }
        }
        return hostname;
    }

    static {
        preferredScheme = System.getProperty("com.sun.xml.ws.tx.preferredScheme", "https");
        httpPortOverride = System.getProperty("com.sun.xml.ws.tx.httpPortOverride", null);
        httpsPortOverride = System.getProperty("com.sun.xml.ws.tx.httpsPortOverride", null);
        hostNameOverride = System.getProperty("com.sun.xml.ws.tx.hostNameOverride", null);
        AddressManager.callGetDefaultVirtualServerHostAndPort();
        if (preferredScheme.equals("http") && logger.isLogging(Level.FINEST)) {
            logger.fine("static initializer", "preferred scheme has been set to: " + preferredScheme);
        }
        AddressManager.calculateHostAndPortOverrides();
    }
}

