/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl;

import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLBoundPortType;
import org.jvnet.wom.api.WSDLDefinitions;
import org.jvnet.wom.api.WSDLMessage;
import org.jvnet.wom.api.WSDLPort;
import org.jvnet.wom.api.WSDLPortType;
import org.jvnet.wom.api.WSDLService;
import org.jvnet.wom.api.WSDLSet;
import org.jvnet.wom.api.WSDLTypes;
import org.jvnet.wom.api.WSDLVisitor;
import org.jvnet.wom.impl.WSDLBoundPortTypeImpl;
import org.jvnet.wom.impl.WSDLMessageImpl;
import org.jvnet.wom.impl.WSDLPortTypeImpl;
import org.jvnet.wom.impl.WSDLServiceImpl;
import org.jvnet.wom.impl.parser.WSDLDocumentImpl;
import org.jvnet.wom.impl.parser.WSDLSetImpl;
import org.jvnet.wom.impl.parser.WSDLTypesImpl;
import org.jvnet.wom.impl.util.QNameMap;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLDefinitionsImpl
extends WSDLDefinitions {
    private final WSDLSetImpl parent;
    private String documentation = "";
    private final QNameMap<WSDLMessage> messages = new QNameMap();
    private final QNameMap<WSDLPortType> portTypes = new QNameMap();
    private final QNameMap<WSDLBoundPortType> bindings = new QNameMap();
    private final QNameMap<WSDLService> services = new QNameMap();
    private WSDLTypesImpl types;

    public WSDLDefinitionsImpl(WSDLSetImpl parent, Locator locator, QName name) {
        super(locator, name);
        this.parent = parent;
    }

    @Override
    public String getTargetNamespace() {
        return this.getName().getNamespaceURI();
    }

    @Override
    public WSDLPortType getPortType(QName name) {
        return this.portTypes.get(name);
    }

    public void addPortType(WSDLPortTypeImpl portType) {
        this.portTypes.put(portType.getName(), portType);
    }

    @Override
    public WSDLBoundPortType getBinding(QName name) {
        return this.bindings.get(name);
    }

    public void addBoundPortType(WSDLBoundPortTypeImpl binding) {
        this.bindings.put(binding.getName(), binding);
    }

    @Override
    public WSDLBoundPortType getBinding(QName serviceName, QName portName) {
        WSDLService service = this.services.get(serviceName);
        if (service == null) {
            return null;
        }
        WSDLPort port = service.get(portName);
        return port.getBinding();
    }

    public void addService(WSDLServiceImpl service) {
        this.services.put(service.getName(), service);
    }

    @Override
    public WSDLService getService(QName name) {
        return this.services.get(name);
    }

    @Override
    public WSDLMessage getMessage(QName name) {
        return this.messages.get(name);
    }

    @Override
    public Iterable<WSDLMessage> getMessages() {
        return this.messages.values();
    }

    @Override
    public Iterable<WSDLPortType> getPortTypes() {
        return this.portTypes.values();
    }

    @Override
    public Iterable<WSDLBoundPortType> getBindings() {
        return this.bindings.values();
    }

    @Override
    public Iterable<WSDLService> getServices() {
        return this.services.values();
    }

    @Override
    public WSDLTypes getWSDLTypes() {
        return this.types;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void addMessage(WSDLMessageImpl message) {
        this.messages.put(message.getName(), message);
    }

    public void setOwnerDocument(WSDLDocumentImpl owner) {
        this.setOwnerWSDLDocument(owner);
    }

    @Override
    public <V, P> V visit(WSDLVisitor<V, P> visitor, P param) {
        return visitor.definitions(this, param);
    }

    public void setWSDLTypes(WSDLTypesImpl wsdlTypes) {
        this.types = wsdlTypes;
    }

    @Override
    public WSDLSet getRoot() {
        return this.parent;
    }
}

