/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.extension.wsdl11.soap;

import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLExtension;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP11Constants;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP12Constants;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAPBody;
import org.jvnet.wom.impl.extension.Messages;
import org.jvnet.wom.impl.extension.wsdl11.AbstractWSDLExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPFaultImpl;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPFaultExtensionHandler
extends AbstractWSDLExtensionHandler {
    SOAPFaultImpl fault;
    private final ContentHandler contentHandler = new SOAPFaultCH();
    private final QName[] names = new QName[]{SOAP11Constants.SOAPFAULT_NAME, SOAP12Constants.SOAPFAULT_NAME};

    public SOAPFaultExtensionHandler(ErrorHandler errorHandler, EntityResolver entityResolver) {
        super(errorHandler, entityResolver);
    }

    @Override
    public Collection<WSDLExtension> getExtensions() {
        return Collections.singleton(this.fault);
    }

    @Override
    protected QName[] getExtensionNames() {
        return this.names;
    }

    @Override
    public Collection<WSDLExtension> parseAttribute(Attributes atts) {
        return null;
    }

    @Override
    public ContentHandler getContentHandlerFor(String nsUri, String localName) {
        if (this.canHandle(nsUri, localName)) {
            return this.contentHandler;
        }
        return null;
    }

    private class SOAPFaultCH
    extends AbstractWSDLExtensionHandler.WSDLExtensibilityContentHandler {
        private SOAPFaultCH() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (!SOAPFaultExtensionHandler.this.canHandle(uri, localName)) {
                return;
            }
            String encodingStyleAtt = atts.getValue("encodingStyle");
            String[] encodingStyle = null;
            if (encodingStyleAtt != null) {
                encodingStyle = encodingStyleAtt.split("\\s");
            }
            String namespace = atts.getValue("namespace");
            String useatt = XmlUtil.fixNull(atts.getValue("use")).trim();
            SOAPBody.Use use = SOAPBody.Use.literal;
            if (useatt.equals("encoded")) {
                use = SOAPBody.Use.encoded;
            } else if (!useatt.equals("literal")) {
                SOAPFaultExtensionHandler.this.errorHandler.error(new SAXParseException(Messages.format("invalid.attr", "use", useatt, "literal or encoded"), this.locator));
            }
            String name = atts.getValue("name");
            if (name == null) {
                SOAPFaultExtensionHandler.this.errorHandler.error(new SAXParseException(Messages.format("missing.attr", "name", "soap:fault"), this.locator));
            }
            SOAPFaultExtensionHandler.this.fault = new SOAPFaultImpl(new QName(uri, localName));
            SOAPFaultExtensionHandler.this.fault.setEncodingStyle(encodingStyle);
            SOAPFaultExtensionHandler.this.fault.setNamespace(namespace);
            SOAPFaultExtensionHandler.this.fault.setName(name);
            SOAPFaultExtensionHandler.this.fault.setUse(use);
        }
    }
}

