/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.ace;

import com.wewebu.ooa.OwActionObserver;
import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.OwOAInstallError;
import com.wewebu.ooa.process.OwProcessStreamSubject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OwBatchScript {
    private String[] parameters;
    private String absoluteBatchPath;
    private File workigDir;
    private String logId;

    public OwBatchScript(String logId_p, File workigDir_p, String absoluteBatchPath_p, String ... parameters_p) {
        this.parameters = parameters_p;
        this.absoluteBatchPath = absoluteBatchPath_p;
        this.workigDir = workigDir_p;
        this.logId = logId_p;
    }

    protected void run(OwActionObserver observer_p) throws OwOAException {
        try {
            Runtime runtime = Runtime.getRuntime();
            String command = this.absoluteBatchPath;
            for (int i = 0; i < this.parameters.length; ++i) {
                command = command + " " + this.parameters[i];
            }
            Process process = runtime.exec(command, null, this.workigDir);
            OutputStream inStream = process.getOutputStream();
            inStream.close();
            InputStream outStream = process.getInputStream();
            InputStream errStream = process.getErrorStream();
            OwProcessStreamSubject outSubject = new OwProcessStreamSubject(outStream, observer_p, this.logId + ">out>", "info");
            OwProcessStreamSubject errSubject = new OwProcessStreamSubject(errStream, observer_p, this.logId + ">err>", "error");
            outSubject.start();
            errSubject.start();
            process.waitFor();
            process.destroy();
        }
        catch (IOException e) {
            throw new OwOAInstallError(e);
        }
        catch (InterruptedException e) {
            throw new OwOAInstallError(e);
        }
    }
}

