/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.ace;

import com.wewebu.ooa.OwActionObserver;
import com.wewebu.ooa.OwInstallActionBase;
import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.OwOAInstallError;
import com.wewebu.ooa.OwOAText;
import com.wewebu.ooa.OwOpenAirAlfrescoLocator;
import com.wewebu.ooa.cmis.OwCMISConnection;
import com.wewebu.ooa.cmis.OwCMISContentElementDataSource;
import com.wewebu.ooa.cmis.OwCMISPropertyNames;
import com.wewebu.ooa.data.OwDataContext;
import com.wewebu.ooa.databatch.OwAddJob;
import com.wewebu.ooa.databatch.OwContentData;
import com.wewebu.ooa.databatch.OwDataBatch;
import com.wewebu.ooa.databatch.OwDataJob;
import com.wewebu.ooa.databatch.OwDataVisitor;
import com.wewebu.ooa.databatch.OwObjectData;
import com.wewebu.ooa.databatch.OwPropertyData;
import com.wewebu.ooa.databatch.OwSetPropertiesJob;
import com.wewebu.ooa.databatch.OwValuesData;
import com.wewebu.ooa.descriptor.OwActionDescriptor;
import com.wewebu.ooa.descriptor.OwDataBatchDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.ws.Holder;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyId;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.core._200908.EnumVersioningState;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisContentStreamType;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisRepositoryEntryType;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.RepositoryServicePort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwDataBatch3xAction
extends OwInstallActionBase
implements OwDataVisitor {
    private OwDataBatchDescriptor dataBatchDescriptor;
    private OwActionObserver visitingObserver;

    public OwDataBatch3xAction(OwDataBatchDescriptor dataBatchDescriptor_p, OwOpenAirAlfrescoLocator locator_p) {
        super(locator_p);
        this.dataBatchDescriptor = dataBatchDescriptor_p;
    }

    @Override
    protected synchronized void runBare(OwActionObserver observer_p, OwDataContext context_p) throws OwOAException {
        this.visitingObserver = observer_p;
        OwDataBatch batch = this.dataBatchDescriptor.getBatch();
        batch.execute(this, context_p);
    }

    @Override
    public OwActionDescriptor getDescriptor() {
        return this.dataBatchDescriptor;
    }

    @Override
    public void undo(OwActionObserver observer_p, Throwable t_p) throws OwOAException {
    }

    @Override
    public void execute(OwDataJob job_p, OwDataContext context_p) throws OwOAInstallError {
        throw new OwOAInstallError(OwOAText.text("unknownDataJob", job_p == null ? "<null>" : job_p.toString()));
    }

    protected CmisRepositoryEntryType findRepository(OwCMISConnection connection_p, String name_p) throws OwOAException {
        try {
            RepositoryServicePort repository = connection_p.getRepositoryServicePort();
            List<CmisRepositoryEntryType> repositories = repository.getRepositories(null);
            for (CmisRepositoryEntryType repositoryEntry : repositories) {
                if (!name_p.equals(repositoryEntry.getRepositoryName())) continue;
                return repositoryEntry;
            }
            throw new OwOAInstallError("No such repository : " + name_p);
        }
        catch (CmisException e) {
            throw new OwOAInstallError(e);
        }
    }

    private CmisContentStreamType createCMISStream(InputStream stream_p, String name_p, String mimeType_p) {
        OwCMISContentElementDataSource ds = null;
        ds = new OwCMISContentElementDataSource(stream_p, name_p, mimeType_p);
        CmisContentStreamType stream = new CmisContentStreamType();
        stream.setFilename(ds.getName());
        stream.setMimeType(ds.getContentType());
        stream.setStream(new DataHandler((DataSource)ds));
        return stream;
    }

    private void addObjectTypeId(List<CmisProperty> cmisProperties_p, String typeId_p) {
        ObjectFactory cmisFactory = new ObjectFactory();
        CmisPropertyId objectTypeIdProperty = cmisFactory.createCmisPropertyId();
        objectTypeIdProperty.setPropertyDefinitionId(OwCMISPropertyNames.OBJECT_TYPE_ID.getId());
        objectTypeIdProperty.getValue().add(typeId_p);
        cmisProperties_p.add(objectTypeIdProperty);
    }

    @Override
    public void execute(OwSetPropertiesJob setPropertiesJob_p, OwDataContext context_p) throws OwOAException {
        try {
            List<OwObjectData> objects = setPropertiesJob_p.getObjects();
            OwCMISConnection connection = this.locator.newCMISConnection();
            CmisRepositoryEntryType repository = this.findRepository(connection, setPropertiesJob_p.getRepository());
            ObjectServicePort objectServicePort = connection.getObjectServicePort();
            this.visitingObserver.log("info", "Set data batch for " + connection + " -> " + setPropertiesJob_p.getRepository(), null);
            for (OwObjectData objectData : objects) {
                String path = objectData.getPath(context_p);
                this.visitingObserver.log("info", "\tset props for " + path, null);
                CmisObjectType cmisDestinationObject = objectServicePort.getObjectByPath(repository.getRepositoryId(), path, OwCMISPropertyNames.OBJECT_ID.getId(), Boolean.TRUE, EnumIncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, null);
                ObjectFactory cmisObjectFactory = new ObjectFactory();
                CmisPropertiesType cmisPropertiesType = cmisObjectFactory.createCmisPropertiesType();
                List<CmisProperty> cmisProperties = cmisPropertiesType.getProperty();
                List<OwPropertyData> properties = objectData.getProperties();
                for (OwPropertyData propertyData : properties) {
                    OwValuesData values = propertyData.getValues();
                    if (values == null) {
                        throw new OwOAInstallError("Invalid <null> property value " + propertyData.getName());
                    }
                    this.visitingObserver.log("info", "\t\tProperty " + propertyData.toString(context_p), null);
                    CmisProperty cmisProperty = propertyData.createCMISProperty(connection, repository, context_p);
                    cmisProperties.add(cmisProperty);
                }
                String destinationObjectId = OwCMISPropertyNames.OBJECT_ID.getIdValue(cmisDestinationObject);
                Holder<String> idHodler = new Holder<String>(destinationObjectId);
                objectServicePort.updateProperties(repository.getRepositoryId(), idHodler, null, cmisPropertiesType, null);
            }
        }
        catch (Exception e) {
            throw new OwOAInstallError(e);
        }
    }

    @Override
    public void execute(OwAddJob addJob_p, OwDataContext context_p) throws OwOAException {
        try {
            List<OwObjectData> objects = addJob_p.getObjects();
            OwCMISConnection connection = this.locator.newCMISConnection();
            CmisRepositoryEntryType repository = this.findRepository(connection, addJob_p.getRepository());
            ObjectServicePort objectServicePort = connection.getObjectServicePort();
            String path = addJob_p.getPath(context_p);
            CmisObjectType parent = objectServicePort.getObjectByPath(repository.getRepositoryId(), path, OwCMISPropertyNames.OBJECT_ID.getId(), Boolean.TRUE, EnumIncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, null);
            String parentId = OwCMISPropertyNames.OBJECT_ID.getIdValue(parent);
            this.visitingObserver.log("info", "Add data batch for " + connection + " -> " + addJob_p.getRepository() + "#" + path + " = " + parentId, null);
            for (OwObjectData objectData : objects) {
                this.visitingObserver.log("info", "\tadding " + objectData.getType(), null);
                OwContentData content = objectData.getContent();
                CmisContentStreamType cmisStream = null;
                if (content != null) {
                    String file = content.getFile(context_p);
                    String mime = content.getMIME(context_p);
                    this.visitingObserver.log("info", "\t\tContent " + file + " - " + mime, null);
                    File contentFile = this.dataBatchDescriptor.getDescriptorRelativeFile(file);
                    cmisStream = this.createCMISStream(new FileInputStream(contentFile), contentFile.getName(), mime);
                } else {
                    this.visitingObserver.log("info", "\t\tContent <null>", null);
                }
                ObjectFactory cmisObjectFactory = new ObjectFactory();
                CmisPropertiesType cmisPropertiesType = cmisObjectFactory.createCmisPropertiesType();
                List<CmisProperty> cmisProperties = cmisPropertiesType.getProperty();
                this.addObjectTypeId(cmisProperties, objectData.getType());
                List<OwPropertyData> properties = objectData.getProperties();
                for (OwPropertyData propertyData : properties) {
                    OwValuesData values = propertyData.getValues();
                    if (values == null) {
                        throw new OwOAInstallError("Invalid <null> property value " + propertyData.getName());
                    }
                    this.visitingObserver.log("info", "\t\tProperty " + propertyData.toString(context_p), null);
                    CmisProperty cmisProperty = propertyData.createCMISProperty(connection, repository, context_p);
                    cmisProperties.add(cmisProperty);
                }
                Holder<String> newID = new Holder<String>();
                newID.value = "";
                if (objectData.isDocument()) {
                    objectServicePort.createDocument(repository.getRepositoryId(), cmisPropertiesType, parentId, cmisStream, EnumVersioningState.MAJOR, null, null, null, null, newID);
                } else {
                    objectServicePort.createFolder(repository.getRepositoryId(), cmisPropertiesType, parentId, null, null, null, null, newID);
                }
                this.visitingObserver.log("info", "\tadded object with ID " + (String)newID.value, null);
            }
        }
        catch (CmisException e) {
            throw new OwOAInstallError(e);
        }
        catch (FileNotFoundException e) {
            throw new OwOAInstallError(e);
        }
    }

    @Override
    public boolean intercept(OwDataBatch batch_p) {
        return true;
    }

    public String toString() {
        return "[Alfresco 3xx data batch action ]";
    }
}

