/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.cmis;

import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.OwOALogger;
import com.wewebu.ooa.cmis.OwCMISSecurityHandler;
import com.wewebu.ooa.cmis.OwCMISURLBuilder;
import java.util.List;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisRepositoryEntryType;
import org.oasis_open.docs.ns.cmis.ws._200908.DiscoveryService;
import org.oasis_open.docs.ns.cmis.ws._200908.DiscoveryServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.MultiFilingService;
import org.oasis_open.docs.ns.cmis.ws._200908.MultiFilingServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.NavigationService;
import org.oasis_open.docs.ns.cmis.ws._200908.NavigationServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectService;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.PolicyService;
import org.oasis_open.docs.ns.cmis.ws._200908.PolicyServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.RelationshipService;
import org.oasis_open.docs.ns.cmis.ws._200908.RelationshipServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.RepositoryService;
import org.oasis_open.docs.ns.cmis.ws._200908.RepositoryServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.VersioningService;
import org.oasis_open.docs.ns.cmis.ws._200908.VersioningServicePort;

public class OwCMISConnection {
    private RepositoryServicePort m_repositoryServicePort;
    private ObjectServicePort m_objectServicesPort;
    private NavigationServicePort m_navigationServicePort;
    private DiscoveryServicePort m_discoveryServicePort;
    private MultiFilingServicePort m_multiFilingServicePort;
    private PolicyServicePort m_policyServicePort;
    private RelationshipServicePort m_relationshipServicePort;
    private VersioningServicePort m_versioningServicePort;
    private OwCMISSecurityHandler m_securityHandler;
    private OwCMISURLBuilder m_urlBuilder;

    public OwCMISConnection(String username_p, String password_p, OwCMISURLBuilder builder_p) {
        this.m_securityHandler = new OwCMISSecurityHandler(username_p, password_p);
        this.m_urlBuilder = builder_p;
    }

    public ObjectServicePort getObjectServicePort() throws OwOAException {
        if (this.m_objectServicesPort == null) {
            ObjectService s = new ObjectService(this.m_urlBuilder.getObjectServicePortURL());
            this.m_objectServicesPort = s.getObjectServicePort();
            this.setSecurity((BindingProvider)((Object)this.m_objectServicesPort));
        }
        return this.m_objectServicesPort;
    }

    public RepositoryServicePort getRepositoryServicePort() throws OwOAException {
        if (null == this.m_repositoryServicePort) {
            RepositoryService s = new RepositoryService(this.m_urlBuilder.getRepositoryServicePortURL());
            this.m_repositoryServicePort = s.getRepositoryServicePort();
            this.setSecurity((BindingProvider)((Object)this.m_repositoryServicePort));
        }
        return this.m_repositoryServicePort;
    }

    public NavigationServicePort getNavigationServicePort() throws OwOAException {
        if (null == this.m_navigationServicePort) {
            NavigationService s = new NavigationService(this.m_urlBuilder.getNavigationServicePortURL());
            this.m_navigationServicePort = s.getNavigationServicePort();
            this.setSecurity((BindingProvider)((Object)this.m_navigationServicePort));
        }
        return this.m_navigationServicePort;
    }

    public DiscoveryServicePort getDiscoveryServicePort() throws OwOAException {
        if (this.m_discoveryServicePort == null) {
            DiscoveryService s = new DiscoveryService(this.m_urlBuilder.getDiscoveryServicePortURL());
            this.m_discoveryServicePort = s.getDiscoveryServicePort();
            this.setSecurity((BindingProvider)((Object)this.m_discoveryServicePort));
        }
        return this.m_discoveryServicePort;
    }

    public MultiFilingServicePort getMultiFilingservicePort() throws OwOAException {
        if (this.m_multiFilingServicePort == null) {
            MultiFilingService s = new MultiFilingService(this.m_urlBuilder.getMultiFilingservicePortURL());
            this.m_multiFilingServicePort = s.getMultiFilingServicePort();
            this.setSecurity((BindingProvider)((Object)this.m_multiFilingServicePort));
        }
        return this.m_multiFilingServicePort;
    }

    public VersioningServicePort getVersionServicePort() throws OwOAException {
        if (this.m_versioningServicePort == null) {
            VersioningService s = new VersioningService(this.m_urlBuilder.getVersionServicePortURL());
            this.m_versioningServicePort = s.getVersioningServicePort();
            this.setSecurity((BindingProvider)((Object)this.m_versioningServicePort));
        }
        return this.m_versioningServicePort;
    }

    public RelationshipServicePort getRelationshipServicePort() throws OwOAException {
        if (this.m_relationshipServicePort == null) {
            RelationshipService s = new RelationshipService(this.m_urlBuilder.getRelationshipServicePortURL());
            this.m_relationshipServicePort = s.getRelationshipServicePort();
            this.setSecurity((BindingProvider)((Object)this.m_relationshipServicePort));
        }
        return this.m_relationshipServicePort;
    }

    public PolicyServicePort getPolicyServicePort() throws OwOAException {
        if (this.m_policyServicePort == null) {
            PolicyService s = new PolicyService(this.m_urlBuilder.getPolicyServicePortURL());
            this.m_policyServicePort = s.getPolicyServicePort();
            this.setSecurity((BindingProvider)((Object)this.m_policyServicePort));
        }
        return this.m_policyServicePort;
    }

    private void setSecurity(BindingProvider bp_p) {
        Binding repositoryBinding = bp_p.getBinding();
        List<Handler> repositoryHandlerChain = repositoryBinding.getHandlerChain();
        repositoryHandlerChain.add(this.getSecurityHandler());
        repositoryBinding.setHandlerChain(repositoryHandlerChain);
    }

    protected OwCMISSecurityHandler getSecurityHandler() {
        return this.m_securityHandler;
    }

    protected void removeSecurity(BindingProvider bp_p) {
        List<Handler> lst = bp_p.getBinding().getHandlerChain();
        lst.remove(this.getSecurityHandler());
        bp_p.getBinding().setHandlerChain(lst);
    }

    public void gnip(int count_p, int sleepTime_p, OwOALogger logger_p) throws OwOAException {
        int attempts = count_p;
        while (attempts > 0) {
            --attempts;
            try {
                RepositoryServicePort repository = this.getRepositoryServicePort();
                List<CmisRepositoryEntryType> repositories = repository.getRepositories(null);
                for (CmisRepositoryEntryType repositoryEntry : repositories) {
                    logger_p.log("info", "CMIS Repository " + repositoryEntry.getRepositoryName(), null);
                }
                logger_p.log("error", "Failed to gnip CMIS WS @" + this.m_urlBuilder.getName() + " >> Sleeping ... ", null);
                try {
                    if (attempts <= 0) continue;
                    Thread.sleep(sleepTime_p);
                }
                catch (InterruptedException e1) {
                    logger_p.log("error", "GNIP sleep interrupted", e1);
                }
            }
            catch (Throwable t) {
                logger_p.log("info", "Successfully gniped CMIS WS : [" + t.getMessage() + "]@" + this.m_urlBuilder.getName(), null);
                return;
            }
        }
        throw new OwOAException("ALFRESCO CMIS is running @" + this.m_urlBuilder.getName());
    }

    public void ping(int count_p, int sleepTime_p, OwOALogger logger_p) throws OwOAException {
        int attempts = count_p;
        while (attempts > 0) {
            --attempts;
            try {
                RepositoryServicePort repository = this.getRepositoryServicePort();
                List<CmisRepositoryEntryType> repositories = repository.getRepositories(null);
                for (CmisRepositoryEntryType repositoryEntry : repositories) {
                    logger_p.log("info", "\tping @ " + this.m_urlBuilder.getName() + " > " + repositoryEntry.getRepositoryName(), null);
                }
                logger_p.log("info", "Successfully pinged CMIS WS @" + this.m_urlBuilder.getName(), null);
                return;
            }
            catch (Throwable t) {
                logger_p.log("error", "Failed to ping CMIS WS : [" + t.getMessage() + "]@" + this.m_urlBuilder.getName() + " >> Sleeping ... ", null);
                if (attempts == 0) {
                    throw new OwOAException(t);
                }
                try {
                    if (attempts <= 0) continue;
                    Thread.sleep(sleepTime_p);
                }
                catch (InterruptedException e1) {
                    logger_p.log("error", "PING sleep interrupted", e1);
                }
            }
        }
        throw new OwOAException("Could nod connect to ALFRESCO CMIS @" + this.m_urlBuilder.getName());
    }

    public String toString() {
        return "[CMIS connction to " + this.m_urlBuilder.getName() + " ]";
    }
}

