/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.cmis;

import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwCMISSecurityHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger logger = Logger.getLogger(OwCMISSecurityHandler.class);
    private static String WS_SECEXT = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static String WS_SECUTILITY = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private static String WS_USER_TOKEN_PROFILE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
    private String m_password;
    private String m_username;

    public OwCMISSecurityHandler(String username_p, String password_p) {
        this.m_username = username_p;
        this.m_password = password_p;
    }

    @Override
    public boolean handleMessage(SOAPMessageContext messageContext_p) {
        if (((Boolean)messageContext_p.get("javax.xml.ws.handler.message.outbound")).booleanValue()) {
            try {
                TimeZone tz = TimeZone.getTimeZone("UTC");
                DatatypeFactory factory = DatatypeFactory.newInstance();
                GregorianCalendar now = new GregorianCalendar(tz);
                GregorianCalendar fiveMinutesLater = new GregorianCalendar(tz);
                fiveMinutesLater.add(12, 5);
                XMLGregorianCalendar xmlNow = factory.newXMLGregorianCalendar(now);
                XMLGregorianCalendar xmlFiveMinutesLater = factory.newXMLGregorianCalendar(fiveMinutesLater);
                SOAPMessage msg = messageContext_p.getMessage();
                SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
                SOAPHeader soapHeader = envelope.getHeader() != null ? envelope.getHeader() : envelope.addHeader();
                SOAPHeaderElement headerElement = soapHeader.addHeaderElement(new QName(WS_SECEXT, "Security", "wsse"));
                headerElement.setMustUnderstand(false);
                SOAPElement timestamp = headerElement.addChildElement(new QName(WS_SECUTILITY, "Timestamp", "wsu"));
                timestamp.addAttribute(new QName(WS_SECUTILITY, "Id", "wsu"), "Timestamp");
                SOAPElement created = timestamp.addChildElement(new QName(WS_SECUTILITY, "Created", "wsu"));
                created.addTextNode(xmlNow.toXMLFormat());
                SOAPElement expired = timestamp.addChildElement(new QName(WS_SECUTILITY, "Expired", "wsu"));
                expired.addTextNode(xmlFiveMinutesLater.toXMLFormat());
                SOAPElement usernameToken = headerElement.addChildElement(new QName(WS_SECEXT, "UsernameToken"));
                SOAPElement username = usernameToken.addChildElement(new QName(WS_SECEXT, "Username"));
                username.addTextNode(this.m_username);
                SOAPElement password = usernameToken.addChildElement(new QName(WS_SECEXT, "Password"));
                password.addAttribute(new QName("Type"), WS_USER_TOKEN_PROFILE);
                password.addTextNode(this.m_password);
            }
            catch (Exception ex) {
                logger.error("SOAP message handling failed!", ex);
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<QName> getHeaders() {
        return new HashSet<QName>();
    }

    @Override
    public boolean handleFault(SOAPMessageContext context_p) {
        return true;
    }

    @Override
    public void close(MessageContext context_p) {
    }
}

