/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.data;

import com.wewebu.ooa.data.OwDataContext;
import com.wewebu.ooa.data.OwDataDefinition;
import com.wewebu.ooa.data.OwDataSource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwData
implements OwDataDefinition {
    private Map<String, String> fields = new HashMap<String, String>();
    private List<OwDataSource> sources = new LinkedList<OwDataSource>();
    private String id;

    public OwData(String id_p, OwData reference_p) {
        this.id = id_p;
        this.fields = reference_p.fields;
        this.sources = reference_p.sources;
    }

    public OwData(String id_p) {
        this(id_p, new HashMap<String, String>());
    }

    public OwData(String id_p, Map<String, String> fields_p) {
        this.fields = fields_p;
        this.id = id_p;
    }

    public OwData() {
        this("#");
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    @Override
    public void setField(String name_p, String value_p) {
        this.fields.put(name_p, value_p);
    }

    @Override
    public final int getDataCount(OwDataContext context_p) {
        return 1;
    }

    @Override
    public Iterator<OwData> iterator(OwDataContext context_p) {
        return new Iterator<OwData>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public synchronized OwData next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return OwData.this;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public OwDataContext defineContext(OwDataContext parentContext_p) {
        OwDataContext context = new OwDataContext(parentContext_p, this);
        return context;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(id:");
        builder.append(this.id);
        builder.append(")");
        builder.append("fields:[");
        for (Map.Entry<String, String> property : this.fields.entrySet()) {
            builder.append("(");
            builder.append(property.getKey());
            builder.append("=");
            builder.append(property.getValue());
            builder.append(")");
        }
        builder.append("]");
        if (!this.sources.isEmpty()) {
            builder.append("children:[");
            for (OwDataSource source : this.sources) {
                builder.append("{");
                builder.append(source);
                builder.append("}");
            }
            builder.append("]");
        }
        return builder.toString();
    }

    @Override
    public void add(OwDataSource source_p) {
        this.sources.add(source_p);
    }

    public void addAll(List<OwDataSource> sources_p) {
        this.sources.addAll(sources_p);
    }

    public List<OwDataSource> getSources() {
        return this.sources;
    }
}

