/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.data;

import com.wewebu.ooa.data.OwData;
import com.wewebu.ooa.data.OwDataContext;
import com.wewebu.ooa.data.OwDataSource;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwDataCollection
implements OwDataSource {
    private List<OwDataSource> sources = new LinkedList<OwDataSource>();
    private String id;

    public OwDataCollection(String id_p) {
        this.id = id_p;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void add(OwDataSource source_p) {
        this.sources.add(source_p);
    }

    public List<OwDataSource> getSources() {
        return this.sources;
    }

    @Override
    public int getDataCount(OwDataContext context_p) {
        int count = 0;
        for (OwDataSource factory : this.sources) {
            count += factory.getDataCount(context_p);
        }
        return count;
    }

    @Override
    public Iterator<OwData> iterator(final OwDataContext context_p) {
        return new Iterator<OwData>(){
            private Iterator<OwDataSource> sourceIterator;
            private Iterator<OwData> currentSourceIterator;
            {
                this.sourceIterator = OwDataCollection.this.sources.iterator();
            }

            @Override
            public synchronized boolean hasNext() {
                OwDataSource source;
                if (this.currentSourceIterator == null && this.sourceIterator.hasNext()) {
                    source = this.sourceIterator.next();
                    this.currentSourceIterator = source.iterator(context_p);
                }
                if (this.currentSourceIterator == null) {
                    return false;
                }
                if (!this.currentSourceIterator.hasNext()) {
                    if (this.sourceIterator.hasNext()) {
                        source = this.sourceIterator.next();
                        this.currentSourceIterator = source.iterator(context_p);
                    } else {
                        return false;
                    }
                }
                return this.currentSourceIterator.hasNext();
            }

            @Override
            public synchronized OwData next() {
                if (this.hasNext()) {
                    return this.currentSourceIterator.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public OwDataContext defineContext(OwDataContext parentContext_p) {
        return new OwDataContext(parentContext_p, this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(id:");
        builder.append(this.id);
        builder.append(") children:[");
        for (OwDataSource source : this.sources) {
            builder.append("{");
            builder.append(source);
            builder.append("}");
        }
        builder.append("]");
        return builder.toString();
    }
}

