/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.data;

import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.data.OwData;
import com.wewebu.ooa.data.OwDataContext;
import com.wewebu.ooa.data.OwDataDefinition;
import com.wewebu.ooa.data.OwDataSource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwExtension
implements OwDataDefinition {
    private String collectionId;
    private String dataId;
    private String indexId;
    private Map<String, String> fieldExtensions = new HashMap<String, String>();

    public OwExtension(String collectionId_p, String dataId_p, String indexId_p) {
        this.collectionId = collectionId_p;
        this.dataId = dataId_p;
        this.indexId = indexId_p;
    }

    @Override
    public void setField(String id_p, String value_p) {
        this.fieldExtensions.put(id_p, value_p);
    }

    @Override
    public int getDataCount(OwDataContext context_p) {
        OwDataContext collectionContext = context_p.getContext(this.collectionId);
        OwDataSource collection = (OwDataSource)collectionContext.getValue();
        if (collection != null) {
            return collection.getDataCount(context_p);
        }
        return 0;
    }

    @Override
    public Iterator<OwData> iterator(OwDataContext context_p) {
        return new OwExtensionDataIterator(context_p);
    }

    @Override
    public OwDataContext defineContext(OwDataContext parentContext_p) {
        return null;
    }

    @Override
    public void add(OwDataSource source_p) {
    }

    private class OwExtensionContext
    extends OwDataContext {
        private OwExtensionDataIterator iterator;

        public OwExtensionContext(OwDataContext parentContext_p, OwExtensionDataIterator iterator_p) {
            super(parentContext_p, OwExtension.this);
            this.iterator = iterator_p;
        }

        public OwDataContext getContext(String id_p) {
            if (id_p == null) {
                return super.getContext(id_p);
            }
            if (id_p.equals(OwExtension.this.indexId)) {
                return new OwDataContext((OwDataContext)this, this.iterator.getIndex());
            }
            if (id_p.equals(OwExtension.this.dataId)) {
                OwData data = this.iterator.getLastData();
                return new OwDataContext((OwDataContext)this, data);
            }
            return super.getContext(id_p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OwExtensionDataIterator
    implements Iterator<OwData> {
        private Iterator<OwData> collectionIterator;
        private OwDataContext context;
        private int index = 0;
        private OwData lastData;

        public OwExtensionDataIterator(OwDataContext context_p) {
            this.context = new OwExtensionContext(context_p, this);
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.collectionIterator == null) {
                OwDataContext collectionContext = this.context.getContext(OwExtension.this.collectionId);
                OwDataSource source = (OwDataSource)collectionContext.getValue();
                this.collectionIterator = source.iterator(this.context);
            }
            return this.collectionIterator.hasNext();
        }

        synchronized OwData getLastData() {
            return this.lastData;
        }

        @Override
        public synchronized OwData next() {
            if (this.hasNext()) {
                OwData collectionData;
                this.lastData = collectionData = this.collectionIterator.next();
                Set extensions = OwExtension.this.fieldExtensions.entrySet();
                for (Map.Entry extension : extensions) {
                    try {
                        String value = this.context.interpret((String)extension.getValue());
                        collectionData.setField((String)extension.getKey(), value);
                    }
                    catch (OwOAException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++this.index;
                return collectionData;
            }
            throw new NoSuchElementException();
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

