/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.databatch;

import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.cmis.OwCMISConnection;
import com.wewebu.ooa.data.OwDataContext;
import com.wewebu.ooa.databatch.OwValuesData;
import java.util.LinkedList;
import java.util.List;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyBoolean;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisRepositoryEntryType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwBooleanValues
implements OwValuesData {
    private List<String> values = new LinkedList<String>();

    @Override
    public void addStringValueData(String data_p) throws OwOAException {
        if (data_p == null) {
            this.values.add("false");
        } else {
            this.values.add(data_p);
        }
    }

    private List<Boolean> toBooleanValues(OwDataContext context_p) throws OwOAException {
        LinkedList<Boolean> boolValues = new LinkedList<Boolean>();
        List<String> iValues = context_p.interpret(this.values);
        for (String value : iValues) {
            boolValues.add("true".equalsIgnoreCase(value));
        }
        return boolValues;
    }

    @Override
    public CmisPropertyBoolean createCMISProperty(OwCMISConnection connection_p, CmisRepositoryEntryType repository_p, OwDataContext context_p) throws OwOAException {
        ObjectFactory cmisFactory = new ObjectFactory();
        CmisPropertyBoolean property = cmisFactory.createCmisPropertyBoolean();
        property.getValue().addAll(this.toBooleanValues(context_p));
        return property;
    }

    public String toString() {
        return "[Boolean values = " + this.values + "]";
    }

    @Override
    public List<String> toString(OwDataContext context_p) throws OwOAException {
        return context_p.interpret(this.values);
    }
}

