/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.databatch;

import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.cmis.OwCMISConnection;
import com.wewebu.ooa.cmis.OwCMISDateTime;
import com.wewebu.ooa.data.OwDataContext;
import com.wewebu.ooa.databatch.OwValuesData;
import java.util.LinkedList;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDateTime;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisRepositoryEntryType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwDateTimeValues
implements OwValuesData {
    private List<String> values = new LinkedList<String>();

    @Override
    public void addStringValueData(String data_p) throws OwOAException {
        if (data_p == null) {
            throw new OwOAException("<null> integer data!");
        }
        this.values.add(data_p);
    }

    private List<XMLGregorianCalendar> toCalendarValues(OwDataContext context_p) throws OwOAException {
        LinkedList<XMLGregorianCalendar> calendarValues = new LinkedList<XMLGregorianCalendar>();
        List<String> iValues = context_p.interpret(this.values);
        for (String value : iValues) {
            OwCMISDateTime dateTime = new OwCMISDateTime(value);
            XMLGregorianCalendar caledar = dateTime.getXMLGregorianCalendar();
            calendarValues.add(caledar);
        }
        return calendarValues;
    }

    @Override
    public CmisPropertyDateTime createCMISProperty(OwCMISConnection connection_p, CmisRepositoryEntryType repository_p, OwDataContext context_p) throws OwOAException {
        ObjectFactory cmisFactory = new ObjectFactory();
        CmisPropertyDateTime property = cmisFactory.createCmisPropertyDateTime();
        property.getValue().addAll(this.toCalendarValues(context_p));
        return property;
    }

    public String toString() {
        return "[Datetime values = " + this.values + "]";
    }

    @Override
    public List<String> toString(OwDataContext context_p) throws OwOAException {
        return context_p.interpret(this.values);
    }
}

