/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.databatch;

import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.cmis.OwCMISConnection;
import com.wewebu.ooa.data.OwDataContext;
import com.wewebu.ooa.databatch.OwValuesData;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDecimal;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisRepositoryEntryType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwDecimalValues
implements OwValuesData {
    private List<String> values = new LinkedList<String>();

    @Override
    public void addStringValueData(String data_p) throws OwOAException {
        if (data_p == null) {
            throw new OwOAException("<null> integer data!");
        }
        this.values.add(data_p);
    }

    private List<BigDecimal> toDecimalValues(OwDataContext context_p) throws OwOAException {
        List<String> iValues = context_p.interpret(this.values);
        LinkedList<BigDecimal> decimalValues = new LinkedList<BigDecimal>();
        for (String iValue : iValues) {
            try {
                BigDecimal integer = new BigDecimal(iValue);
                decimalValues.add(integer);
            }
            catch (NumberFormatException e) {
                throw new OwOAException(e);
            }
        }
        return decimalValues;
    }

    @Override
    public CmisPropertyDecimal createCMISProperty(OwCMISConnection connection_p, CmisRepositoryEntryType repository_p, OwDataContext context_p) throws OwOAException {
        ObjectFactory cmisFactory = new ObjectFactory();
        CmisPropertyDecimal property = cmisFactory.createCmisPropertyDecimal();
        property.getValue().addAll(this.toDecimalValues(context_p));
        return property;
    }

    public String toString() {
        return "[Decimal values = " + this.values + "]";
    }

    @Override
    public List<String> toString(OwDataContext context_p) throws OwOAException {
        return context_p.interpret(this.values);
    }
}

